var TimesheetHelper = function() {
};

TimesheetHelper.prototype.init = function() {
	try {
		AP.require("cookie", function(cookie) {
			cookie.read('dismissttphelp', function(value) {
				if (value) {
					$('#ttphelp').remove();
				}
			});
		});
	} catch (err) {
	}

	GLOBAL.timesheetInit = false;
	var obj = this;
	$('[data-toggle="aio-tooltip"]').tooltip({
		template : '<div class="aio-tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
	});

	if ($('#timesheet-datepicker').length > 0) {
		var _init = function() {
			if (GLOBAL.permissionsLoaded) {
				$('#timesheet-datepicker').datepicker({
					multidate : false,
					autoclose : true,
					todayHighlight : true,
					clearBtn : true,
					format : "M-dd-yyyy",
					calendarWeeks : true,
					weekStart : 1
				});
				obj.initDates();
				obj.populateProjects();
				obj.populateIssueTypes();
				obj.userAutocomplete();
				obj.addDefaultFields();
			} else {
				setTimeout(function() {
					_init();
				}, 500);
			}
		};
		_init();
	}
};
TimesheetHelper.prototype.fieldInit = function() {
	GLOBAL.timesheetInit = false;
	if ($('#timesheet-datepicker').length > 0) {
		this.addDefaultFields(true);
	}
};

TimesheetHelper.prototype.userAutocomplete = function() {
	var autocomplete = new AioUserAutocomplete();
	autocomplete.build('timesheet-input-users');
	if (!GLOBAL.accessOtherTime) {
		this.addLoggedInUser();
		$('#timesheet-input-users').selectize()[0].selectize.disable();
		$('#timesheet_user_links').html("Your user group is restricted to personal time reporting only");
		$('#timesheet_user_links').css("font-size", "11px");
	}
};

TimesheetHelper.prototype.getDateRange = function() {
	return $('#timesheet-date-range-select').val();
};

TimesheetHelper.prototype.getStartDate = function() {
	return $('#timesheet-datepicker [name="start"]').datepicker('getUTCDate');
};

TimesheetHelper.prototype.getEndDate = function() {
	return $('#timesheet-datepicker [name="end"]').datepicker('getUTCDate');
};

TimesheetHelper.prototype.getDays = function() {
	return $('#timesheet-last-n-days [name="txtLastNDays"]').val();
};

TimesheetHelper.prototype.getProjects = function() {
	var projects = [];
	$.each($('#timesheet-select-projects').val(), function() {
		if (this.toString() !== '') {
			projects.push(this.toString());
		}
	});
	return projects;
};

TimesheetHelper.prototype.getUsers = function() {
	var users = [];
	var $select = $('#timesheet-input-users')[0].selectize;
	var valArr = $select.getValue();
	if (valArr) {
		$.each(valArr, function() {
			var val = JSON.parse(this);
			if (val.type === 'user') {
				var u = GLOBAL.userMap[val.val];
				users.push({
					'userkey' : u.userkey,
					'username' : u.username,
					'type' : 'user'
				});
			} else {
				users.push({
					'teamId' : val.val,
					'type' : 'team'
				});
			}
		});
	}
	return users;
};

TimesheetHelper.prototype.getIssueTypes = function() {
	var issueTypes = [];
	$.each($('#timesheet-select-issue-types').val(), function() {
		if (this.toString() !== '') {
			issueTypes.push(this.toString());
		}
	});
	return issueTypes;
};

TimesheetHelper.prototype.getIncludeSubTasks = function() {
	return $('#timesheet-check-sub-tasks').is(":checked");
};

TimesheetHelper.prototype.getInterval = function() {
	return $('#timesheet-date-interval').val();
};

TimesheetHelper.prototype.getIncludeNonWorklog = function() {
	return $('#timesheet-check-non-wl').is(":checked");
};

TimesheetHelper.prototype.setDateRange = function(val) {
	$('#timesheet-date-range-select').val(val);
};

TimesheetHelper.prototype.setStartDate = function(val) {
	$('#timesheet-datepicker [name="start"]').datepicker('setUTCDate', val);
};

TimesheetHelper.prototype.setEndDate = function(val) {
	$('#timesheet-datepicker [name="end"]').datepicker('setUTCDate', val);
};

TimesheetHelper.prototype.setDays = function(val) {
	$('#timesheet-last-n-days [name="txtLastNDays"]').val(val);
};

TimesheetHelper.prototype.setProjects = function(val) {
	if (val) {
		$('#timesheet-select-projects').multiselect('deselect', '');
		$.each(val, function() {
			$('#timesheet-select-projects').multiselect('select', this.toString());
		});
	}
};

TimesheetHelper.prototype.setUsers = function(val) {
	if (GLOBAL.accessOtherTime) {
		var obj = this;
		var users = val;
		var jc = new JiraClient();
		var autocomplete = new AioUserAutocomplete();
		var numOfUsers = users.length;
		if (numOfUsers === 0) {
			GLOBAL.reportLoaded = true;
		}
		var i = 0;
		var qu = [];
		var qPos = 0;
		$.each(users, function() {
			if (this.type && this.type === 'team') {
				autocomplete.addTeam('timesheet-input-users', this.teamId);
				i++;
				if (i === numOfUsers) {
					GLOBAL.reportLoaded = true;
				}
			} else {
				if (this.userkey === 'aio_loggedin_userkey') {
					obj.addLoggedInUser();
					i++;
					if (i === numOfUsers) {
						GLOBAL.reportLoaded = true;
					}
				} else {
					var cb = function(user) {
						if (qu.length > 0) {
							(qu.shift())();
						} else {
							qPos--;
						}
						autocomplete.addUser('timesheet-input-users', user);
						i++;
						if (i === numOfUsers) {
							GLOBAL.reportLoaded = true;
						}
					}
					qu.push(wrapFunction(jc.get, obj, [ 'user?key=' + this.userkey, cb, true ]));
					if (qPos < 5 && qu.length > 0) {
						qPos++;
						(qu.shift())();
					}
				}
			}
		});
	} else {
		GLOBAL.reportLoaded = true;
	}
};

TimesheetHelper.prototype.setIssueTypes = function(val) {
	if (val) {
		$('#timesheet-select-issue-types').multiselect('deselect', '');
		$.each(val, function() {
			$('#timesheet-select-issue-types').multiselect('select', this.toString());
		});
		$('#timesheet-check-sub-tasks').prop('disabled', false);
	} else {
		$('#timesheet-check-sub-tasks').prop('disabled', true);
	}
};

TimesheetHelper.prototype.setIncludeSubTasks = function(val) {
	$('#timesheet-check-sub-tasks').prop('checked', val);
};

TimesheetHelper.prototype.setIncludeNonWorklog = function(val) {
	$('#timesheet-check-non-wl').prop('checked', val);
};

TimesheetHelper.prototype.setInterval = function(val) {
	$('#timesheet-date-interval').val(val);
};

TimesheetHelper.prototype.addLoggedInUser = function() {
	var autocomplete = new AioUserAutocomplete();
	autocomplete.addUser('timesheet-input-users', {
		"key" : "aio_loggedin_userkey",
		"name" : GLOBAL.loggedInUserName,
		"displayName" : "Logged In User"
	});
};
TimesheetHelper.prototype.initDates = function() {
	var dateRange = this.getDateRange();
	var startDate = getDateRangeStartDate(dateRange, this.getStartDate(), this.getDays());
	var endDate = getDateRangeEndDate(dateRange, this.getEndDate());
	this.setStartDate(startDate);
	this.setEndDate(endDate);
	if (dateRange === 'last_n_days') {
		$('#timesheet-last-n-days').show();
		$('#timesheet-datepicker').hide();
	} else {
		$('#timesheet-last-n-days').hide();
		$('#timesheet-datepicker').show();
		if (dateRange === 'custom') {
			$('#timesheet-datepicker [name="start"]').prop('disabled', false);
			$('#timesheet-datepicker [name="end"]').prop('disabled', false);
		} else {
			$('#timesheet-datepicker [name="start"]').prop('disabled', true);
			$('#timesheet-datepicker [name="end"]').prop('disabled', true);
		}
	}
};

TimesheetHelper.prototype.populateProjects = function() {
	var jc = new JiraClient();
	var _buildProjectsSelect = function() {
		if (GLOBAL.projectsLoaded) {
			GLOBAL.projectsLoaded = true;
			var select = $('#timesheet-select-projects');
			var option = $('<option>').text('All').val('');
			select.append(option);
			$.each(GLOBAL.projects, function() {
				var option = $('<option>').text(this.name).val(this.key);
				select.append(option);
			});
			select.multiselect({
				buttonContainer : '<div class="btn-group btn-group-sm" />',
				onChange : function(option, checked) {
					if (checked) {
						if (option.val() === '') {
							select.multiselect('deselectAll');
							select.multiselect('select', option.val());
						} else {
							select.multiselect('deselect', '');
						}
					} else {
						if (option.val() === '') {
							select.multiselect('select', option.val());
						} else {
							if (select.val().length === 0) {
								select.multiselect('select', '');
							}
						}
					}
				}
			});
			select.multiselect('select', '');
		} else {
			setTimeout(function() {
				_buildProjectsSelect();
			}, 500);
		}
	};
	_buildProjectsSelect();
};

TimesheetHelper.prototype.populateIssueTypes = function() {
	var jc = new JiraClient();
	var _buildIssueTypeSelect = function() {
		if (GLOBAL.issueTypesLoaded) {
			var select = $('#timesheet-select-issue-types');
			var chkBox = $('#timesheet-check-sub-tasks');
			var option = $('<option>').text('All').data({}).val('');
			select.append(option);
			$.each(GLOBAL.parentIssueTypes, function() {
				var option = $('<option>').text(this.toString()).val(this.toString());
				select.append(option);
			});
			select.multiselect({
				buttonContainer : '<div class="btn-group btn-group-sm" />',
				onChange : function(option, checked) {
					if (checked) {
						if (option.val() === '') {
							chkBox.prop('disabled', true);
							select.multiselect('deselectAll');
							select.multiselect('select', option.val());
							chkBox.prop('checked', true);
						} else {
							chkBox.prop('disabled', false);
							select.multiselect('deselect', '');
						}
					} else {
						if (option.val() === '') {
							chkBox.prop('disabled', true);
							select.multiselect('select', option.val());
							chkBox.prop('checked', true);
						} else {
							if (select.val().length === 0) {
								chkBox.prop('disabled', true);
								select.multiselect('select', '');
							}
						}
					}
				}
			});
			select.multiselect('select', '');
			chkBox.prop('checked', true);
			chkBox.prop('disabled', true);

		} else {
			setTimeout(function() {
				_buildIssueTypeSelect();
			}, 500);
		}
	};
	_buildIssueTypeSelect();
};

TimesheetHelper.prototype.addDefaultFields = function(validate) {
	var obj = this;
	if (GLOBAL.schema.length > 0) {
		var section = rowSection('timesheet')[0];
		var fa = findField('worklog_author.displayName');
		var fp = findField('project_name');
		var fi = findField('issuekey');
		if (fa) {
			if (fieldCount(section, fa) === 0) {
				addField(section, fa);
			}
		} else {
			if (validate || GLOBAL.quickTimesheet) {
				GLOBAL.doNotAutoHideAlert = true;
				(new AioAlert()).error({
					responseText : 'Timesheet reports will not work properly because there is no work logged on any of the issues in JIRA. Please log work on at least one issue and come back to this page.'
				});
			}
		}
		if (fieldCount(section, fp) === 0) {
			addField(section, fp);
		}
		if (fieldCount(section, fi) === 0) {
			addField(section, fi);
		}
		GLOBAL.timesheetInit = true;
	} else {
		setTimeout(function() {
			obj.addDefaultFields();
		}, 500);
	}
};

TimesheetHelper.prototype.getJql = function() {
	var obj = this;
	var jql = '';
	if (!this.getIncludeNonWorklog()) {
		jql += 'worklogDate >= ' + getFormattedDate(moment(obj.getStartDate()).utc().subtract(1, 'days').toDate()) + ' and worklogDate <=' + getFormattedDate(moment(obj.getEndDate()).utc().add(1, 'days').toDate());
	}
	var projects = obj.getProjects();
	if (projects.length > 0) {
		var _projects = [];
		$.each(projects, function() {
			_projects.push("'" + this.toString() + "'");
		});
		jql += (jql === '' ? '' : ' and ') + 'project in (' + _projects.join() + ')';
	}
	if (!this.getIncludeNonWorklog()) {
		var users = obj.getUsers();
		if (users.length > 0) {
			var _users = [];
			$.each(users, function() {
				if (this.type && this.type === 'team') {
					$.each(GLOBAL.teams[this.teamId].members, function() {
						_users.push("'" + replaceAll(this.username, "\'", "\\'") + "'");
					});
				} else {
					_users.push("'" + replaceAll(this.username, "\'", "\\'") + "'");
				}
			});
			jql += (jql === '' ? '' : ' and ') + 'worklogAuthor in (' + _users.join() + ')';
		}
	}
	var issueTypes = obj.getIssueTypes();
	if (issueTypes.length > 0) {
		var _issueTypes = [];
		$.each(issueTypes, function() {
			_issueTypes.push("'" + this.toString() + "'");
		});
		if (obj.getIncludeSubTasks() && GLOBAL.subIssueTypes) {
			$.each(GLOBAL.subIssueTypes, function() {
				_issueTypes.push("'" + this.toString() + "'");
			});
		}
		jql += (jql === '' ? '' : ' and ') + 'issuetype in (' + _issueTypes.join() + ')';
	}
	if (jql === '') {
		return jql;
	}

	return '(' + jql + ')';
};

var ttphelp = function() {
	$('#dialog-time-tracking-provider').modal({
		backdrop : 'static',
		keyboard : false
	});
}
var dismissttphelp = function() {
	try {
		$('#ttphelp').remove();
		AP.require("cookie", function(cookie) {
			cookie.save('dismissttphelp', 'true', 365);
		});
	} catch (err) {
	}
}
