$(function() {
	var teh = new TimeEntryHelper();
	teh.init();
});

var TimeEntryHelper = function() {
	this.jc = new JiraClient();
	this.queue = [];
	this.callInProcess = false;
};

TimeEntryHelper.prototype.init = function() {
	var obj = this;
	obj.showLoading();
	var _init = function() {
		if (GLOBAL.schemaLoaded) {
			obj.setup();
		} else {
			setTimeout(function() {
				_init();
			}, 500);
		}
	};
	_init();

};

TimeEntryHelper.prototype.setDates = function(dateRange) {
	var obj = this;
	var startDate = getDateRangeStartDate(dateRange, null, null);
	var endDate = getDateRangeEndDate(dateRange, null);
	obj.setStartDate(startDate);
	obj.setEndDate(endDate);
}

TimeEntryHelper.prototype.updateView = function() {
	var obj = this;
	obj.callInProcess = false;
	obj.queue = [];
	GLOBAL.timeEntryStartTime = obj.getStartDate().getTime() - GLOBAL.tzOffsetRaw;
	var rs = new ReportService();
	rs.run();
	obj.showLoading();
}
TimeEntryHelper.prototype.addIssues = function() {
	var obj = this;
	GLOBAL.timeEntryIssues = $('#async-issue-select')[0].selectize.getValue();
	$('#dialog-issue-selector').modal('hide');
	obj.updateView();
}

TimeEntryHelper.prototype.buildIssueSelector = function() {

	var obj = this;
	var fetch = function(query, callback) {
		if (query === '') {
			callback([], query);
			return;
		}
		var r = [];
		obj.jc.post('search', {
			jql : 'summary ~ "' + query + '" or description ~ "' + query + '"',
			fields : [ 'issuekey', 'summary' ]
		}, function(results, error) {
			$.each(results.issues, function() {
				r.push({
					label : this.fields.summary,
					value : this.key
				});
			});
			obj.jc.post('search', {
				jql : 'issuekey=' + query,
				fields : [ 'issuekey', 'summary' ]
			}, function(results, error) {
				if (!error) {
					$.each(results.issues, function() {
						r.push({
							label : this.fields.summary,
							value : this.key
						});
					});
				}
				$.each(r, function() {
					this.label = this.value + ' - ' + this.label
				})
				callback(r, query);
			}, true);
		}, true);
	};
	var ele = $("#async-issue-select");
	ele.selectize({
		valueField : 'value',
		labelField : 'label',
		searchField : [ 'label' ],
		options : [],
		create : false,
		highlight : true,
		hideSelected : true,
		preload : 'focus',
		placeholder : ele.attr('placeholder') ? ele.attr('placeholder') : 'Start typing...',
		maxItems : null,
		load : function(query, callback) {
			fetch(query, callback);
		},
		onItemAdd : function(value, $item) {
			$item[0].innerHTML = $item[0].innerHTML.substring(0, $item[0].innerHTML.indexOf(' - '));
		}
	});
}

TimeEntryHelper.prototype.save = function() {

	return ""// "worklogAuthor in ('" + GLOBAL.loggedInUserName + "')";
};
TimeEntryHelper.prototype.getJql = function(startDate, endDate) {
	var jql = '';
	jql += "(worklogAuthor in (\"" + GLOBAL.loggedInUserName + "\") and (worklogDate >= " + getFormattedDate(addDays(startDate, -7)) + " and worklogDate <= " + getFormattedDate(addDays(endDate, 1)) + "))";
	// jql += " OR (assignee changed TO (\"" + GLOBAL.loggedInUserName
	// + "\") after startOfWeek(-2) and resolved is null)"
	if (GLOBAL.timeEntryIssues && GLOBAL.timeEntryIssues.length > 0) {
		jql += " OR issuekey in (" + GLOBAL.timeEntryIssues.join() + ")"
	}
	return jql;
};

TimeEntryHelper.prototype.renderComplete = function() {
	var obj = this;
	$('.input-container > input').focus(function() {
		obj.handleFocus(this);
	});
}
TimeEntryHelper.prototype.myWls = function(issueKey, date, cb) {
	var obj = this;
	var wlStart = GLOBAL.timeEntryStartTime + (date * 86400000);
	var wlEnd = wlStart + 86400000 - 1;
	obj.jc.get('issue/' + issueKey + '/worklog', function(resp) {
		var t = resp.total;
		var wls = resp.worklogs;
		var myWls = [];
		$.each(wls, function() {
			if (this.author.name === GLOBAL.loggedInUserName) {
				var wlTime = moment(this.started).toDate().getTime();
				if (wlTime >= wlStart && wlTime <= wlEnd) {
					myWls.push(this);
				}
			}
		});
		cb(myWls);
	});
}

TimeEntryHelper.prototype.handleFocus = function(input) {
	$(input).css({
		'cursor' : 'progress'
	});
	var obj = this;
	obj.closeBox();
	var issueKey = obj.getIssueKey(input);
	var date = $(input).data().date;
	obj.myWls(issueKey, date, function(wls) {
		obj.showBox(input, wls, issueKey);
	});
}

TimeEntryHelper.prototype.handleWl = function(input, data) {
	var obj = this;
	var t = $(input).val();
	var totInput = $(input).closest('table').parent().parent().find('input:first');
	if (t !== data.value) {
		var issueKey = data.key;
		var wlId = $(input).parent().parent().data('wlid');
		if (wlId) {
			$(totInput).css('background', '#ecb5ae');
			obj.updateWl(input, data, issueKey, wlId, totInput);
			return;
		} else {
			if (data.wlAttr === 'timeSpentSeconds' && Number(t) > 0) {
				$(totInput).css('background', '#ecb5ae');
				obj.createWl(input, data, issueKey, totInput);
				return;
			}
		}
	}
	obj.doNext();
}

TimeEntryHelper.prototype.createWl = function(input, data, issueKey, totInput) {
	var obj = this;
	var worklog = {
		"timeSpentSeconds" : Number($(input).val()) * 60 * 60,
		"started" : moment(GLOBAL.timeEntryStartTime + (data.date * 86400000)).format('YYYY-MM-DDTHH:mm:ss.SSSZZ')
	}
	$('#saveMsg').show();
	obj.jc.post('issue/' + issueKey + '/worklog', worklog, function(resp, error) {
		if (error) {
			(new AioAlert()).error(resp);
		} else {
			$(input).parent().parent().data('wlid', resp.id);
			$(input).parent().parent().find('td:first').html(resp.id);
			obj.updateBoxVal(input, data, totInput);
		}
		$('#saveMsg').hide();
		obj.doNext();
	}, true);
}

TimeEntryHelper.prototype.updateWl = function(input, data, issueKey, wlId, totInput) {
	var obj = this;
	var wlAttr = data.wlAttr;
	var wlVal = $(input).val();
	if (wlAttr === 'timeSpentSeconds') {
		wlVal = Number(wlVal) * 60 * 60;
		if (wlVal === 0) {
			obj.deleteWl(input, data, issueKey, wlId, totInput);
			return;
		}
	}
	var worklog = JSON.parse('{"' + wlAttr + '" : "' + wlVal + '"}');
	$('#saveMsg').show();
	obj.jc.post('issue/' + issueKey + '/worklog/' + wlId, worklog, function(resp, error) {
		if (error) {
			(new AioAlert()).error(resp);
		} else {
			obj.updateBoxVal(input, data, totInput);
		}
		$('#saveMsg').hide();
		obj.doNext();
	}, true, false, true);
}

TimeEntryHelper.prototype.deleteWl = function(input, data, issueKey, wlId, totInput) {
	var obj = this;
	$('#saveMsg').show();
	obj.jc.get('issue/' + issueKey + '/worklog/' + wlId, function(resp, error) {
		if (error) {
			(new AioAlert()).error(resp);
		} else {
			$(input).parent().parent().remove();
			obj.updateBoxVal(input, data, totInput);
		}
		$('#saveMsg').hide();
		obj.doNext();
	}, true, false, true);
}

TimeEntryHelper.prototype.updateBoxVal = function(input, data, totInput) {
	var obj = this;
	obj.myWls(data.key, data.date, function(wls) {
		var total = 0;
		$.each(wls, function() {
			total += this.timeSpentSeconds;
		});
		$(totInput).val(total / 3600);
		obj.updateTotals(totInput);
		$(totInput).css('background', '#fff');

	});
}

TimeEntryHelper.prototype.showBox = function(input, wls, issueKey) {
	var obj = this;
	obj.closeBox();
	$(input).parent().css('border-color', '#999');
	$(input).parent().parent().append(div = $('<div class="hide-border"></div>'));
	$(input).parent().parent().append(div = $('<div class="hover-div"></div>'));
	$(div).html(tmpl("tmpl-worklogs", wls));
	var d = '<div style="text-align:right;width:100%" tabindex="-1"><span id="saveMsg" style="float:left;margin-top:6px;display:none;font-size:12px;font-weight:bold"><i>Saving...</i><span></div>';
	var b = '<button type="button" class="btn btn-link btn-sm" tabindex="-1">Add new row</button>';
	$(div).append($(d).append(btn = $(b)));
	$(btn).click(function() {
		var r = obj.addNewRow($(div).find('tbody:first'));
		$(r).find(':input').each(function() {
			obj.setRowDataAndEvents(this, input, issueKey)
		});
		$(r).find('i').each(function() {
			obj.setDeleteEvent(this);
		})
	});
	obj.addNewRow($(div).find('tbody:first'));
	$('.time-entry-row :input').each(function() {
		obj.setRowDataAndEvents(this, input, issueKey)
	});
	$('.time-entry-row i').each(function() {
		obj.setDeleteEvent(this);
	});

	$(input).parent().parent().find('input:eq(1)').focus();
	$(input).css({
		'cursor' : 'pointer'
	});
}
TimeEntryHelper.prototype.closeBox = function() {
	$('.input-container').css('border-color', '#fff');
	$('.hover-div').remove();
	$('.hide-border').remove();
}

TimeEntryHelper.prototype.getIssueKey = function(input) {
	var issueKey = $(input).data().key;
	issueKey = issueKey.substring(issueKey.indexOf('>') + 1);
	issueKey = issueKey.substring(0, issueKey.indexOf('<'));
	return issueKey;
}

TimeEntryHelper.prototype.doNext = function() {
	var obj = this;
	if (obj.queue.length > 0) {
		obj.callInProcess = true;
		(obj.queue.shift())();
	} else {
		obj.callInProcess = false;
	}
}
TimeEntryHelper.prototype.setStartDate = function(val) {
	$('#aio-time-entry-calendar [name="start"]').datepicker('setUTCDate', val);
};

TimeEntryHelper.prototype.setEndDate = function(val) {
	$('#aio-time-entry-calendar [name="end"]').datepicker('setUTCDate', val);
};

TimeEntryHelper.prototype.getStartDate = function() {
	return $('#aio-time-entry-calendar [name="start"]').datepicker('getUTCDate');
};

TimeEntryHelper.prototype.getEndDate = function() {
	return $('#aio-time-entry-calendar [name="end"]').datepicker('getUTCDate');
};
TimeEntryHelper.prototype.showLoading = function() {
	$('#aio-report-results').html('<div style="margin:50px 0 70px 0;width:100%;text-align:center;"><img src="' + GLOBAL.resourcePath + '/images/loading_big.gif" height="75px"/></div>');

};

TimeEntryHelper.prototype.movePrevious = function() {
	var obj = this;
	if (GLOBAL.timeEntryView === 'MONTHLY') {
		obj.setStartDate(moment(obj.getStartDate()).subtract(1, 'months').toDate());
		obj.setEndDate(moment(obj.getStartDate()).endOf("month").toDate());
	} else {
		obj.setStartDate(moment(obj.getStartDate()).subtract(1, 'weeks').toDate());
		obj.setEndDate(moment(obj.getEndDate()).subtract(1, 'weeks').toDate());
	}
	obj.updateView();
};

TimeEntryHelper.prototype.moveNext = function() {
	var obj = this;
	if (GLOBAL.timeEntryView === 'MONTHLY') {
		obj.setStartDate(moment(obj.getStartDate()).add(1, 'months').toDate());
		obj.setEndDate(moment(obj.getStartDate()).endOf("month").toDate());
	} else {
		obj.setStartDate(moment(obj.getStartDate()).add(1, 'weeks').toDate());
		obj.setEndDate(moment(obj.getEndDate()).add(1, 'weeks').toDate());
	}
	obj.updateView();
};

TimeEntryHelper.prototype.switchView = function() {
	var obj = this;
	if (GLOBAL.timeEntryView === 'MONTHLY') {
		GLOBAL.timeEntryView = 'WEEKLY';
		$('#time-entry-switch').html('Switch to monthly view');
		obj.setDates('current_last_week');
		obj.updateView();
	} else {
		GLOBAL.timeEntryView = 'MONTHLY'
		$('#time-entry-switch').html('Switch to weekly view');
		obj.setDates('current_month');
		obj.updateView();
	}
};

TimeEntryHelper.prototype.setup = function() {
	var obj = this;

	$('#aio-time-entry-calendar').datepicker({
		multidate : false,
		autoclose : true,
		todayHighlight : true,
		clearBtn : true,
		format : "M-dd-yyyy",
		calendarWeeks : true,
		weekStart : 1
	});

	$('#btn-refresh-time-entry').on('click', function() {
		// obj.save();
		obj.updateView();
	});
	$('#time-entry-prev').on('click', function() {
		obj.movePrevious();
	});
	$('#time-entry-next').on('click', function() {
		obj.moveNext();
	});
	$('#time-entry-switch').on('click', function() {
		obj.switchView();
	});
	$('#time-entry-add-issue').on('click', function() {
		$('#dialog-issue-selector').modal({
			backdrop : 'static',
			keyboard : false
		});
		obj.buildIssueSelector();

	});
	$('#btn-dialog-issue-select-save').on('click', function() {
		obj.addIssues();
	});

	$('body').on('click', function(event) {
		if ($(event.target).closest('.ts-data').length === 0) {
			obj.closeBox();
		}
	});
	obj.setDates('current_last_week');
	obj.updateView();
}

TimeEntryHelper.prototype.addNewRow = function(ele) {
	var newRow = $('<tr data-wlid="" class="time-entry-row">' + '<td>New</td>' + '<td data-wlattr="timeSpentSeconds"><input class="time-entry-input" maxlength="5"/></td>' + '<td data-wlattr="comment"><textarea rows="1" cols="20" ></textarea></td>' + '<td><i class="fa fa-trash-o" aria-hidden="true"></i></td>' + '</tr>');
	$(ele).append(newRow);
	return newRow;
}
TimeEntryHelper.prototype.setRowDataAndEvents = function(ele, parent, issueKey) {
	var obj = this;
	$(ele).data('value', $(ele).val());
	$(ele).data('key', issueKey);
	$(ele).data('date', $(parent).data().date);
	$(ele).data('wlAttr', $(ele).parent().data('wlattr'));
	if ($(ele).data('wlAttr') === 'timeSpentSeconds') {
		$(ele).keypress(function(event) {
			if (!numbersOnly(this, event)) {
				event.preventDefault();
			}
		});
		$(ele).keyup(function(event) {
			if (Number($(this).val()) > 24) {
				$(this).val($(this).val().slice(0, -1));
			}
		});
	}

	$(ele).blur(function() {
		obj.queue.push(wrapFunction(obj.handleWl, obj, [ ele, $(ele).data() ]));
		if (!obj.callInProcess) {
			obj.doNext();
		}
	});
}

TimeEntryHelper.prototype.setDeleteEvent = function(ele, parent) {
	var obj = this;
	$(ele).css('cursor', 'pointer');
	$(ele).hover(function() {
		$(this).css("color", "#d14836");
	}, function() {
		$(this).css("color", "#333");
	});
	$(ele).parent().css('vertical-align', 'middle');
	$(ele).click(function() {
		var wlId = $(this).parent().parent().data('wlid');
		if (wlId) {
			var timeInput = $(this).parent().parent().find('td[data-wlattr="timeSpentSeconds"]').find('input');
			$(timeInput).val(0);
			$(timeInput).trigger('blur');
		} else {
			$(this).parent().parent().remove();
		}
	});
}

TimeEntryHelper.prototype.updateTotals = function(totInput) {

	var add = function(v, t) {
		if (!isNaN(v)) {
			t += Number(v);
		}
		return t;
	}

	var clsUntil = 'tr:has(td.aio-gh-0)';
	var $ti = $(totInput);
	if ($ti.data()) {
		var $titr = $(totInput).parent().parent().parent();
		var $hdr = $titr.prevUntil(clsUntil);
		if ($hdr.length > 0) {
			$hdr = $($hdr[$hdr.length - 1]).prev();
		} else {
			$hdr = $titr.prev();
		}

		// update header column total
		var total = 0;
		$hdr.nextUntil(clsUntil).find('td.ts-data:nth-child(' + ($ti.data().date + 3) + ') input:first').each(function() {
			total = add($(this).val(), total);
		});
		$hdr.find('td:nth-child(' + ($ti.data().date + 2) + ') pre').html(total);

		// update header row total
		total = 0;
		$hdrtd = $hdr.find('td.aio-total pre');
		$hdrtd.each(function(i, e) {
			if (i < ($hdrtd.length - 1)) {
				total = add($(e).html(), total);
			}
		});
		$($hdrtd[$hdrtd.length - 1]).html(total);

		// update footer column total
		total = 0;
		$('.table tr:has(td.aio-gh-0) td:nth-child(' + ($ti.data().date + 2) + ') pre').each(function() {
			total = add($(this).html(), total);
		});
		$('.table tfoot tr td:nth-child(' + ($ti.data().date + 2) + ') pre').html(total);

		// update row total
		total = 0;
		$titr.find('td.ts-data').each(function() {
			total = add($(this).find('input:first').val(), total);
		});
		$titr.find('td.aio-total pre').html(total);

		// update footer row total
		total = 0;
		var $tftd = $('.table tfoot tr td.aio-total pre');
		$tftd.each(function(i, e) {
			if (i < ($tftd.length - 1)) {
				total = add($(e).html(), total);
			}
		});
		$($tftd[$tftd.length - 1]).html(total);
	}
}