var TimeInStatusHelper = function() {
};

TimeInStatusHelper.prototype.init = function() {
	if ($('#time-in-status-select-projects').length > 0) {
		this.populateProjects();
		this.populateStatuses();
		this.addDefaultFields();
		$('#aio-tis-measure').change(function() {
			if ($(this).val().indexOf('changelog_status') > -1) {
				$('#aio-tis-measure-filter').show();
			} else {
				$('#aio-tis-measure-filter').hide();
			}
		})
	}
};
TimeInStatusHelper.prototype.fieldInit = function() {
	this.addDefaultFields(true);
};

TimeInStatusHelper.prototype.getProjects = function() {
	var projects = [];
	$.each($('#time-in-status-select-projects').val(), function() {
		if (this.toString() !== '') {
			projects.push(this.toString());
		}
	});
	return projects;
};

TimeInStatusHelper.prototype.getStatuses = function() {
	var statuses = [];
	$.each($('#time-in-status-select-statuses').val(), function() {
		if (this.toString() !== '') {
			statuses.push(this.toString());
		}
	});
	if (statuses.length > 0) {
		return statuses.join();
	}
	return '';
};

TimeInStatusHelper.prototype.setProjects = function(val) {
	if (val) {
		$('#time-in-status-select-projects').multiselect('deselect', '');
		$.each(val, function() {
			$('#time-in-status-select-projects').multiselect('select',
					this.toString());
		});
	}
};

TimeInStatusHelper.prototype.setStatuses = function(val) {
	if (val) {
		var filterValue = val.filterValue;
		if (filterValue) {
			var statuses = JSON.parse(filterValue).rules[0].value.split(",");
			$('#time-in-status-select-statuses').multiselect('deselect', '');
			$.each(statuses, function() {
				$('#time-in-status-select-statuses').multiselect('select',
						this.toString());
			});
		}
	}
};

TimeInStatusHelper.prototype.setMeasure = function(val) {
	if (val) {
		$('#aio-tis-measure').val(val);
	}
};

TimeInStatusHelper.prototype.populateProjects = function() {
	var jc = new JiraClient();
	jc.get('project', function(results) {
		GLOBAL.projectsLoaded = true;
		var select = $('#time-in-status-select-projects');
		var option = $('<option>').text('All').val('');
		select.append(option);
		$.each(results, function() {
			var option = $('<option>').text(this.name).val(this.key);
			select.append(option);
		});
		select.multiselect({
			buttonContainer : '<div class="btn-group btn-group-sm" />',
			onChange : function(option, checked) {
				if (checked) {
					if (option.val() === '') {
						select.multiselect('deselectAll');
						select.multiselect('select', option.val());
					} else {
						select.multiselect('deselect', '');
					}
				} else {
					if (option.val() === '') {
						select.multiselect('select', option.val());
					} else {
						if (select.val().length === 0) {
							select.multiselect('select', '');
						}
					}
				}
			}
		});
		select.multiselect('select', '');
	});
};

TimeInStatusHelper.prototype.populateStatuses = function() {
	var jc = new JiraClient();
	jc.get('status', function(results) {
		GLOBAL.statusesLoaded = true;
		var select = $('#time-in-status-select-statuses');
		var option = $('<option>').text('All').val('');
		select.append(option);
		$.each(results, function() {
			var option = $('<option>').text(this.name).val(this.name);
			select.append(option);
		});
		select.multiselect({
			buttonContainer : '<div class="btn-group btn-group-sm" />',
			onChange : function(option, checked) {
				if (checked) {
					if (option.val() === '') {
						select.multiselect('deselectAll');
						select.multiselect('select', option.val());
					} else {
						select.multiselect('deselect', '');
					}
				} else {
					if (option.val() === '') {
						select.multiselect('select', option.val());
					} else {
						if (select.val().length === 0) {
							select.multiselect('select', '');
						}
					}
				}
			}
		});
		select.multiselect('select', '');
	});
};

TimeInStatusHelper.prototype.addDefaultFields = function(validate) {
	var obj = this;
	if (GLOBAL.schema.length > 0) {
		var section = rowSection('time-in-status')[0];
		var fi = findField('issuekey');
		if (fieldCount(section, fi) === 0) {
			addField(section, fi);
		}
	} else {
		setTimeout(function() {
			obj.addDefaultFields();
		}, 500);
	}
};

TimeInStatusHelper.prototype.getJql = function() {
	var obj = this;
	var jql = '';
	var projects = obj.getProjects();
	if (projects.length > 0) {
		var _projects = [];
		$.each(projects, function() {
			_projects.push("'" + this.toString() + "'");
		});
		jql += ' and project in (' + _projects.join() + ')';
	}
	return '(' + jql + ')';
};
