$(function() {
	$('[data-toggle="aio-tooltip"]').tooltip({
		template : '<div class="aio-tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
	});
	try {
		$(".table").tablesorter({
			sortList : [ [ 0, 0 ] ]
		});
	} catch (err) {
	}

	$('#btn-dialog-share-team-save').click(function() {
		var tb = new TeamBuilder();
		tb.shareTeam();
	});

});
var createTeam = function() {
	GLOBAL.teamId = null;
	var autocomplete = new AioUserAutocomplete();
	$('#dialog-team').modal({
		backdrop : 'static',
		keyboard : false
	});

	autocomplete.build('team-user-select', true);

};
var updateTeam = function(teamId) {
	GLOBAL.teamId = teamId;
	var autocomplete = new AioUserAutocomplete();
	$('#dialog-team').modal({
		backdrop : 'static',
		keyboard : false
	});
	var team = GLOBAL.teams[teamId];
	$('#team-name-txt').val(team.name);
	autocomplete.build('team-user-select', true);
	var $select = $('#team-user-select').selectize();
	var control = $select[0].selectize;
	control.clear();

	var jc = new JiraClient();

	$.each(team.members, function() {
		jc.get('user?key=' + this.userkey, function(user) {
			autocomplete.addUser('team-user-select', user);
		});
	});
};
var deleteTeam = function(teamId, nos) {
	GLOBAL.teamId = teamId;
	$('#dialog-delete-team-share-count').html('');
	if (nos > 0) {
		$('#dialog-delete-team-share-count').html('<br/>This team is shared with ' + nos + ' other user(s).');
	}
	if (nos === -1) {
		$('#dialog-delete-team-confirm').html('Confirm that you want to remove this team share.');
	} else {
		$('#dialog-delete-team-confirm').html('Confirm that you want to delete this team.');
	}

	$('#dialog-delete-team').modal({
		backdrop : 'static',
		keyboard : false
	});
};
var shareTeam = function(teamId) {
	GLOBAL.teamId = teamId;
	var ac = new AioClient();
	var jc = new JiraClient();
	var autocomplete = new AioUserAutocomplete();
	autocomplete.build('async-user-single-select', true);
	ac.get('shareTeamUsers', function(results) {
		$.each(results, function() {
			jc.get('user?key=' + this.userkey, function(user) {
				autocomplete.addUser('async-user-single-select', user);
			});
		});
	}, 'aioTeamId=' + teamId);

	$('#dialog-share-team').modal({
		backdrop : 'static',
		keyboard : false
	});
};
var TeamBuilder = function() {
};
TeamBuilder.prototype.save = function() {
	var name = $('#team-name-txt').val();
	if (!name) {
		(new AioAlert()).warning('Please provide a name for the team');
		return;
	}
	var users = [];
	var valArr = $('#team-user-select')[0].selectize.getValue();
	if (valArr) {
		$.each(valArr, function() {
			users.push(GLOBAL.userMap[JSON.parse(this).val]);
		});
	}
	if (users.length === 0) {
		(new AioAlert()).warning('Please add members to the team');
		return;
	}
	var dto = new AioDto();
	dto.team = {
		'teamId' : GLOBAL.teamId,
		'name' : name,
		'members' : JSON.stringify(users)
	};

	(new AioClient()).post('saveTeam', dto, function(results) {
		(new AioAlert()).success('Team created successfully');
		$('#dialog-team').modal('hide');
		setTimeout(function() {
			window.location = window.location;
		}, 500);
	});

};
TeamBuilder.prototype.deleteTeam = function() {
	(new AioClient()).post('deleteTeam', GLOBAL.teamId, function(results) {
		(new AioAlert()).success('Team deleted successfully');
		$('#dialog-delete').modal('hide');
		setTimeout(function() {
			window.location = window.location;
		}, 500);
	});
};
TeamBuilder.prototype.shareTeam = function() {
	var users = [];
	var valArr = $('#async-user-single-select')[0].selectize.getValue();
	if (valArr) {
		$.each(valArr, function() {
			users.push(GLOBAL.userMap[JSON.parse(this).val]);
		});
	}
	(new AioClient()).post('shareTeam', {
		'ID' : GLOBAL.teamId,
		'users' : users
	}, function(results) {
		(new AioAlert()).success('Team shared successfully');
		$('#dialog-share-team').modal('hide');
		setTimeout(function() {
			window.location = window.location;
		}, 500);
	});
};
