$(function() {
	GLOBAL.doNotAutoHideAlert = true;
	var myConnector = tableau.makeConnector();
	$('#view_dataSource').show();
	$('#view_fields').hide();
	var jql = getTableauDataVal('jql');
	if (jql) {
		$('#jql').val(jql);
	}
	var splitArray = getTableauDataVal('splitArray');
	if (splitArray) {
		$('#splitArrayTrue').prop('checked', 'checked');
	}
	if (tableau.connectionName) {
		$('#dsName').val(tableau.connectionName);
	}
	myConnector.getSchema = function(schemaCallback) {
		var schema = getTableauDataVal('schema');
		var selectedFieldIds = getTableauDataVal('selectedFieldIds');
		var splitArray = getTableauDataVal('splitArray');
		var cols_issues = [];
		var cols_worklog = [];
		var cols_history = [];
		var hasWorklog = false;
		var hasHistory = false;
		var arrayCols = [];
		var issueKeyCol = null;

		var id_columnNameMap = {};
		$.each(selectedFieldIds, function() {
			var field = findFieldInSchema(this, schema);
			if (field && field.reportable) {
				var _id = field.id.replace('.', '_');
				_id = _id.replace('.', '_');
				id_columnNameMap[field.columnName] = _id;
				var dataType = tableau.dataTypeEnum.string;
				if (field.type === 'NUMBER') {
					dataType = floatdataType;
				} else {
					if (field.type === 'TIMESTAMP') {
						dataType = tableau.dataTypeEnum.datetime;
					}
				}
				var col = {
					id : _id,
					alias : field.name,
					dataType : dataType
				};
				if (_id.indexOf('worklog_') === 0) {
					cols_worklog.push(col);
					hasWorklog = true;
				} else {
					if (_id.indexOf('changelog_') === 0) {
						cols_history.push(col);
						hasHistory = true;
					} else {
						if (splitArray && isArray(field)) {
							arrayCols.push(col);
						} else {
							cols_issues.push(col);
							if (_id === 'issuekey') {
								issueKeyCol = col;
								cols_worklog.push(JSON.parse(JSON.stringify(col)));
								cols_history.push(JSON.parse(JSON.stringify(col)));
							}
						}
					}
				}
			}
		});
		setTableauDataVal('id_columnNameMap', id_columnNameMap);
		var issuesTableInfo = {
			id : "jiraIssues",
			alias : "JIRA Issues",
			columns : cols_issues
		};
		var worklogTableInfo = {
			id : "jiraIssueWorklogs",
			alias : "JIRA Issue Worklogs",
			columns : cols_worklog
		};
		var historyTableInfo = {
			id : "jiraIssueHistory",
			alias : "JIRA Issue History",
			columns : cols_history
		};
		var tables = [ issuesTableInfo ];

		if (hasWorklog) {
			tables.push(worklogTableInfo);
		}
		if (hasHistory) {
			tables.push(historyTableInfo);
		}
		$.each(arrayCols, function() {
			tables.push({
				id : "_aioarr_" + this.id + '',
				alias : "JIRA " + this.alias,
				columns : [ JSON.parse(JSON.stringify(issueKeyCol)), this ]
			});
		})
		schemaCallback(tables);
	};

	myConnector.getData = function(table, doneCallback) {
		var url = 'tableau_issues';
		var id_columnNameMap = getTableauDataVal('id_columnNameMap');
		var arr = (table.tableInfo.id.indexOf('_aioarr_') === 0);
		if (table.tableInfo.id == "jiraIssueWorklogs") {
			url = 'tableau_issue_worklogs';
		}
		if (table.tableInfo.id == "jiraIssueHistory") {
			url = 'tableau_issue_history';
		}
		var selectedFieldIds = getTableauDataVal('selectedFieldIds');
		if (arr) {
			selectedFieldIds = [];
			$.each(table.tableInfo.columns, function() {
				selectedFieldIds.push(this.id);
			})
		}
		var fetch = function(start, size) {
			var tableData = [];
			ajaxPost(url, {
				'jql' : getTableauDataVal('jql'),
				'schema' : getTableauDataVal('schema'),
				'selectedFieldIds' : selectedFieldIds,
				'start' : start
			}, function(resp) {
				if (arr) {
					$.each(resp.results, function(idx, obj) {
						var issuekey = null;
						var arrval = null;
						var valKey = null;

						$.each(obj, function(key, val) {
							if (id_columnNameMap[key] === 'issuekey') {
								issuekey = val;
							} else {
								valKey = key;
								arrval = val;
							}
						});

						if (arrval !== null) {
							$.each(arrval.split('\n'), function() {
								var row = {};
								row['issuekey'] = issuekey;
								row[id_columnNameMap[valKey]] = this;
								tableData.push(row);
							});
						}
					});
				} else {
					$.each(resp.results, function(idx, obj) {
						var row = {};
						$.each(obj, function(key, val) {
							if (val !== null) {
								row[id_columnNameMap[key]] = val;
							}
						});
						tableData.push(row);
					});
				}
				var totalFetched = start + resp.fetched;
				tableau.reportProgress(("Issues fetched" + (url === 'tableau_issue_worklogs' ? ' (for worklogs): ' : ': ')) + totalFetched + ' of ' + size + ' (' + ((totalFetched * 100 / size) | 0)
						+ '%)');
				table.appendRows(tableData);
				if (totalFetched >= size) {
					doneCallback();
				} else {
					fetch(totalFetched, size);
				}
			}, true, 1);
		};

		ajaxPost('validateJql', {
			'jql' : getTableauDataVal('jql')
		}, function(size) {
			var fetched = 0;
			fetch(fetched, size);
		});

	};
	tableau.registerConnector(myConnector);

	var selectFields = function() {
		if (GLOBAL.schemaReady) {
			(new AioAlert()).hide();
			$('#view_dataSource').hide();
			$('#view_fields').show();
		} else {
			(new AioAlert()).info('Loading schema..');
			setTimeout(function() {
				selectFields();
			}, 500);
		}
	};
	$("#btnContinue").click(
			function() {
				var jql = $('#jql').val().trim();
				var dsName = $('#dsName').val().trim();
				if (dsName === '') {
					dsName = 'All-In-One Tableau Connector for JIRA Cloud-' + (new Date()).getTime();
				}

				setTableauDataVal('jql', jql);
				setTableauDataVal('splitArray', $('#splitArrayTrue').is(':checked'));
				tableau.connectionName = dsName;

				ajaxPost('validateJql', {
					'jql' : jql,
					'tableauAccessCode' : $('#tableauAccessCode').val()
				}, function(size) {
					if (size > 1000) {
						$('#numberOfRecords').html(size);
						$('#dialog-large-size-warning').modal({
							backdrop : 'static',
							keyboard : false
						});
					} else {
						var lang = 'issues';
						if (size === 1) {
							lang = 'issue';
						}
						(new AioAlert()).success('JQL is valid. <b>' + size + '</b> ' + lang + ' will be fetched from JIRA and imported into Tableau. <br/><br/>'
								+ 'Please select the fields to be imported and click <b>"Continue"</b> to proceed.');
						selectFields();
					}
				});
			});
	$("#btnContinue2").click(function() {
		var selectedIds = [];
		$("input[type=checkbox]:checked").each(function() {
			selectedIds.push($(this).attr('id').toString());
		});
		if (selectedIds.length === 0) {
			(new AioAlert().error('Please select at least one field'));
		} else {
			setTableauDataVal('selectedFieldIds', selectedIds);
			tableau.submit();
		}

	});

	$('#btn-large-size-continue').click(function() {
		$('#dialog-large-size-warning').modal('hide');
		selectFields();
	});

	ajaxPost('tableau_schema', {}, function(schema) {
		GLOBAL.schemaReady = false;
		var html = '';
		var workLogFields = [];
		var historyFields = [];
		var uniqGroups = {};
		var addTable = function(grp, fields) {
			var i = 0;
			var grpChkId = 'aio_group_' + replaceAll(grp, ' ', '_');
			var closed = false;
			html += '<div class="row" style="background-color:#ddd;font-weight:bold;padding:2px 0"><div class="col-md-12"><div class="checkbox"><label><input type="checkbox" id="' + grpChkId
					+ '"><strong> ' + grp + ' </strong></label></div></div></div>';
			html += '<div class="row"><div class="col-md-12">';
			$.each(fields, function(idx, field) {
				if (field.reportable) {
					if (i % 3 === 0) {
						html += '<div class="row">';
						closed = false;
					}
					html += '<div class="col-md-4"><div class="form-group">';
					html += ' <label class="sr-only">' + field.name + '</label>';
					html += '<div class="checkbox"><label><input type="checkbox" id="' + field.id + '" group="' + grpChkId + '"> ' + field.name + ' </label></div>';
					html += '</div></div>';
					if (i % 3 === 2) {
						html += '</div>';
						closed = true;
					}
					i++;
				}
			})
			if (!closed) {
				html += '</div>';
			}
			html += '</div></div><br/>';
		}
		$.each(schema, function(idx, field) {
			if (!uniqGroups[field.group.toString()]) {
				uniqGroups[field.group.toString()] = [];
			}
			uniqGroups[field.group.toString()].push(field);
		});

		$.each(uniqGroups, function(key, value) {
			addTable(key, value);
		})

		$('#select_fields').html(html);

		$.each(uniqGroups, function(key, value) {
			var grpChkId = 'aio_group_' + replaceAll(key, ' ', '_');
			$('#' + grpChkId).change(function() {
				var allChk = this;
				$("input[type=checkbox][group=" + grpChkId + "]").each(function() {
					$(this).prop('checked', allChk.checked);
				});
				$("#issuekey").prop('checked', true);
			});
		})

		$("#issuekey").prop('checked', true);
		$("#issuekey").prop('disabled', true);

		var prevSelectedFieldIds = getTableauDataVal('selectedFieldIds');
		if (prevSelectedFieldIds) {
			$.each(prevSelectedFieldIds, function() {
				$("#" + replaceAll(this.toString(), '.', '\\.')).prop('checked', true);
			});
		}
		setTableauDataVal('schema', schema);
		GLOBAL.schemaReady = true;
	});
});

var clientUrl = function(url, _public) {
	return GLOBAL.ctx + (GLOBAL.cloud ? '' : '/plugins/servlet') + GLOBAL.addOnUrlPrefix + '/ajax-public/' + url + '?_=' + (new Date()).getTime() + '&' + GLOBAL.queryString;
};
var GLOBAL = function() {
};

var ajaxPost = function(url, _data, cb, retry, retryCount) {
	$.ajax({
		type : 'POST',
		url : clientUrl(url),
		cache : false,
		contentType : 'application/json; charset=UTF-8',
		dataType : 'json',
		data : JSON.stringify({
			data : _data
		}),
		success : function(response) {
			cb(response.results);
		},
		error : function(request, status, err) {
			// if (retry && retryCount < 100) {
			// retryCount++;
			// ajaxPost(url, _data, cb, retry, retryCount);
			// } else {
			(new AioAlert()).error(request);
			// }
		}
	});
};

var setTableauDataVal = function(key, val) {
	var connData = {};
	if (tableau.connectionData) {
		connData = JSON.parse(tableau.connectionData);
	}
	connData[key] = val;
	tableau.connectionData = JSON.stringify(connData);
};

var getTableauDataVal = function(key) {
	var connData = {};
	if (tableau.connectionData) {
		connData = JSON.parse(tableau.connectionData);
	}
	return connData[key];
};

var findFieldInSchema = function(fieldId, schema) {
	var field = null;
	$.each(schema, function() {
		if (this.id.toString() === fieldId.toString()) {
			field = this;
			return false;
		}
	});

	return field;
};
var replaceAll = function(str, search, replacement) {
	return str.split(search).join(replacement);
};

var isArray = function(field) {
	return field.jiraType === 'array' && field.id !== 'comment' && (!field.expression || (field.expression.indexOf('DeepValue') === -1)) && field.name !== 'Epic/Theme';
}