var timesOnce = {};
var prefix = 'filter.subscription.prefix.';
var idprefix = '#filter\\.subscription\\.prefix\\.';
var reportid = null;
var myName = '';
var myEmail = '';
var popupopen = false;
var serverTitle = '';
var newPublishLink = Math.random().toString(36).slice(2);
var monthMap = {
	"01" : "Jan",
	"02" : "Feb",
	"03" : "Mar",
	'04' : 'Apr',
	"05" : 'May',
	"06" : 'Jun',
	"07" : 'Jul',
	"08" : 'Aug',
	"09" : 'Sep',
	"1" : "Jan",
	"2" : "Feb",
	"3" : "Mar",
	'4' : 'Apr',
	"5" : 'May',
	"6" : 'Jun',
	"7" : 'Jul',
	"8" : 'Aug',
	"9" : 'Sep',
	"10" : 'Oct',
	"11" : 'Nov',
	"12" : 'Dec'
};

var dayMap = {
	"1" : "Sunday",
	"2" : "Monday",
	"3" : "Tuesday",
	'4' : 'Wednesday',
	"5" : 'Thursday',
	"6" : 'Friday',
	"7" : 'Saturday'
};
function populateDialog(frm, data) {
	$.each($('[name="filter.subscription.prefix.weekday"]'), function() {
		$(this).prop("checked", "");
	});
	$.each(JSON.parse(data.subscriptionForm), function(index, input) {
		var name = input.name;
		var value = input.value;

		var $ctrl = $('[name="' + name + '"]', frm);
		switch ($ctrl.attr("type")) {
		case "text":
		case "hidden":
			$ctrl.val(value);
			break;
		case "radio":
		case "checkbox":
			$ctrl.each(function() {
				if ($(this).attr('value') === value) {
					$(this).prop("checked", "checked");
				}
			});
			break;
		default:
			$ctrl.val(value);
		}
	});
	var dailyWeeklyMonthly = $('input[name="' + prefix + 'dailyWeeklyMonthly"]:checked').val();
	if (dailyWeeklyMonthly === 'daily') {
		toggleFrequencyControl('filter.subscription.prefix.', true);
	} else {
		timesOnce['filter.subscription.prefix.'] = true;
		if (dailyWeeklyMonthly === 'daysOfWeek') {
			switchToDaysOfWeek('filter.subscription.prefix.');
			toggleFrequencyControl('filter.subscription.prefix.', true);
		} else {
			if (dailyWeeklyMonthly === 'daysOfMonth') {
				switchToDaysOfMonth('filter.subscription.prefix.');
			}
		}
	}
	$('#subscribe-check-publish').prop("checked", data.publish);
}

function buildCronExpression() {
	var sec = '0';
	var min = '0';
	var hr = '0';
	var dom = '1/1';
	var mon = '*';
	var dow = '?';
	var yr = '*';
	var meridian = '';
	var cronExp = '';
	var calc = true;
	var readbleExpression = '';

	var dailyWeeklyMonthly = $('input[name="' + prefix + 'dailyWeeklyMonthly"]:checked').val();
	var intervalCron = getIntervalCron();

	if (dailyWeeklyMonthly === 'daily') {
		readbleExpression = 'Daily ' + intervalCron[0];
	} else {
		if (dailyWeeklyMonthly === 'daysOfWeek') {
			var days = '';
			var i = 0;
			$.each($('input[name="' + prefix + 'weekday"]'), function(index, opt) {
				if (opt.checked) {
					if (i > 0) {
						days += ',';
						readbleExpression += ', ';
					}
					i++;
					days += opt.value;
					readbleExpression += dayMap[opt.value];
				}
			});
			dom = '?';
			dow = days;
			if (readbleExpression === '') {
				readbleExpression = 'Daily ' + intervalCron[0];
			} else {
				readbleExpression = 'Each ' + readbleExpression + ' ' + intervalCron[0];
			}

		} else {
			if (dailyWeeklyMonthly === 'daysOfMonth') {
				document.getElementById('filter.subscription.prefix.interval').selectedIndex = 0;
				toggleFrequencyControl('filter.subscription.prefix.', true);
				intervalCron = getIntervalCron();
				var monthlyInterval = $('input[name="' + prefix + 'daysOfMonthOpt"]:checked').val();
				if (monthlyInterval === 'dayOfMonth') {
					var day = $('select[name="' + prefix + 'monthDay"]').val();
					dom = day;
					readbleExpression += 'The ' + $('select[name="' + prefix + 'monthDay"]  option:selected').text() + ' day of every month ' + intervalCron[0];
				} else {
					if (monthlyInterval === 'dayOfWeekOfMonth') {
						dom = '?';
						var dw = $('select[name="' + prefix + 'day"]').val();
						var dm = $('select[name="' + prefix + 'week"]').val();
						if (dm === 'L') {
							dow = dw + dm;
						} else {
							dow = dw + '#' + dm;
						}
						readbleExpression += 'The ' + $('select[name="' + prefix + 'week"]  option:selected').text() + ' ' + $('select[name="' + prefix + 'day"]  option:selected').text() + ' of every month ' + intervalCron[0];
					}
				}
			}
		}
	}
	if (calc) {
		cronExp = sec + ' ' + intervalCron[1] + ' ' + dom + ' ' + mon + ' ' + dow + ' ' + yr;
	}
	return [ readbleExpression, cronExp ];
}

function getIntervalCron() {
	var readableExpression = '';

	var interval = Number($(idprefix + 'interval').val());
	if (interval === 0) {
		min = Number($('select[name="' + prefix + 'runOnceMins"]').val());
		hr = Number($('select[name="' + prefix + 'runOnceHours"]').val());
		meridian = $('select[name="' + prefix + 'runOnceMeridian"]').val();
		readableExpression = 'at ' + hr + ':' + $('select[name="' + prefix + 'runOnceMins"] option:selected').text() + ' ' + meridian;
		if (meridian === 'pm') {
			hr = hr + 12;
		}
	} else {
		if (interval < 60) {
			min = '0/' + interval;
			var runfromhr = Number($('select[name="' + prefix + 'runFromHours"]').val());
			var runfrommeridian = $('select[name="' + prefix + 'runFromMeridian"]').val();
			var runtohr = Number($('select[name="' + prefix + 'runToHours"]').val());
			var runtomeridian = $('select[name="' + prefix + 'runToMeridian"]').val();
			readableExpression = 'every ' + interval + ' minutes';
			if (runfromhr === runtohr && runfrommeridian === runtomeridian) {
				// do not do anything
			} else {
				readableExpression += ' from ' + runfromhr + ':00 ' + runfrommeridian + ' to ' + runtohr + ':00 ' + runtomeridian;
			}

			if (runfrommeridian === 'pm') {
				runfromhr = runfromhr + 12;
			}
			if (runtomeridian === 'pm') {
				runtohr = runtohr + 12;
			}
			hr = runfromhr + '-' + runtohr;
		} else {
			min = '0/0';
			var runfromhr = Number($('select[name="' + prefix + 'runFromHours"]').val());
			var runfrommeridian = $('select[name="' + prefix + 'runFromMeridian"]').val();
			var runtohr = Number($('select[name="' + prefix + 'runToHours"]').val());
			var runtomeridian = $('select[name="' + prefix + 'runToMeridian"]').val();
			if (interval === 60) {
				readableExpression = 'every hour';
			} else {
				readableExpression = 'every ' + (interval / 60) + ' hours';
			}
			if (runfromhr === runtohr && runfrommeridian === runtomeridian) {
				// do not do anything
			} else {
				readableExpression += ' from ' + runfromhr + ':00 ' + runfrommeridian + ' to ' + runtohr + ':00 ' + runtomeridian;
			}
			if (runfrommeridian === 'pm') {
				runfromhr = runfromhr + 12;
			}
			if (runtomeridian === 'pm') {
				runtohr = runtohr + 12;
			}
			hr = runfromhr + '-' + runtohr + '/' + (interval / 60);
		}
	}
	var cronExpression = min + ' ' + hr;
	return [ readableExpression, cronExpression ];
}

/*
 * Renders an element visible to the user
 */
function hideCronEdit(elementid) {
	document.getElementById(elementid).style.display = 'none';
}

/*
 * Renders an element invisible to the user
 */
function showCronEdit(elementid) {
	document.getElementById(elementid).style.display = '';
}

function toggleFrequencyControl(paramPrefix, setOriginal) {
	var select = document.getElementById(paramPrefix + "interval");
	if (select.value === '0') {
		switchToOnce(paramPrefix, setOriginal);
	} else {
		switchToMany(paramPrefix, setOriginal);
	}
}

/*
 * Toggles the frequency controls to match 'once per day' mode
 */
function switchToOnce(paramPrefix, setOriginal) {
	// make sure the frequency select is set correctly
	// set state
	hideCronEdit(paramPrefix + "runMany");
	showCronEdit(paramPrefix + "runOnce");
	if (setOriginal) {
		timesOnce[paramPrefix] = true;
	}
}

/*
 * Toggles the frequency controls to match 'many per day' mode
 */
function switchToMany(paramPrefix, setOriginal) {
	// set state
	hideCronEdit(paramPrefix + "runOnce");
	showCronEdit(paramPrefix + "runMany");
	if (setOriginal) {
		timesOnce[paramPrefix] = false;
	}
}

function switchToDaysOfMonth(paramPrefix) {
	hideCronEdit(paramPrefix + 'daysOfWeek');
	showCronEdit(paramPrefix + 'daysOfMonth');
	showCronEdit(paramPrefix + 'freqDiv');
	hideCronEdit(paramPrefix + 'innerFreqDiv');
	switchToOnce(paramPrefix, false);
}

function switchToDaysOfWeek(paramPrefix) {
	showCronEdit(paramPrefix + 'daysOfWeek');
	hideCronEdit(paramPrefix + 'daysOfMonth');
	showCronEdit(paramPrefix + 'freqDiv');
	showCronEdit(paramPrefix + 'innerFreqDiv');
	switchToOriginal(paramPrefix);
}

function switchToDaily(paramPrefix) {
	hideCronEdit(paramPrefix + 'daysOfWeek');
	hideCronEdit(paramPrefix + 'daysOfMonth');
	showCronEdit(paramPrefix + 'freqDiv');
	showCronEdit(paramPrefix + 'innerFreqDiv');
	switchToOriginal(paramPrefix);
}

function switchToOriginal(paramPrefix) {
	if (timesOnce[paramPrefix]) {
		switchToOnce(paramPrefix, false);
	} else {
		switchToMany(paramPrefix, false);
	}
}
