$(function() {
	var momentFormats = {};
	$('[data-toggle="aio-tooltip"]').tooltip({
		template : '<div class="aio-tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
	});
	try {
		$.tablesorter.addParser({
			id : 'parser_modified',
			is : function(s) {
				return false;
			},
			format : function(s) {
				var _p = 'MMM dd, yyyy hh:mm a z';
				if (momentFormats[_p]) {
					_p = momentFormats[_p];
				} else {
					_p = _p.split('d').join('D');
					_p = _p.split('y').join('Y');
					momentFormats['MMM dd, yyyy hh:mm a z'] = _p;
				}
				var _m = moment(s, _p);
				if (_m._isValid) {
					return _m.toDate().getTime();
				}
				return 0;
			},
			type : 'numeric'
		});

		$(".table").tablesorter({
			sortList : [ [ 1, 1 ], [ 0, 0 ] ],
			headers : {
				1 : {
					sorter : 'parser_modified'
				}
			}
		});
	} catch (err) {
	}

});
var shareReport = function(reportId) {
	GLOBAL.aioReportId = reportId;
	var jc = new JiraClient();
	var ac = new AioClient();
	var autocomplete = new AioUserAutocomplete();
	autocomplete.build('async-user-single-select');
	ac.get('shareUsers', function(results) {
		$.each(results, function() {
			if (this.type === 'user') {
				jc.get('user?key=' + this.userkey, function(user) {
					autocomplete.addUser('async-user-single-select', user);
				});
			} else {
				if (this.type === 'team') {
					autocomplete.addTeam('async-user-single-select', this.teamId);
				}
			}
		});
	}, 'aioReportId=' + reportId);

	$('#dialog-share').modal({
		backdrop : 'static',
		keyboard : false
	});
};

var subscribeReport = function(reportId) {
	GLOBAL.aioReportId = reportId;
	GLOBAL.subscriptionExists = false;

	var jc = new JiraClient();
	var ac = new AioClient();
	var autocomplete = new AioUserAutocomplete();
	ac.get('scheduledReport', function(results) {
		if (results.accessTokenStatus === 'APP_LINK_NEEDED') {
			$('#dialog-app-link').modal({
				backdrop : 'static',
				keyboard : false
			});
			$('.applicationName').html(results.applicationName);
			$('.publicKey').html(results.publicKey);
			$('.consumerKey').html(results.consumerKey);
			$('.appLinkURL').html(results.appLinkURL);
		} else {
			if (results.accessTokenStatus === 'AUTHORIZE_URL') {
				$('#dialog-oauth').modal({
					backdrop : 'static',
					keyboard : false
				});
				$('a.authorizeUrl').attr('href', results.authorizeUrl);
				$('a.authorizeUrl').html(results.authorizeUrl);
			} else {
				$('#subscribe-select-saved-report').val(reportId);
				$('#dialog-subscribe').modal({
					backdrop : 'static',
					keyboard : false
				});
				autocomplete.build('async-user-single-select-subscribe');
				results = results.schedule;
				if (results) {
					GLOBAL.subscriptionExists = true;
					populateDialog($('#form-schedule-report'), results);
					$.each(results.subscribeUsers, function() {
						if (this.type === 'user') {
							jc.get('user?key=' + this.userkey, function(user) {
								autocomplete.addUser('async-user-single-select-subscribe', user);
							});
						} else {
							if (this.type === 'team') {
								autocomplete.addTeam('async-user-single-select-subscribe', this.teamId);
							}
						}
					});
				}
			}
		}
	}, 'aioReportId=' + reportId);

};
var copyReport = function(reportId) {
	var rs = new ReportService();
	GLOBAL.aioReportId = reportId;
	rs.copy();
};

var runNow = function(reportId) {
	var rs = new ReportService();
	GLOBAL.aioReportId = reportId;
	rs.runNow();
};

var deleteReport = function(reportId, deleteByOwner) {
	GLOBAL.aioReportId = reportId;
	$('#dialog-delete-share-count').html('');
	if (deleteByOwner) {
		var ac = new AioClient();
		ac.get('shareUsers', function(results) {
			if (results.length > 0) {
				$('#dialog-delete-share-count').html('<br/>This report is shared with ' + results.length + ' other user(s).');
			}
		}, 'aioReportId=' + reportId);

		$('#dialog-delete-confirm').html('Confirm that you want to delete this report.');
	} else {
		$('#dialog-delete-confirm').html('Confirm that you want to remove this report share.');
	}
	$('#dialog-delete').modal({
		backdrop : 'static',
		keyboard : false
	});
};

var unpublishReport = function(reportId) {
	GLOBAL.aioReportId = reportId;
	$('#dialog-unpublish').modal({
		backdrop : 'static',
		keyboard : false
	});
};