var ReportingEngine = function() {
	this.ac = new AioClient();
	this.jc = new JiraClient();
	this.issues = [];
	this.total = 0;
	this.fetched = 0;
	this.queue = [];
	this.epicQueue = [];
	this.epicQueuePos = 0;
	this.startTime = (new Date()).getTime();
	this.fetchEpic = false;
	this.fetchWorklog = false;
	this.epicLinkFieldId = '';
	this.epicNameFieldId = '';
	this.epicRollUp = false;
	this.epics = [];
	this.epicNames = [];
	this.epicNamesInProcess = [];
	this.epicLinks = [];
	this.epicLinksInProcess = [];
	this.parentRollUp = false;
	this.parents = [];
	this.parentsInProcess = [];
	this.parentQueue = [];
	this.parentQueuePos = 0;
	this.versions = [];
	this.versionsInProcess = [];
	this.cancel = false;
};

ReportingEngine.prototype.queryFields = function(dto, cb) {

	var obj = this;
	var setFlags = function(results) {
		obj.fetchEpic = results.fetchEpic;
		obj.epicLinkOnly = results.epicLinkOnly;
		obj.epicLinkFieldId = results.epicLinkFieldId;
		obj.epicNameFieldId = results.epicNameFieldId;
		obj.fetchWorklog = results.fetchWorklog;
		obj.fetchHistory = results.fetchHistory;
		obj.fetchProject = results.fetchProject;
		obj.epicRollUp = results.epicRollUp;
		obj.parentRollUp = results.parentRollUp;
	}
	if (GLOBAL.timeEntry) {
		var results = {
			"fetchWorklog" : true,
			"queryFields" : [ "issuekey", "summary", "project", "worklog", "issuetype", "parent" ],
			"fetchEpic" : false,
			"fetchHistory" : false,
			"fetchProject" : false
		};
		setFlags(results);
		cb(results.queryFields);
	} else {
		obj.ac.post('queryFields', dto, function(results) {
			setFlags(results);
			if (obj.fetchWorklog && obj.fetchHistory) {
				(new AioAlert()).error({
					responseText : 'History and Time Tracking fields cannot be used in the same report'
				});
			} else {
				if (obj.fetchEpic) {
					if (GLOBAL.epicIssueTypeId) {
						cb(results.queryFields);
					} else {
						obj.jc.get('search?jql=issuetype%3DEpic&maxResults=1&fields=issuetype', function(r) {
							try {
								GLOBAL.epicIssueTypeId = r.issues[0].fields.issuetype.id;
							} catch (err) {
							}
							cb(results.queryFields);
						}, true);
					}
				} else {
					cb(results.queryFields);
				}
			}
		});
	}
};

ReportingEngine.prototype.fetchIssues = function(dto, cb) {
	var obj = this;
	var hasHistory = ($.inArray('changelog', dto.queryFields) > -1);
	if (hasHistory) {
		GLOBAL.pagesize = 10;
	} else {
		GLOBAL.pagesize = 100;
	}
	var searchJson = {
		jql : dto.jql,
		fields : dto.queryFields,
		expand : [ hasHistory ? 'changelog' : '' ],
		maxResults : GLOBAL.pagesize
	};

	var _cb = function(results) {
		if (GLOBAL.cancelRun) {
			// do nothing
		} else {
			if (obj.queue.length > 0) {
				(obj.queue.shift())();
			}
			$.each(results.issues, function() {
				obj.processIssue(this, dto, function(issue) {
					GLOBAL.fetchedIssues++;
					AioProgressBar.update();
					obj.issues.push(obj.clean(issue));
					if (obj.issues.length === obj.total) {
						obj.doRollUp(dto, cb);
					}
				});
			});
		}
	};

	this.jc.post('search', searchJson, function(results, err) {
		displayJql(searchJson.jql, results, err);
		if (!err) {
			if (results.total > 0) {
				obj.total = results.total;
				GLOBAL.totalIssues = results.total;
				var pages = Math.ceil(obj.total / GLOBAL.pagesize);
				for (var i = 1; i < pages; i++) {
					searchJson.startAt = i * GLOBAL.pagesize;
					searchJson.maxResults = GLOBAL.pagesize;
					var jsonCopy = JSON.parse(JSON.stringify(searchJson));
					obj.queue.push(wrapFunction(obj.jc.post, obj, [ 'search', jsonCopy, _cb ]));
				}
				_cb(results);
				for (var j = 0; j < GLOBAL.parallel - 1; j++) {
					if (obj.queue.length > 0) {
						(obj.queue.shift())();
					}
				}
			} else {
				cb();
			}
		}
	}, true);
};
ReportingEngine.prototype.validateJql = function(dto) {
	var searchJson = {
		jql : dto.jql,
		fields : [ 'issuekey' ],
		expand : [],
		maxResults : 0
	};
	this.jc.post('search', searchJson, function(results, err) {
		displayJql(dto.jql, results, err);
	}, true);
};
ReportingEngine.prototype.processIssue = function(issue, dto, doNext) {
	var obj = this;
	if (dto.type === 'timesheet' && dto.issueTypes && dto.issueTypes.length > 0 && dto.includeSubTasks && issue.fields.issuetype.subtask) {
		var parentIssueType = issue.fields.parent.fields.issuetype.name;
		if ($.inArray(parentIssueType, dto.issueTypes) === -1) {
			doNext({});
			return;
		}
	}

	obj.processEpic(issue, function(issue) {
		obj.processWorklog(issue, function(issue) {
			obj.processVersion(issue, function(issue) {
				obj.processHistory(issue, function(issue) {
					obj.processProject(issue, function(issue) {
						doNext(issue);
					});
				});
			});
		});
	});
};

ReportingEngine.prototype.processEpic = function(issue, doNext) {
	var obj = this;
	if (this.fetchEpic) {
		var processEpicLink = function(_issue, epicLink) {
			if (obj.epicLinkOnly) {
				doNext(_issue);
				return;
			}
			if (epicLink && epicLink !== '-') {
				var epicName = obj.epicNames[epicLink];
				if (epicName) {
					_issue.fields[obj.epicNameFieldId] = epicName;
					doNext(_issue);
				} else {
					if (obj.epicNamesInProcess[epicLink]) {
						obj.epicNamesInProcess[epicLink].push(_issue);
					} else {
						obj.epicNamesInProcess[epicLink] = [];
						obj.epicNamesInProcess[epicLink].push(_issue);
						var cb = function(epic) {
							if (obj.epicQueue.length > 0) {
								(obj.epicQueue.shift())();
							} else {
								obj.epicQueuePos--;
							}
							var epicName = epicLink;
							try {
								epicName = epic.fields[obj.epicNameFieldId];
							} catch (err) {
								epicName += ' (No Access)';
							}
							if (!epicName) {
								epicName = '-';
							}
							obj.epicNames[epicLink] = epicName;
							$.each(obj.epicNamesInProcess[epicLink], function() {
								this.fields[obj.epicNameFieldId] = epicName;
								doNext(this);
							});
						};

						obj.epicQueue.push(wrapFunction(obj.jc.get, obj, [ 'issue/' + epicLink + '?fields=' + obj.epicNameFieldId, cb, true ]));
						if ((obj.epicQueuePos < GLOBAL.parallel) && (obj.epicQueue.length > 0)) {
							obj.epicQueuePos++;
							(obj.epicQueue.shift())();
						}
					}
				}
			} else {
				doNext(_issue);
			}
		};

		var epicLink = null;
		if (issue.fields.issuetype.subtask && issue.fields.parent) {
			if (issue.fields.parent.fields.issuetype.id === GLOBAL.epicIssueTypeId) {
				epicLink = issue.fields.parent.key;
				issue.fields[obj.epicLinkFieldId] = epicLink;
			} else {
				var parentKey = issue.fields.parent.key;
				epicLink = obj.epicLinks[parentKey];
				if (epicLink) {
					issue.fields[obj.epicLinkFieldId] = epicLink;
				} else {
					if (obj.epicLinksInProcess[parentKey]) {
						obj.epicLinksInProcess[parentKey].push(issue);
						return;
					} else {
						obj.epicLinksInProcess[parentKey] = [];
						obj.epicLinksInProcess[parentKey].push(issue);
						var cb = function(parentIssue) {
							var epicLink = null;
							try {
								epicLink = parentIssue.fields[obj.epicLinkFieldId];
							} catch (err) {
							}
							if (!epicLink) {
								epicLink = '-';
							}
							obj.epicLinks[parentIssue.key] = epicLink;
							$.each(obj.epicLinksInProcess[parentIssue.key], function() {
								this.fields[obj.epicLinkFieldId] = epicLink;
								processEpicLink(this, epicLink);
							});
						};
						obj.jc.get('issue/' + issue.fields.parent.key + '?fields=' + obj.epicLinkFieldId, cb, true);
						return;
					}
				}
			}
		} else {
			if (issue.fields.issuetype.id === GLOBAL.epicIssueTypeId) {
				epicLink = issue.key;
				issue.fields[obj.epicLinkFieldId] = epicLink;
				obj.epics[epicLink] = issue;
			} else {
				epicLink = issue.fields[obj.epicLinkFieldId];
			}
		}
		processEpicLink(issue, epicLink);
	} else {
		doNext(issue);
	}
};

ReportingEngine.prototype.processWorklog = function(issue, doNext) {
	var obj = this;
	if (this.fetchWorklog) {
		var cb = function(worklogIssue) {
			if (issue['fields']) {
				if (issue['fields']['worklog']) {
					issue['fields']['worklog']['worklogs'] = worklogIssue['worklogs'];
				} else {
					issue['fields']['worklog'] = {
						'worklogs' : worklogIssue['worklogs']
					};
				}
			} else {
				issue['fields'] = {
					'worklog' : {
						'worklogs' : worklogIssue['worklogs']
					}
				};
			}
			doNext(issue);
		};
		var workLogParentNode = null;
		if (issue['fields']) {
			workLogParentNode = issue['fields']['worklog'];
		}
		if (workLogParentNode) {
			var max = workLogParentNode['maxResults'];
			var total = workLogParentNode['total'];
			if (total > max) {
				obj.jc.get('issue/' + issue['key'] + '/worklog', cb);
			} else {
				doNext(issue);
			}
		} else {
			obj.jc.get('issue/' + issue['key'] + '/worklog', cb);
		}
	} else {
		doNext(issue);
	}
};

ReportingEngine.prototype.processVersion = function(issue, doNext) {

	var obj = this;
	if (issue.fields.fixVersions && issue.fields.fixVersions.length > 0) {
		var checkIssue = function(_issue) {
			var total = _issue.fields.fixVersions.length;
			var counter = 0;
			$.each(_issue.fields.fixVersions, function() {
				if (this.startDate) {
					counter++;
				}
			});
			if (counter === total) {
				doNext(_issue);
			}
		};

		$.each(issue.fields.fixVersions, function() {
			var fixVersion = this;
			var versionId = fixVersion.id;
			var versionStartDate = obj.versions[versionId];
			if (versionStartDate) {
				fixVersion.startDate = versionStartDate;
				checkIssue(issue);
			} else {
				if (obj.versionsInProcess[versionId]) {
					obj.versionsInProcess[versionId].push({
						_issue : issue,
						_fixVersion : fixVersion
					});
				} else {
					obj.versionsInProcess[versionId] = [];
					obj.versionsInProcess[versionId].push({
						_issue : issue,
						_fixVersion : fixVersion
					});
					var cb = function(version) {
						var versionStartDate = null;
						versionStartDate = version.startDate;
						if (!versionStartDate) {
							versionStartDate = '-';
						}
						obj.versions[versionId] = versionStartDate;
						$.each(obj.versionsInProcess[versionId], function() {
							this._fixVersion.startDate = versionStartDate;
							checkIssue(this._issue);
						});
					};
					obj.jc.get('version/' + versionId, cb, true);
				}
			}
		});
	} else {
		doNext(issue);
	}
};

ReportingEngine.prototype.processHistory = function(issue, doNext) {
	if (issue.changelog) {
		var tracker = {};
		var rows = [];
		var hs = issue.changelog.histories;
		var startTracker;
		var overallOrder = 1;
		var addRow = function(issue, start, value, item, h, from) {
			var row = {
				id : h.id,
				issuekey : issue.key,
				start : start,
				value : value,
				order_field : startTracker['order'],
				field : item.field,
				order : overallOrder,
				order_combo : startTracker['order'] + '-' + value,
				from : from,
				author : (h.author ? h.author.displayName : '')
			};
			rows.push(row);
			if (startTracker[item.field]) {
				startTracker[item.field]['end'] = h.created;
			}
			startTracker[item.field] = row;
			startTracker['order'] = startTracker['order'] + 1;
			overallOrder++;
		};
		$.each(hs, function(idx, h) {
			$.each(h.items, function(idx, item) {
				var first = false;
				// if (item.field === 'status' || item.field === 'assignee') {
				if (tracker[item.field]) {
					startTracker = tracker[item.field];
				} else {
					startTracker = {};
					tracker[item.field] = startTracker;
					startTracker['order'] = 1;
					first = true;
				}
				if (item.toString === null) {
					item.toString = '';
				}
				if (item.fromString === null) {
					item.fromString = '';
				}
				if (first) {
					if (item.fromString && item.fromString !== '') {
						addRow(issue, issue.fields.created, item.fromString, item, h, '');
					}
				}
				addRow(issue, h.created, item.toString, item, h, item.fromString);
				// }
			});
		});
		issue.fields.changelog = rows;
		issue.changelog = [];
	}
	doNext(issue);
};
ReportingEngine.prototype.processProject = function(issue, doNext) {
	var obj = this;
	if (this.fetchProject) {
		issue['fields']['project']['projectType'] = GLOBAL.projectTypeMap[issue['fields']['project'].key];
		issue['fields']['project']['projectDesc'] = GLOBAL.projectDescMap[issue['fields']['project'].key];
		issue['fields']['project']['projectLead'] = GLOBAL.projectLeadMap[issue['fields']['project'].key];
	}
	doNext(issue);
};

ReportingEngine.prototype.doRollUp = function(dto, doNext) {
	var done = true;
	var obj = this;
	if (obj.epicRollUp) {
		$.each(obj.issues, function() {
			var el = this.fields[obj.epicLinkFieldId];
			if (el && obj.epics[el] && this.fields.issuetype.id !== GLOBAL.epicIssueTypeId) {
				var ep = obj.epics[el];
				var is = this;
				$.each(dto.row, function() {
					if (!this.measure) {
						is.fields[this.id] = ep.fields[this.id];
					}
				});
			}
		});
	}
	if (obj.parentRollUp) {
		var totalSubTasks = 0;
		$.each(obj.issues, function() {
			if (this.fields.issuetype.subtask === false) {
				obj.parents[this.key] = this;
				this.fields.parent = JSON.parse(JSON.stringify(this));
			} else {
				totalSubTasks++;
			}
		});
		var cb = function(is, parent) {
			$.each(dto.row, function() {
				if (!this.measure && this.id !== 'parent') {
					is.fields[this.id] = parent.fields[this.id];
				}
			});
			totalSubTasks--;
			if (done === false && totalSubTasks === 0) {
				doNext();
			}
		}
		$.each(obj.issues, function() {
			if (this.fields.issuetype.subtask === true) {
				var is = this;
				var parentKey = this.fields.parent.key;
				var parent = obj.parents[parentKey]
				if (parent) {
					cb(is, parent)
				} else {
					done = false;
					if (obj.parentsInProcess[parentKey]) {
						obj.parentsInProcess[parentKey].push(is);
					} else {
						obj.parentsInProcess[parentKey] = [];
						obj.parentsInProcess[parentKey].push(is);
						obj.parentQueue.push(wrapFunction(obj.jc.get, obj, [ 'issue/' + parentKey + '?fields=' + dto.queryFields.join(), function(pi) {
							if (obj.parentQueue.length > 0) {
								(obj.parentQueue.shift())();
							} else {
								obj.parentQueuePos--;
							}
							obj.parents[parentKey] = pi;
							$.each(obj.parentsInProcess[parentKey], function() {
								cb(this, pi);
							});
						}, true ]));
						if ((obj.parentQueuePos < GLOBAL.parallel) && (obj.parentQueue.length > 0)) {
							obj.parentQueuePos++;
							(obj.parentQueue.shift())();
						}
					}
				}
			}
		});
	}
	if (done) {
		doNext();
	}
};

ReportingEngine.prototype.fetchProjects = function(doNext) {
	var obj = this;
	if (this.fetchProject && !GLOBAL.projectDetailsFetched) {
		GLOBAL.projectTypeMap = {};
		GLOBAL.projectDescMap = {};
		GLOBAL.projectLeadMap = {};
		if (GLOBAL.projects.length > 0) {
			var fp = function(i) {
				obj.jc.get(("project/" + GLOBAL.projects[i].id), function(p) {
					try {
						GLOBAL.projectTypeMap[p.key] = p.projectTypeKey;
					} catch (err) {
						GLOBAL.projectTypeMap[p.key] = '';
					}
					try {
						GLOBAL.projectDescMap[p.key] = p.description;
					} catch (err) {
						GLOBAL.projectDescMap[p.key] = '';
					}
					try {
						GLOBAL.projectLeadMap[p.key] = p.lead.name;
					} catch (err) {
						GLOBAL.projectLeadMap[p.key] = '';
					}
				});
				i++;
				if (i < GLOBAL.projects.length) {
					fp(i);
				} else {
					GLOBAL.projectDetailsFetched = true;
					doNext();
				}
			}
			fp(0);
		} else {
			GLOBAL.projectDetailsFetched = true;
			doNext();
		}
	} else {
		doNext();
	}
};

ReportingEngine.prototype.clean = function(input, p, gp) {
	var obj = this;
	if (typeof input === 'object') {
		input = obj.cleanItem(input, p, gp);
		$.each(input, function(key, value) {
			if (input instanceof Array) {
				key = p;
				p = gp;
			}
			input[key] = obj.clean(value, key, p);
		});
	}
	return input;
};

ReportingEngine.prototype.cleanItem = function(item, p, gp) {
	if ((item === null) || (typeof item === 'string') || (typeof item === 'number')) {
		return item;
	}
	var obj = this;
	$.each(item, function(key, value) {
		if (key) {
			if ($.inArray(key, GLOBAL.REMOVABLE_ATTRS) > -1) {
				delete item[key];
			}
		}
		if (p) {
			var pKey = p + '.' + key;
			if ($.inArray(pKey, GLOBAL.REMOVABLE_ATTRS) > -1) {
				delete item[key];
			}
		}
		if (gp) {
			var gpKey = gp + '.' + key;
			if ($.inArray(gpKey, GLOBAL.REMOVABLE_ATTRS) > -1) {
				delete item[key];
			}
		}
	});
	return item;
};
