var popupWindow;
var ReportService = function() {
	this.re = new ReportingEngine();
	this.ac = new AioClient();
};

ReportService.prototype.run = function() {
	var dto = new AioDto();
	dto = dto.build();
	var renderInPopUp = true;
	if (GLOBAL.quickTimesheet || GLOBAL.timeInStatus || GLOBAL.timeEntry) {
		renderInPopUp = false;
		if (GLOBAL.quickTimesheet) {
			$('#btn-export').css('visibility', 'hidden');
			$('#btn-publish').css('visibility', 'hidden');
		}

	}
	this.runDto(dto, renderInPopUp);
};
ReportService.prototype.runDto = function(dto, renderInPopUpFlag) {
	$('#aio-report-results').html('');
	$('#aio-report-results-canvas').html('');

	var message = this.validDto(dto);
	if (message === '') {

		// start: setting select dto properties outside of build() for dashboard
		dto.schema = GLOBAL.schema;
		dto.priorities = GLOBAL.priorities;
		dto.jiraBaseUrl = GLOBAL.jiraBaseUrl;
		// end

		GLOBAL.cancelRun = false;
		AioProgressBar.init();
		var obj = this;
		var processIssues = function(dto) {
			AioProgressBar.updateMessage('Processing...');
			obj.ac.post('processIssues', dto, function(results) {
				GLOBAL.lastRunDto = results.dto;
				GLOBAL.lastRunResults = results.viewData;
				AioProgressBar.stop();
				if (renderInPopUpFlag) {
					obj.renderInPopup();
				} else {
					obj.render();
				}
			});
		};
		if (dto.type === 'trend') {
			var trh = new TrendHelper();
			trh.run(dto, processIssues);
		} else {
			obj.re.queryFields(dto, function(_queryFields) {
				dto.queryFields = _queryFields;
				obj.re.fetchProjects(function() {
					obj.re.fetchIssues(dto, function() {
						dto.issues = obj.re.issues;
						processIssues(dto);
					});
				})
			});
		}
	} else {
		(new AioAlert()).warning(message);
	}
};
ReportService.prototype.renderInPopup = function() {
	var params = 'width=' + screen.width;
	params += ', height=' + screen.height;
	params += ', top=0, left=0';
	params += ', fullscreen=no';
	params += ',scrollbars=1';
	if (popupWindow && !popupWindow.closed) {
		popupWindow.close();
	}
	popupWindow = window.open('../public/report_display?link=' + new Date().getTime(), 'AIOReportViewer', params);
	setTimeout(function() {
		if (!popupWindow || popupWindow.outerHeight === 0) {
			(new AioAlert()).error({
				responseText : 'Popup blocker is enabled. Disable popup blocker or add your JIRA instance URL (<b>' + GLOBAL.jiraBaseUrl + '</b>) to your exception list.'
			});
		} else {
			popupWindow.focus();
		}
	}, 500);

};
ReportService.prototype.render = function() {
	(new AioAlert()).hide();
	var dto = GLOBAL.lastRunDto;
	var view = GLOBAL.lastRunResults;
	$('#aio-report-results').hide();
	$('#aio-report-results-canvas').hide();
	if (dto.type === 'list' || dto.type === 'matrix' || dto.type === 'timesheet') {
		var grid = new Grid(view);
		grid.render('#aio-report-results', dto.type, dto);
	}
	if (dto.type === 'bar' || dto.type === 'pie' || dto.type === 'line') {
		var chart = new AioChart(view);
		chart.render(dto, '#aio-report-results-canvas', dto.type);
	}
	if (dto.type === 'trend') {
		if (dto.trendOutputFormat === 'table') {
			var grid1 = new Grid(view);
			grid1.render('#aio-report-results', dto.type, dto);
		} else {
			var chart1 = new AioChart(view);
			chart1.render(dto, '#aio-report-results-canvas', dto.trendOutputFormat);
		}
	}
	if (GLOBAL.gadget) {
		GLOBAL.adjustGadgetHeight();
	}
	if (GLOBAL.quickTimesheet || GLOBAL.timeInStatus) {
		$('#btn-export').css('visibility', 'visible');
		$('#btn-publish').css('visibility', 'visible');
	}
	$('.aio-spinner').hide();
};
ReportService.prototype.save = function(cb) {
	var obj = this;
	var dto = new AioDto();
	dto = dto.build();
	obj.ac.post('save', dto, function(results) {
		GLOBAL.aioReportId = results.aioReportId;
		(new AioAlert()).success('Report saved successfully');
		$('#btn-save').show();
		$('#btn-save-copy').hide();
		if (cb) {
			cb();
		}
		var _dto = new AioDto();
		_dto = _dto.build();
		GLOBAL.lastSavedDto = JSON.stringify(_dto);
	});
};
ReportService.prototype.open = function() {
	var obj = this;
	var _load = function(dto) {
		if (GLOBAL.projectsLoaded && GLOBAL.teamsLoaded && ((GLOBAL.issueTypesLoaded && GLOBAL.timesheetInit) || (GLOBAL.timeInStatus && GLOBAL.statusesLoaded))) {
			obj.load(dto);
			$('#dialog-block-ui').modal('hide');
			var _run = function() {
				if ((GLOBAL.quickTimesheet && GLOBAL.reportLoaded) || GLOBAL.timeInStatus) {
					obj.run();
				} else {
					setTimeout(function() {
						_run();
					}, 500);
				}
			};
			_run();
		} else {
			setTimeout(function() {
				_load(dto);
			}, 500);
		}
	};
	if (GLOBAL.aioReportId) {
		obj.ac.post('open', {
			aioReportId : GLOBAL.aioReportId,
			schema : GLOBAL.schema,
			dashboard : false,
			legacyReportId : null
		}, function(results) {
			_load(results);
		});
	} else {
		$('#dialog-block-ui').modal('hide');
	}
};

ReportService.prototype.load = function(dto) {
	if (dto) {
		var obj = this;
		$('#aio-report-name').editable('setValue', dto.name);
		$('#tabs-report [aria-controls="' + dto.type + '"]').tab('show');
		$('#tabs-filter [aria-controls="' + dto.filterType + '"]').tab('show');
		if (GLOBAL.timeInStatus) {
			dto.type = 'time-in-status';
		}
		removeTabFields(dto.type);
		$.each(dto.row, function() {
			addField(rowSection(dto.type)[0], this);
		});
		$.each(dto.column, function() {
			addField(columnSection(dto.type)[0], this);
		});
		$.each(dto.data, function() {
			addField(dataSection(dto.type)[0], this);
		});
		var filter = new Filter();
		filter.setValue(dto.filterType, dto.filterValue);
		GLOBAL.reportLoaded = true;
		if (dto.type === 'timesheet') {
			GLOBAL.reportLoaded = false;
			var tsh = new TimesheetHelper();
			tsh.setDateRange(dto.dateRange);
			tsh.setStartDate(new Date(dto.startDate));
			tsh.setEndDate(new Date(dto.endDate));
			tsh.setDays(dto.days);
			tsh.initDates();
			tsh.setProjects(dto.projects);
			tsh.setUsers(dto.users);
			tsh.setIssueTypes(dto.issueTypes);
			tsh.setIncludeSubTasks(dto.includeSubTasks);
			tsh.setInterval(dto.timesheetInterval);
			tsh.setIncludeNonWorklog(dto.includeNonWorklog);
		}
		if (dto.type === 'time-in-status') {
			var tish = new TimeInStatusHelper();
			tish.setProjects(dto.projects);
			tish.setStatuses(dto.column[0]);
			tish.setMeasure(dto.data[0].id);
		}
		if (dto.type === 'trend') {
			var trh = new TrendHelper();
			trh.setDateRange(dto.dateRange);
			trh.setStartDate(new Date(dto.startDate));
			trh.setEndDate(new Date(dto.endDate));
			trh.initDates();
			trh.setField(dto.trendField);
			trh.initValuesSelect(function() {
				trh.setValues(dto.trendValues);
			});

			trh.setTrendInterval(dto.trendInterval);
			trh.setBreakByIssueType(dto.breakByIssueType);
			trh.setShowPercentages(dto.showPercentages);
			trh.setShowCumulative(dto.showCumulative);
			trh.setOutputFormat(dto.trendOutputFormat);
			trh.initOutputFormat();
		}
		if (GLOBAL.loggedInUserID !== dto.ownerId || dto.canned) {
			GLOBAL.aioReportId = null;
			$('#btn-save').hide();
			$('#btn-save-copy').show();
		}
		var _dto = new AioDto();
		_dto = _dto.build();
		GLOBAL.lastSavedDto = JSON.stringify(_dto);
	}
	var _updateJqlDisplay = function() {
		if (GLOBAL.reportLoaded) {
			updateJqlDisplay();
		} else {
			setTimeout(function() {
				_updateJqlDisplay();
			}, 500);
		}
	};
	_updateJqlDisplay();

};

ReportService.prototype.share = function() {
	var obj = this;
	if (GLOBAL.aioReportId) {
		var users = [];
		var valArr = $('#async-user-single-select')[0].selectize.getValue();
		if (valArr) {
			$.each(valArr, function() {
				var val = JSON.parse(this);
				if (val.type === 'user') {
					var user = GLOBAL.userMap[val.val];
					if (user.emailAddress === '') {
						(new AioAlert()).warning('No email address found in JIRA for ' + user.name);
					} else {
						users.push(user);
					}
				} else {
					users.push({
						'teamId' : val.val,
						'type' : 'team'
					});
				}
			});
		}

		var dto = new AioDto();
		dto.aioReportId = GLOBAL.aioReportId;
		dto.shareUsers = users;
		obj.ac.post('share', dto, function(results) {
			(new AioAlert()).success('Report shared successfully');
			$('#dialog-share').modal('hide');
			setTimeout(function() {
				window.location = window.location;
			}, 500);
		});
	}
};
ReportService.prototype.subscribe = function() {
	var obj = this;
	if (GLOBAL.aioReportId) {
		var users = [];
		var valArr = $('#async-user-single-select-subscribe')[0].selectize.getValue();
		if (valArr) {
			$.each(valArr, function() {
				var val = JSON.parse(this);
				if (val.type === 'user') {
					users.push(GLOBAL.userMap[val.val]);
				} else {
					users.push({
						'teamId' : val.val,
						'type' : 'team'
					});
				}
			});
		}
		if (users.length === 0 && !GLOBAL.subscriptionExists) {
			(new AioAlert()).warning('Please add users to the subscription');
		} else {
			var dto = new AioDto();
			dto.aioReportId = GLOBAL.aioReportId;
			dto.subscribeUsers = users;
			dto.subscriptionForm = JSON.stringify($('#form-schedule-report').serializeArray());
			var cron = buildCronExpression();
			dto.readableSchedule = cron[0];
			dto.cronExpression = cron[1];
			dto.publish = $('#subscribe-check-publish').is(":checked");
			dto.summary = $('#subscribe-daily-summary').is(":checked");
			dto.summaryTime = $('#subscribe-daily-summary-time').val()
			dto.summaryAmPm = $('#subscribe-daily-summary-ampm').val();
			obj.ac.post('subscribe', dto, function(results) {
				(new AioAlert()).success('Subscription updated successfully');
				$('#dialog-subscribe').modal('hide');
				setTimeout(function() {
					window.location = window.location;
				}, 500);
			});
		}
	}
};
ReportService.prototype.deleteReport = function() {
	var obj = this;
	if (GLOBAL.aioReportId) {
		obj.ac.post('delete', GLOBAL.aioReportId, function(results) {
			(new AioAlert()).success('Report deleted successfully');
			$('#dialog-delete').modal('hide');
			setTimeout(function() {
				window.location = window.location;
			}, 500);
		});
	}
};
ReportService.prototype.unpublishReport = function() {
	var obj = this;
	if (GLOBAL.aioReportId) {
		obj.ac.post('unpublish', GLOBAL.aioReportId, function(results) {
			(new AioAlert()).success('Report unpublished successfully');
			$('#dialog-unpublish').modal('hide');
			setTimeout(function() {
				window.location = window.location;
			}, 500);
		});
	}
};

ReportService.prototype.copy = function() {
	var obj = this;
	if (GLOBAL.aioReportId) {
		obj.ac.post('copy', GLOBAL.aioReportId, function(results) {
			(new AioAlert()).success('Report copied successfully');
			setTimeout(function() {
				window.location = window.location;
			}, 500);
		});
	}
};
ReportService.prototype.runNow = function() {
	var obj = this;
	if (GLOBAL.aioReportId) {
		obj.ac.post('runNow', GLOBAL.aioReportId, function(results) {
			(new AioAlert()).success('Report scheduled successfully');
			setTimeout(function() {
				window.location = window.location;
			}, 500);
		});
	}
};
ReportService.prototype.exportReport = function() {
	var obj = this;
	if (GLOBAL.lastRunResults) {
		obj.ac.get('checkSession', function(valid) {
			var $frm = $('#form-export');
			$frm.attr('action', clientUrl('export', true));
			if (!valid) {
				$frm.find('input[name="data"]').val(JSON.stringify(GLOBAL.lastRunResults));
				GLOBAL.lastRunDto.schema = GLOBAL.schema;
				$frm.find('input[name="dto"]').val(JSON.stringify(GLOBAL.lastRunDto));
			}
			$frm.submit();
		}, null, true);
	} else {
		(new AioAlert()).error({
			responseText : 'Please run the report once to enable export'
		});
	}
};

ReportService.prototype.publishReport = function(validate, cb) {
	var obj = this;
	var _publish = function(cb) {
		obj.ac.post('publish', {
			'aioReportId' : GLOBAL.aioReportId,
			'data' : GLOBAL.lastRunResults
		}, function(results) {
			(new AioAlert()).success('Report published successfully');
			var publishedLink = GLOBAL.baseUrl + GLOBAL.addOnUrlPrefix + '/public/published?link=' + results.publishedLink;
			var msg = 'The report was published successfully at <a href="' + publishedLink + '" target="_blank"><strong>' + publishedLink + '</strong></a><br/>The link can be found under <strong>"My Reports"</strong> section for future reference';
			if (cb) {
				cb(msg);
			} else {
				(new AioAlert()).success(msg);
			}
		});
	};
	obj.save(function() {
		if (GLOBAL.lastRunResults) {
			if (validate) {
				obj.ac.post('open', {
					aioReportId : GLOBAL.aioReportId,
					schema : GLOBAL.schema,
					dashboard : false,
					legacyReportId : null
				}, function(results) {
					if (results.publishedLink) {
						if (cb) {
							cb('CONFIRM', results.lastPublishedDateDisplay);
						} else {
							$('#dialog-republish').modal({
								backdrop : 'static',
								keyboard : false
							});
						}
					} else {
						_publish(cb);
					}
				});
			} else {
				_publish(cb);
			}
		} else {
			(new AioAlert()).error({
				responseText : 'Please run the report once to enable export'
			});
		}
	});
};

ReportService.prototype.loadIssueTypes = function() {
	var jc = new JiraClient();
	GLOBAL.epicIssueTypeId = null;
	jc.get('issuetype', function(results) {
		GLOBAL.subIssueTypes = [];
		GLOBAL.parentIssueTypes = [];
		$.each(results, function() {
			if (this.subtask) {
				GLOBAL.subIssueTypes.push(this.name);
			} else {
				GLOBAL.parentIssueTypes.push(this.name);
			}
			if (this.name === 'Epic' || this.name === 'Épica') {
				GLOBAL.epicIssueTypeId = this.id;
			}
		});
		GLOBAL.issueTypesLoaded = true;
	});
};

ReportService.prototype.loadProjects = function() {
	var jc = new JiraClient();
	jc.get('project', function(results) {
		GLOBAL.projects = results;
		GLOBAL.projectsLoaded = true;
	});
};

ReportService.prototype.validDto = function(dto) {
	if (dto.row.length === 0) {
		return 'Please add fields to all sections of the report.';
	}
	if (dto.type !== 'list' && dto.data.length === 0) {
		return 'Please add fields to all sections of the report.';
	}
	if ((dto.type === 'matrix' || dto.type === 'timesheet') && dto.column.length === 0) {
		return 'Please add fields to all sections of the report.';
	}
	if (dto.type === 'timesheet') {
		if (dto.dateRange === 'last_n_days') {
			if (dto.days === '' || isNaN(dto.days) || dto.days <= 0) {
				return 'Please provide a numeric value greater than 0 for date range field';
			}
		}
	}
	{
		var rowFields = getSectionFields('row');
		var rowDimensions = [];
		var _c = 0;
		$.each(rowFields, function() {
			if (this.groupBy) {
				_c++;
			}
			if (!this.measure && !this.hidden) {
				rowDimensions.push(this);
			}
		});
		if (_c > 0 && rowDimensions.length === _c) {
			return 'Please set at least one visible row dimension to be without grouping';
		}
	}
	{
		var rowFields = getSectionFields('row');
		var rowDimensions = [];
		var _c = 0;
		$.each(rowFields, function() {
			if (this.hidden) {
				_c++;
			}
			if (!this.measure) {
				rowDimensions.push(this);
			}
		});
		if (_c > 0 && rowDimensions.length === _c) {
			return 'Please set at least one dimension to be not hidden from the results';
		}
	}

	return '';
};
ReportService.prototype.validateJql = function() {
	var dto = new AioDto();
	dto = dto.build();
	this.re.validateJql(dto);

};

ReportService.prototype.detectChanges = function() {
	if (GLOBAL.lastSavedDto) {
		var dto = new AioDto();
		dto = dto.build();
		if (GLOBAL.lastSavedDto === JSON.stringify(dto)) {
			return false;
		}
		return true;
	}
	return false;
};
var publishFromChild = function(validate, cb) {
	var rs = new ReportService();
	rs.publishReport(validate, cb);
};

ReportService.prototype.login = function() {
	(new JiraClient()).get('myself?expand=groups', function(user) {
		GLOBAL.myself = user;
		(new AioClient()).post('login', user, function() {
		});
	}, true);
};
ReportService.prototype.checkPermissions = function() {
	var jc = new JiraClient();
	jc.get('mypermissions', function(permissions) {
		var p = permissions.permissions;
		$.each(p, function() {
			if (this.key === 'USER_PICKER') {
				GLOBAL.user_picker = this.havePermission;
			}
		});
	}, true);

	this.ac.get('getPermissions', function(response) {
		GLOBAL.accessOtherTime = false;
		if (response.aio_access_other_time) {
			var gtcaot = response.aio_access_other_time;
			(new JiraClient()).get('myself?expand=groups', function(user) {
				$.each(user.groups.items, function() {
					if ($.inArray(this.name.toString(), gtcaot) != -1) {
						GLOBAL.accessOtherTime = true;
						return false;
					}
				});
				GLOBAL.permissionsLoaded = true;
			}, true);
		} else {
			GLOBAL.accessOtherTime = true;
			GLOBAL.permissionsLoaded = true;
		}
	});
};
ReportService.prototype.loadTeams = function() {
	GLOBAL.teamsLoaded = false;
	this.ac.get('myTeams', function(response) {
		GLOBAL.teams = response;
		GLOBAL.teamsLoaded = true;
	});
};
