var AioProgressBar = function() {
};

AioProgressBar.init = function() {
	GLOBAL.fetchedIssues = 0;
	GLOBAL.totalIssues = 0;
	$('#aio-progress-bar').css('width', '0%');
	$('#aio-progress-bar').html('0%');
	$('#aio-progress-update').html('Initializing...');
	$('#dialog-progress').modal({
		backdrop : 'static',
		keyboard : false
	});
	AioProgressBar.startTime = new Date();
};
AioProgressBar.updateMessage = function(message) {
	$('#aio-progress-update').html(message);
};
AioProgressBar.update = function(isTrend) {
	var total = GLOBAL.totalIssues;
	var count = GLOBAL.fetchedIssues;
	var progress = Math.round(count * 100 / total);
	$('#aio-progress-bar').css('width', progress + '%');
	$('#aio-progress-bar').html(progress + '%');
	var now = new Date();

	var timeRemaining = Math.round(((now.getTime() - AioProgressBar.startTime) * (total - count)) / (count * 1000));
	if (timeRemaining < 60) {
		timeRemaining = timeRemaining + ' second(s)';
	} else {
		if (timeRemaining < 3600) {
			timeRemaining = Math.round(timeRemaining / 60) + ' minute(s)';
		} else {
			timeRemaining = Math.round(timeRemaining / 3600) + ' hour(s)';
		}

	}
	$('#aio-progress-update').html('');
	if (!isTrend) {
		$('#aio-progress-update').append(count + ' of ' + total + ' issues fetched.');
	}
	$('#aio-progress-update').append('<br/>' + 'Estimated time remaining: ' + timeRemaining + '.');
};
AioProgressBar.cancel = function(progress, total) {
	GLOBAL.cancelRun = true;
	$('#dialog-progress').modal('hide');
};
AioProgressBar.stop = function(progress, total) {
	$('#dialog-progress').modal('hide');
};