$(function() {
	var ac = new AioClient();

	$('#save_my_preferences').click(function() {
		var p = {};
		p['customEmailTemplate'] = $("input[name='emailTemplate']:checked").val() === 'custom_email_template';
		if (p['customEmailTemplate']) {
			var es = $("input[name='etSubject']").val();
			p['emailSubject'] = es;

			if (!es) {
				(new AioAlert()).error({
					responseText : 'Please provide a subject for custom email template'
				});
				return;
			}

			var eb = $("textarea[name='etBody']").val();
			p['emailBody'] = eb;
			if (!eb) {
				(new AioAlert()).error({
					responseText : 'Please provide a body for custom email template'
				});
				return;
			}
		}
		p['dailySummary'] = $("input[name='daily_summary']").is(':checked');
		if (p['dailySummary']) {
			p['summaryTime'] = $("select[name='daily_summary_time'] option:selected").val();
			p['summaryAmPm'] = $("select[name='daily_summary_ampm'] option:selected").val();
		}
		ac.post('saveMyPreferences', p, function(response) {
			(new AioAlert()).success('Preferences saved successfully.');
			setTimeout(function() {
				location.reload();
			}, 3000);
		});
	});

});