var JiraClient = function() {
};

JiraClient.prototype.get = function(url, cb, lenient, connect, del) {
	var contextUrl = connect ? '/rest/atlassian-connect/1/addons/'
			+ GLOBAL.addOnKey : '/rest/api/latest/';
	if (GLOBAL.cloud) {
		AP.require('request', function(request) {
			request({
				url : contextUrl + url,
				cache : false,
				type : del ? 'DELETE' : 'GET',
				success : function(response) {
					if (del) {
						cb();
					} else {
						cb(JSON.parse(response));
					}
				},
				error : function(request, status, err) {
					if (lenient) {
						cb(err);
					} else {
						(new AioAlert()).error(request);
					}
				}
			});
		});
	} else {
		$.ajax({
			url : GLOBAL.ctx + contextUrl + url,
			cache : false,
			type : del ? 'DELETE' : 'GET',
			success : function(response) {
				cb(response);
			},
			error : function(request, status, err) {
				if (lenient) {
					cb(err);
				} else {
					(new AioAlert()).error(request);
				}
			}
		});
	}
};

JiraClient.prototype.post = function(url, data, cb, lenient, connect, put) {
	var contextUrl = connect ? '/rest/atlassian-connect/1/addons/'
			+ GLOBAL.addOnKey : '/rest/api/latest/';

	if (GLOBAL.cloud) {
		AP.require('request', function(request) {
			request({
				url : contextUrl + url,
				cache : false,
				type : put ? 'PUT' : 'POST',
				contentType : 'application/json; charset=UTF-8',
				dataType : 'json',
				data : JSON.stringify(data),
				success : function(response) {
					cb(JSON.parse(response));
				},
				error : function(request, status, err) {
					if (lenient) {
						cb(request, true);
					} else {
						(new AioAlert()).error(request);
					}
				}
			});
		});
	} else {
		$.ajax({
			url : GLOBAL.ctx + contextUrl + url,
			cache : false,
			type : put ? 'PUT' : 'POST',
			contentType : 'application/json; charset=UTF-8',
			dataType : 'json',
			data : JSON.stringify(data),
			success : function(response) {
				cb(response);
			},
			error : function(request, status, err) {
				if (lenient) {
					cb(request, true);
				} else {
					(new AioAlert()).error(request);
				}
			}
		});
	}
};
