var aggregateFunctions = [ [ 'None', '' ], [ 'Sum', 'SUM' ], [ 'Average', 'AVG' ], [ 'Max', 'MAX' ], [ 'Min', 'MIN' ] ];
var check = '<i class="fa fa-check" aria-hidden="true"></i>';
var addField = function(section, field, replace) {
	field = clone(field);
	if (!replace) {
		field.counter = GLOBAL.fieldCounter++;
	}
	var reportType = getReportType();
	var sectionType = $(section).attr('type');
	var _fieldDisplay = fieldDisplay(field, false, reportType, sectionType);
	var _flagInd = '';
	if (field.sortDir && field.sortDir !== 'none') {
		_flagInd = '<div style="position: absolute;top: -8px;right: -3px;background: #555;padding: 0px 2px;border-radius: 2px;color: white;font-size: 10px;">' + field.sortCounter + '<i class="fa fa-arrow-circle-' + field.sortDir + '" aria-hidden="true" style="font-size: 10px;color: white;"></i></div>';
		GLOBAL.sortCounter = (GLOBAL.sortCounter < field.sortCounter) ? field.sortCounter : GLOBAL.sortCounter;
	}
	if(field.epicRollUp || field.parentRollUp){
		_flagInd += '<div style="position: absolute;top: -8px;right: 18px;background: #555;padding: 0px 2px;border-radius: 2px;color: white;font-size: 10px;"><i class="fa fa-dot-circle-o" aria-hidden="true" style="font-size: 10px;color: white;"></i></div>';
	}
	var li = $('<li class="dropdown aio-field" id="field-' + field.counter + '">' + _flagInd + '<span>' + _fieldDisplay + '<span></li>');
	li.data({
		'field' : field,
		'section' : section
	});
	li.append($('<a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button"><i class="fa fa-caret-down aio-caret"></i></a>'));
	li.append(ul = $('<ul class="dropdown-menu"></ul>'));
	if (field.measure && canBeAggregated(field)) {
		ul.append(subLi = $('<li class="menu-item dropdown dropdown-submenu"><a href="#" class="dropdown-toggle" data-toggle="dropdown"><span style="visibility:hidden">' + check + '</span> Aggregate</a></li>'));
		subLi.append(subUl = $('<ul class="dropdown-menu"></ul>'));
		$.each(aggregateFunctions, function() {
			if (this[1] === '' && reportType !== 'list') {
				return true;
			}
			var _check = check;
			if (field.aggregateFunction !== this[1]) {
				_check = '<span style="visibility:hidden">' + check + '</span>';
			}
			subUl.append(_agLi = $('<li></li>'));
			_agLi.append(_a = $('<a href="#">' + _check + ' ' + this[0] + '</a>'));
			$(_a).data({
				'field' : field,
				'func' : this,
				'section' : section
			});
			$(_a).click(function() {
				setAggregateFunction($(this).data());
			});
		});
	}
	if (field.date) {
		ul.append(subLi = $('<li class="menu-item dropdown dropdown-submenu"><a href="#" class="dropdown-toggle" data-toggle="dropdown"><span style="visibility:hidden">' + check + '</span> Format</a></li>'));
		subLi.append(subUl = $('<ul class="dropdown-menu"></ul>'));
		$.each(GLOBAL.dateFormats, function(key, value) {
			var _check = check;
			if (field.pattern !== key) {
				_check = '<span style="visibility:hidden">' + check + '</span>';
			}
			subUl.append(_agLi = $('<li></li>'));
			_agLi.append(_a = $('<a href="#">' + _check + ' ' + key + ' (' + value + ')' + '</a>'));
			$(_a).data({
				'field' : field,
				'pattern' : key,
				'section' : section
			});
			$(_a).click(function() {
				setDatePattern($(this).data());
			});
		});
	}

	if (canBeSorted(field, reportType, sectionType)) {
		ul.append(subLi = $('<li class="menu-item dropdown dropdown-submenu"><a href="#" class="dropdown-toggle" data-toggle="dropdown"><span style="visibility:hidden">' + check + '</span> Sort</a></li>'));
		subLi.append(subUl = $('<ul class="dropdown-menu"></ul>'));
		$.each({
			'none' : 'None',
			'up' : 'Ascending',
			'down' : 'Descending'
		}, function(key, value) {
			var _check = check;
			if ((field.sortDir && field.sortDir !== key) || (!field.sortDir && key !== 'none')) {
				_check = '<span style="visibility:hidden">' + check + '</span>';
			}
			subUl.append(_agLi = $('<li></li>'));
			_agLi.append(_a = $('<a href="#">' + _check + ' ' + value + '</a>'));
			$(_a).data({
				'field' : field,
				'sortDir' : key,
				'section' : section
			});
			$(_a).click(function() {
				sortByField($(this).data());
			});
		});
	}
	ul.append('<li><a href="#" onclick="filterField($(this).parent().parent().parent())"><span style="visibility:hidden">' + check + '</span> Filter</a></li>');
	if (canBeGrouped(field, reportType, sectionType)) {
		ul.append('<li><a href="#" onclick="groupByField($(this).parent().parent().parent())">' + (field.groupBy ? check : '<span style="visibility:hidden">' + check + '</span>') + ' Group By</a></li>');
	}
	if (canBeHidden(field, reportType, sectionType)) {
		ul.append('<li><a href="#" onclick="hideField($(this).parent().parent().parent())">' + (field.hidden ? check : '<span style="visibility:hidden">' + check + '</span>') + ' Hide from results</a></li>');
	}
	if (field.measure) {
		// ul.append('<li><a href="#"
		// onclick="bucketize($(this).parent().parent().parent())">' +
		// (field.buckets.length > 0 ? check : '<span
		// style="visibility:hidden">' + check + '</span>') + '
		// Buckets</a></li>');
	}
	ul.append('<li><a href="#" onclick="removeField($(this).parent().parent().parent())"><span style="visibility:hidden">' + check + '</span> Remove</a></li>');
	if (field.name.toLowerCase() === 'epic name') {
		ul.append('<li><a href="#" onclick="epicRollUp($(this).parent().parent().parent())">' + (field.epicRollUp ? check : '<span style="visibility:hidden">' + check + '</span>') + ' Roll Up</a></li>');
	}
	if (field.name.toLowerCase() === 'parent issue key') {
		ul.append('<li><a href="#" onclick="parentRollUp($(this).parent().parent().parent())">' + (field.parentRollUp ? check : '<span style="visibility:hidden">' + check + '</span>') + ' Roll Up</a></li>');
	}
	if (field.measure) {
		li.addClass('measure');
	} else {
		li.addClass('dimension');
	}
	if (replace) {
		$('#field-' + field.counter).replaceWith(li);
	} else {
		var max = $(section).attr('max');
		if (max > 0) {
			var currentLength = $(section).find('ul:first').children('li').length;
			if (currentLength >= max) {
				removeField($(section).find('ul:first li:first'));
			}
		}
		$(section).find('ul:first').append(li);
		var selectedTabId = $(section).closest('div [role="tabpanel"]').attr('id');
		if (GLOBAL.quickTimesheet || (selectedTabId && endsWith(selectedTabId, getReportType()))) {
			highlightTreeField(field);
		}
	}
};

var highlightTreeField = function(field) {
	var _fieldId = field.id.replace('.', '\\.');
	var treeField = $('#tree-btn-' + _fieldId);
	$(treeField).find('.btn').addClass('btn-primary');
};
var fieldDisplay = function(field, noFilter, reportType, sectionType) {
	var _fieldDisplay = '';
	if (field.label) {
		_fieldDisplay += '<strong>' + field.label + '</strong>';
	} else {
		_fieldDisplay += '<strong>' + field.name + '</strong>';
		if (field.aggregateFunction && canBeAggregated(field)) {
			_fieldDisplay = field.aggregateFunctionDisplay + ' [' + _fieldDisplay + ']';
		}
		if (field.buckets.length > 0) {
			_fieldDisplay = 'Bucket [' + _fieldDisplay + ']';
		}

		if (field.date && field.pattern) {
			_fieldDisplay += ' [' + field.pattern + ']';
		}
	}
	var color = 'rgb(170, 170, 170)';
	if (!noFilter) {
		if (field.filterValue && !$.isEmptyObject(JSON.parse(field.filterValue))) {
			color = 'rgb(201, 48, 44)';
		}
		var filter = '<a href="#" onclick="filterField($(this).parent().parent())"><i class="fa fa-filter" aria-hidden="true" style="color:' + color + '" title="Field filter"></i></a> ';
		_fieldDisplay = filter + _fieldDisplay;
	}

	if (canBeGrouped(field, reportType, sectionType)) {
		color = 'rgb(170, 170, 170)';
		if (field.groupBy) {
			color = 'rgb(201, 48, 44)';
		}
		var groupBy = '<a href="#" onclick="groupByField($(this).parent().parent())"><i class="fa fa-list-alt" aria-hidden="true" style="color:' + color + '" title="Group By"></i></a> ';
		_fieldDisplay = groupBy + _fieldDisplay;
	}
	color = 'rgb(170, 170, 170)';
	var rename = '<a href="#" onclick="renameField($(this).parent().parent())"><i class="fa fa-pencil" aria-hidden="true" style="color:' + color + '" title="Edit Label"></i></a> ';
	_fieldDisplay = rename + _fieldDisplay;
	return _fieldDisplay;
};
var setAggregateFunction = function(data) {
	var f = data.field;
	f.aggregateFunction = data.func[1];
	f.aggregateFunctionDisplay = data.func[0];
	if (f.aggregateFunction === '') {
		f.aggregate = false;
		f.aggregateFunctionDisplay = '';
	} else {
		f.aggregate = true;
	}
	addField(data.section, f, true);
};
var setDatePattern = function(data) {
	var f = data.field;
	f.pattern = data.pattern;
	addField(data.section, f, true);
};
var sortByField = function(data, isRemove) {
	var f = data.field;
	if (data.sortDir === 'none') {
		if (f.sortDir) {
			var rowFields = getSectionFields('row');
			$.each(rowFields, function() {
				if (this.sortDir && this.sortDir !== 'none') {
					if (this.sortCounter > f.sortCounter) {
						this.sortCounter--;
						addField(data.section, this, true);
					}
				}
			});
			GLOBAL.sortCounter--;
			f.sortDir = null;
			f.sortCounter = null;
		}
	} else {
		f.sortDir = data.sortDir;
		if (!f.sortCounter) {
			GLOBAL.sortCounter++;
			f.sortCounter = GLOBAL.sortCounter;
		}
	}
	if (!isRemove) {
		addField(data.section, f, true);
	}
};
var removeTabFields = function(tabType) {
	var sections = [];
	sections.push(rowSection(tabType));
	sections.push(columnSection(tabType));
	sections.push(dataSection(tabType));
	$.each(sections, function() {
		var li = $(this).find('ul li');
		$.each(li, function() {
			removeField(this);
		});
	});
};
var tabSwitch = function(oldTab, newTab) {
	var newTabParentId = $(newTab).parent().parent().attr('id');
	if (newTabParentId === 'tabs-report') {
		var oldTabType = $(oldTab).attr('aria-controls');
		// removeTabFields(oldTabType);
		var newTabType = $(newTab).attr('aria-controls');
		enableTab("measure");
		enableTab("dimension");
		if (newTabType === 'timesheet') {
			selectTab("dimension");
			// disableTab("measure");
			var tsh = new TimesheetHelper();
			tsh.fieldInit();
		}
		if (newTabType === 'trend') {
			disableTab("dimension");
			disableTab("measure");
			var trh = new TrendHelper();
			trh.init();
		}
	}
	updateJqlDisplay();
};
var updateJqlDisplay = function() {
	var doUpdate = function() {
		if (GLOBAL.schemaLoaded) {
			var dto = new AioDto();
			dto = dto.build();
			displayJql(dto.jql);
		} else {
			setTimeout(function() {
				doUpdate();
			}, 500);
		}
	};
	doUpdate();
};
var displayJql = function(jql, results, err) {
	var html = '<b>JQL:</b> ' + jql + '<br/>';
	if (err) {
		html += '<span style="font-size:12px;background-color:#f2dede;padding:3px">' + JSON.parse(results.responseText).errorMessages + '</span>';
		(new AioAlert()).error(results);
		AioProgressBar.stop();
	} else {
		if (results) {
			html += '<span style="font-size:12px;background-color:#dff0d8;padding:3px">' + 'JQL is valid. <b>' + results.total + '</b> issues will be fetched for processing</span>';
		}
	}
	$('.filter-footer').html(html);
};
var disableTab = function(tabName) {
	var tab = $('a[aria-controls="' + tabName + '"]');
	tab.removeAttr('data-toggle');
	tab.parent().addClass('disabled');
};
var enableTab = function(tabName) {
	var tab = $('a[aria-controls="' + tabName + '"]');
	tab.attr('data-toggle', 'tab');
	tab.parent().removeClass('disabled');
};
var selectTab = function(tabName) {
	var tab = $('a[aria-controls="' + tabName + '"]');
	tab.tab('show');
};
var removeField = function(f) {
	var li = $(f);
	if ($(li).data().field) {
		$(li).data().sortDir = 'none';
		sortByField($(li).data(), true);
		var count = fieldCount($(li).parent().parent(), $(li).data().field);
		if (count === 1) {
			var treeField = $('#tree-btn-' + $(li).data().field.id);
			$(treeField).find('.btn').removeClass('btn-primary');
		}
		$(li).remove();
		var rowFields = getSectionFields('row');
		var rowDimensions = [];
		$.each(rowFields, function() {
			if (!this.measure) {
				rowDimensions.push(this);
			}
		});
		if (rowDimensions.length === 1) {
			if (rowDimensions[0].groupBy) {
				rowDimensions[0].groupBy = false;
				addField(rowSection(getReportType()), rowDimensions[0], true);
			}
		}
	}
};

var filterField = function(f) {
	var data = $(f).data();
	if (data) {
		var filter = new Filter();
		filter.fieldFilter(data);
	}
};

var bucketize = function(f) {
	var data = $(f).data();
	if (data) {
		var row = '<tr><td><input type="text" name="label"></td><td><input type="text" size="6" name="start"></td><td><input type="text" size="6" name="end"></td><td style="vertical-align:middle;cursor:pointer"><i class="fa fa-trash" aria-hidden="true"></i></td></tr>';
		$('#dialog-buckets').modal({
			backdrop : 'static',
			keyboard : false
		});
		$('#div-bucket-ranges').data('data', data);
		var field = data.field;
		$('#div-bucket-ranges').html('');
		if (field.buckets.length === 0) {
			$('#div-bucket-ranges').append($(row));
		} else {
			$.each(field.buckets, function() {
				$('#div-bucket-ranges').append(r = $(row));
				r.find("input[name='label']").val(this.label);
				r.find("input[name='start']").val(this.start);
				r.find("input[name='end']").val(this.end);
			})
		}
		$('#div-bucket-ranges').append('<tr><td colspan="3"></td><td style="vertical-align:middle;cursor:pointer"><i class="fa fa-plus" aria-hidden="true" id="bucket-add-row"></i></td></tr>');
		$('#bucket-add-row').click(function() {
			$(row).insertBefore($(this).parent().parent());
		});
		$('#div-bucket-ranges').find('.fa-trash').click(function() {
			$(this).parent().parent().remove();
		});
	}
};
var renameField = function(f) {
	var data = $(f).data();
	if (data) {
		GLOBAL.renameFieldData = data;
		$('#fieldLabel').val(data.field.label ? data.field.label : data.field.name);
		$('#dialog-rename-field').modal({
			backdrop : 'static',
			keyboard : false
		});
	}
};
var groupByField = function(f) {
	var data = $(f).data();
	if (data && data.field) {
		if (data.field.hidden) {
			(new AioAlert()).warning('Grouping on a hidden field is not allowed');
			data.field.groupBy = false;
		} else {
			data.field.groupBy = !data.field.groupBy;
			addField(data.section, data.field, true);
		}
	}
};
var epicRollUp = function(f) {
	var data = $(f).data();
	if (data && data.field) {
		data.field.epicRollUp = !data.field.epicRollUp;
		addField(data.section, data.field, true);
	}
};
var parentRollUp = function(f) {
	var data = $(f).data();
	if (data && data.field) {
		data.field.parentRollUp = !data.field.parentRollUp;
		addField(data.section, data.field, true);
	}
};
var hideField = function(f) {
	var data = $(f).data();
	if (data && data.field) {
		data.field.hidden = !data.field.hidden;
		if (data.field.hidden) {
			data.field.groupBy = false;
		}
		addField(data.section, data.field, true);
	}
};
var fieldCount = function(section, field) {
	var count = 0;
	$.each($(section).find('ul:first li'), function() {
		if ($(this).data().field && ($(this).data().field.id === field.id)) {
			count++;
		}
	});
	return count;
};
var getReportType = function() {
	if ($("ul#tabs-report").length > 0) {
		return $("ul#tabs-report li.active a").attr('aria-controls');
	} else {
		if (GLOBAL.quickTimesheet) {
			return 'timesheet';
		}
		if (GLOBAL.timeInStatus) {
			return 'time-in-status';
		}
		if (GLOBAL.timeEntry) {
			return 'timesheet-entry';
		}
	}
};

var getSectionFields = function(sectionType) {
	var out = [];
	var reportType = getReportType();
	var li = $('#aio-' + reportType).find('div[type="' + sectionType + '"] ul li');
	$.each(li, function() {
		if ($(this).data().field) {
			out.push($(this).data().field);
		}
	});
	return out;
};
var rowSection = function(reportType) {
	return getSection(reportType, 'row');
};
var columnSection = function(reportType) {
	return getSection(reportType, 'column');
};
var dataSection = function(reportType) {
	return getSection(reportType, 'data');
};

var getSection = function(reportType, sectionType) {
	return $('#aio-' + reportType).find('div[type="' + sectionType + '"]');
};

var canBeGrouped = function(field, reportType, sectionType) {
	return (!field.measure && sectionType === 'row' && (reportType === 'list' || reportType === 'matrix' || reportType === 'timesheet'));
};
var canBeSorted = function(field, reportType, sectionType) {
	return (sectionType === 'row' && (reportType === 'list' || reportType === 'matrix' || reportType === 'timesheet'));
};

var canBeHidden = function(field, reportType, sectionType) {
	return (!field.measure && sectionType === 'row' && (reportType === 'list' || reportType === 'matrix' || reportType === 'timesheet'));
};

var canBeAggregated = function(field) {
	return field.id !== 'aio_count' && field.id !== 'aio_total' && field.id !== 'aio_count_percent' && field.id !== 'progress_percent' && field.id.indexOf('_sp_percent_complete') === -1;
}
var addLoggedInUser = function() {
	var tsh = new TimesheetHelper();
	tsh.addLoggedInUser();
};
$(function() {

	var sizeElements = function() {
		if (GLOBAL.quickTimesheet) {
			$('#tabs-fields').removeClass('bordered');
		} else {
			var height = (screen.availHeight - 170);
			$('#tabs-fields').css('overflow', 'auto');
			$('#tabs-fields').css('max-height', height + 'px');
			$('#tabs-fields').css('min-height', height + 'px');
		}
	};

	var initElements = function() {
		$('#btn-save-copy').hide();
		var tsh = new TimesheetHelper();
		tsh.init();
		var tis = new TimeInStatusHelper();
		tis.init();
		var trh = new TrendHelper();
		trh.init();
		$.fn.editable.defaults.mode = 'inline';
		$('#aio-report-name').editable({
			type : 'text',
			title : 'Enter report name',
			emptytext : 'Enter report name',
			success : function(response, newValue) {

			}
		});
		if (GLOBAL.hostedDashboard) {
		} else {
			$(".ac-content").prepend('<div id="myCustomTrigger" class="support">AIO Support</div>');
			// if (!GLOBAL.cloud) {
			// $('#myCustomTrigger').css('top', '41px');
			// }
		}
	};

	var attachEventHandlers = function() {

		$('a[data-toggle="tab"]').on('hidden.bs.tab', function(e) {
			tabSwitch(e.target, e.relatedTarget);
		});

		$('#btn-run').click(function() {
			var rs = new ReportService();
			rs.run();
		});
		$('#btn-save').click(function() {
			var rs = new ReportService();
			rs.save();
		});
		$('#btn-save-copy').click(function() {
			var rs = new ReportService();
			rs.save();
		});
		$('#btn-dialog-share-save').click(function() {
			var rs = new ReportService();
			rs.share();
		});
		$('#btn-dialog-subscribe-save').click(function() {
			var rs = new ReportService();
			rs.subscribe();
		});
		$('#btn-dialog-delete-delete').click(function() {
			var rs = new ReportService();
			rs.deleteReport();
		});
		$('#btn-dialog-unpublish-unpublish').click(function() {
			var rs = new ReportService();
			rs.unpublishReport();
		});
		$('#btn-validate-jql').click(function() {
			var rs = new ReportService();
			rs.validateJql();
		});
		$('#timesheet-date-range-select').change(function() {
			var tsh = new TimesheetHelper();
			tsh.initDates();
		});
		$('#timesheet-last-n-days [name="txtLastNDays"]').change(function() {
			var tsh = new TimesheetHelper();
			tsh.initDates();
		});
		$('#trend-date-range-select').change(function() {
			var trh = new TrendHelper();
			trh.initDates();
		});
		$('#trend-field-select').change(function() {
			var trh = new TrendHelper();
			trh.initValuesSelect();
		});
		$("#trend-check-break-by-issuetype").change(function() {
			var trh = new TrendHelper();
			trh.initOutputFormat();
		});
		$('#btn-dialog-progress-cancel').click(function() {
			AioProgressBar.cancel();
		});
		$('#input-search-field').keyup(function() {
			searchFields($(this).val());
		});
		$('#input-search-clear').click(function() {
			$('#input-search-field').val('');
			searchFields('');
		});
		$('#btn-dialog-team-save').click(function() {
			(new TeamBuilder()).save();
		});
		$('#btn-dialog-delete-team').click(function() {
			(new TeamBuilder()).deleteTeam();
		});
		$('#btn-dialog-rename-field').click(function() {
			var data = GLOBAL.renameFieldData;
			if ($('#fieldLabel').val().trim() === '') {
				$('#fieldLabel').val('');
			}
			data.field.label = $('#fieldLabel').val();
			addField(data.section, data.field, true)
			$('#dialog-rename-field').modal('hide');
		});
		if (GLOBAL.quickTimesheet || GLOBAL.timeInStatus) {
			$('#btn-export').click(function() {
				var rs = new ReportService();
				rs.exportReport();
			});
			$('#btn-dialog-republish').click(function() {
				var rs = new ReportService();
				rs.publishReport(false, function(msg, data) {
					$('#dialog-republish').modal('hide');
					(new AioAlert()).success(msg);
				});
			});

			$('#btn-publish').click(function() {
				var rs = new ReportService();
				rs.publishReport(true, function(msg, data) {
					if (msg === 'CONFIRM') {
						$('#dialogLastPublishedDate').html('<strong>' + data + '</strong>');
						$('#dialog-republish').modal({
							backdrop : 'static',
							keyboard : false
						});
					} else {
						(new AioAlert()).success(msg);
					}
				});
			});
		}
		$('#btn-dialog-field-filter-save').click(function() {
			var filter = new Filter();
			filter.saveFieldFilter();
		});
		$("#btn-dialog-buckets-save").click(function() {
			var buckets = [];
			$('#div-bucket-ranges tr').each(function() {
				if ($(this).find('input').length > 0) {
					var b = {};
					$(this).find('input').each(function() {
						b[$(this).attr("name")] = $(this).val();
					});
					buckets.push(b);
				}
			});
			var data = $('#div-bucket-ranges').data('data');
			data.field.buckets = buckets;
			data.field.aggregate = false;
			data.field.aggregateFunction = '';
			data.field.aggregateFunctionDisplay = '';
			$('#dialog-buckets').modal('hide');
			addField(data.section, data.field, true);
		});
		$(window).bind("beforeunload", function(event) {
			try {
				var rs = new ReportService();
				if (rs.detectChanges()) {
					return 'Please confirm that you want to leave - data you have entered may not be saved.';
				}
			} catch (err) {
			}
		});
	};
	var preLoadData = function() {
		var rs = new ReportService();
		rs.loadIssueTypes();
		rs.loadProjects();
		rs.login();
		rs.checkPermissions();
		rs.loadTeams();
	};
	sizeElements();
	initElements();
	attachEventHandlers();

	if (!GLOBAL.timeEntry) {
		preLoadData();
	}
});
