var Grid = function(view) {
	this.view = view;
};

Grid.prototype.render = function(element, reportType, dto) {
	var momentFormats = {};
	$(element).show();
	$(element).html('');
	var jv = this.view;
	var table = $("<table></table>").attr("class", "results table table-condensed table-bordered " + reportType);
	$(element).append(table);
	table.append(thead = $('<thead></thead>'));
	var totalHeaderRows = jv.headerRows.length;
	if (totalHeaderRows === 0) {
		table.append($('<tbody><tr><td>No results found</td></tr></tbody>'));
	}
	var hasGroupBy = false;
	var grpByFields = [];
	$.each(dto.row, function(index, field) {
		if (this.groupBy) {
			hasGroupBy = true;
			grpByFields.push(this);
		}
	});

	var i = 1;
	$.each(jv.headerRows, function() {
		thead.append(row = $('<tr class="aio-table-header"></tr>'));
		$.each(this.headerCells, function(idx) {
			row.append(th = $('<th></th>'));
			if (this.w > 1) {
				th.attr('colspan', this.w);
			}
			if (this.s) {
				th.attr('class', this.s);
			}
			if (i === totalHeaderRows) {
				if (!GLOBAL.timeEntry) {
					th.addClass('sortable-header');
				}
			}
			var h = this.v;
			if (i === jv.headerRows.length) {
				if (idx < (dto.row.length - grpByFields.length)) {
					th.append($('<div class="xlfiltericon"><i class="fa fa-filter" aria-hidden="true"></i></div>'));
				}
			}
			th.append($('<pre></pre>').html(h));
		});
		i++;
	});
	table.append(tbody = $('<tbody></tbody>'));
	$.each(jv.dataRows, function() {
		tbody.append(row = $('<tr></tr>'));
		var _dRow = this;
		$.each(this, function(i) {
			var v = this.v;
			try {
				v = escapeScript(v);
			} catch (err) {
			}
			if (GLOBAL.timeEntry && this.s && this.s.indexOf('ts-data') > -1) {
				if (isNaN(v)) {
					v = '';
				}
				row.append(td = $('<td style="padding:1px;width:1px"></td>').append($('<div class="input-container"></div>').append(input = $('<input class="time-entry-input" readonly></input>').val(v))));
				$(input).data({
					'key' : _dRow[0].v,
					'date' : i - (dto.row.length - (hasGroupBy ? 1 : 0)),
					'value' : v
				});
			} else {
				row.append(td = $('<td></td>').append($('<pre></pre>').html(v)));
			}

			if (this.w > 1) {
				td.attr('colspan', this.w);
			}
			if (this.s) {
				td.attr('class', this.s);
			}
		});
	});

	if (jv.footerRow) {
		table.append(tfoot = $('<tfoot></tfoot>'));
		tfoot.append(row = $('<tr></tr>'));
		$.each(jv.footerRow, function() {
			row.append(td = $('<td></td>').append($('<pre></pre>').html(this.v)));
			if (this.w > 1) {
				td.attr('colspan', this.w);
			}
			if (this.s) {
				td.attr('class', this.s);
			}
		});
	}
	if (GLOBAL.timeEntry) {
		(new TimeEntryHelper()).renderComplete();
	}

	var iExpand = '<i class="fa fa-plus-square-o" aria-hidden="true"></i>';
	var iCollapse = '<i class="fa fa-minus-square-o" aria-hidden="true"></i>';
	if ($('.aio-gh').length > 0) {
		$(element).prepend('<span id="expand-collapse-all" style="cursor:pointer;margin-bottom:20px">' + iCollapse + ' Collapse All Groups</span><div style="min-height:10px"><div>');
		$('#expand-collapse-all').click(function() {
			$(this).html(function(_, value) {
				return value.indexOf(iExpand) === 0 ? iCollapse + ' Collapse All Groups' : iExpand + ' Expand All Groups';
			});
			var cls = '.aio-gh.aio-gh-0';
			var clsUntil = 'tr:has(td' + cls + ')';
			if ($(this).html().indexOf(iExpand) === 0) {
				$(cls).each(function() {
					$(this).parent().nextUntil(clsUntil).hide();
				})
			} else {
				$(cls).each(function() {
					$.each($(this).parent().nextUntil(clsUntil), function() {
						if (!$(this).data('hide')) {
							$(this).show();
						}
					});
				})
			}
		});
	}

	$('.aio-gh').each(function() {
		$(this).css('cursor', 'pointer');
		$(this).prepend('<span style="float:left;margin-right:8px;">' + iCollapse + '</span>');
	});
	$('.aio-gh').click(function() {
		$(this).find('span').html(function(_, value) {
			return (value === iExpand) ? iCollapse : iExpand;
		});
		var childRows = Grid.findGroupChildren(this);
		if ($(this).find('span').html() === iExpand) {
			childRows.hide();
		} else {
			$.each(childRows, function() {
				if (!$(this).data('hide')) {
					$(this).show();
				}
			});
		}
	});

	try {
		var headers = {};
		$.each(dto.row, function(index, field) {
			if (field.date) {
				if (field.pattern.toLowerCase() !== 'w' && field.pattern.toLowerCase() !== 'yyyy') {
					$.tablesorter.addParser({
						id : 'parser_' + index,
						is : function(s) {
							return false;
						},
						format : function(s) {
							var _p = field.pattern;
							if (momentFormats[_p]) {
								_p = momentFormats[_p];
							} else {
								_p = _p.split('d').join('D');
								_p = _p.split('y').join('Y');
								momentFormats[field.pattern] = _p;
							}
							var _m = moment(s, _p);
							if (_m._isValid) {
								return _m.toDate().getTime();
							}
							return 0;
						},
						type : 'numeric'
					});
					headers[index] = {
						sorter : 'parser_' + index
					};
				}
			}
		});
		if (!hasGroupBy) {
			var myTextExtraction = function(node) {
				var t = node.childNodes[0].innerHTML;
				if (t === '-') {
					t = "";
				}
				return t;
			}
			$(".results").tablesorter({
				headers : headers,
				textExtraction : myTextExtraction
			});
		}
	} catch (err) {
	}
	try {
		if (GLOBAL.dashboardConfig) {
			$('#expand-collapse-all').trigger("click");
		}
	} catch (err) {
	}
	try {
		if (GLOBAL.dashboardConfig && GLOBAL.dashboardConfig.height && !GLOBAL.dashboardConfig.noPage) {
			$('.results').each(function() {
				var currentPage = 0;
				var numPerPage = GLOBAL.dashboardConfig.height;
				var $table = $(this);
				var numRows = $table.find('tbody tr').length;
				var numPages = Math.ceil(numRows / numPerPage);

				var changePage = function(event) {
					var np = event.data['np'];
					if (np) {
						if (np === 'n') {
							currentPage = currentPage + 1;
							if (currentPage > numPages - 1) {
								currentPage = numPages - 1;
							}
						} else {
							currentPage = currentPage - 1;
							if (currentPage < 0) {
								currentPage = 0;
							}
						}
					} else {
						currentPage = event.data['newPage'];
					}
					$table.trigger('repaginate');
					$('#nav-li-' + currentPage).addClass('active').siblings().removeClass('active');
				};

				$("table").bind("sortEnd", function() {
					$table.trigger('repaginate');
				});
				$table.bind('repaginate', function() {
					$table.find('tbody tr').hide().slice(currentPage * numPerPage, (currentPage + 1) * numPerPage).show();
				});

				$table.trigger('repaginate');

				var $pager = $('<nav aria-label="Page navigation"><ul class="pagination pagination-sm"></ul></nav>');
				$('<li><a href="javascript:void(0)" aria-label="Previous"><span aria-hidden="true">&laquo;</span></a></li>').bind('click', {
					np : 'p'
				}, changePage).appendTo($pager.find('ul'));
				for (var page = 0; page < numPages; page++) {
					$('<li id="nav-li-' + page + '"><a  href="javascript:void(0)">' + (page + 1) + '</a></li>').bind('click', {
						newPage : page
					}, changePage).appendTo($pager.find('ul'));
				}
				$('<li><a  href="javascript:void(0)" aria-label="Next"><span aria-hidden="true">&raquo;</span></a></li>').bind('click', {
					np : 'n'
				}, changePage).appendTo($pager.find('ul'));
				$pager.insertBefore($table).find('li:nth-child(2)').addClass('active');
			});
		}
	} catch (err) {
	}
	try {
		this.xlFilter(grpByFields);
	} catch (err) {
		console.log(err);
	}
};

Grid.prototype.xlFilter = function(grpByFields) {

	$('.xlfiltericon').each(function(idx, ele) {
		attachXlFilter(idx, ele, false, $(".results"));
	});
	$(grpByFields).each(function(idx, f) {
		attachGrpXlFilter(idx, f, $('#expand-collapse-all'), $(".results"));
	});

}

Grid.findGroupChildren = function(hdr) {
	var cls = $(hdr).attr('class');
	cls = replaceAll(cls, ' ', '.');
	var _c = Number(cls.substring(cls.lastIndexOf('-') + 1));
	var clsUntil = '';
	for (var x = _c; 0 <= x; x--) {
		clsUntil += 'td.aio-gh-' + x;
		if (0 < x) {
			clsUntil += ',';
		}
	}
	clsUntil = 'tr:has(' + clsUntil + ')';
	return $(hdr).parent().nextUntil(clsUntil);
}