$(function() {
	var jc = new JiraClient();
	jc.get('filter/favourite', function(results) {
		var select = $('#aio-filter-jira');
		var option = $('<option>').text('--Select--').data({
			'id' : '',
			'jql' : ''
		}).val('');
		select.append(option);
		$.each(results, function() {
			var option = $('<option>').text(this.name).data(this).val(this.id);
			select.append(option);
		});
		if (GLOBAL.jiraFilterId) {
			var filter = new Filter();
			filter.setValue(filter.type(), GLOBAL.jiraFilterId);
		}
		$('#aio-filter-jira').change(function() {
			updateJqlDisplay();
		});
	});
	$('#aio-filter-jql').change(function() {
		updateJqlDisplay();
	});
});

var Filter = function() {
};
Filter.prototype.buildCustomInterface = function(ele, filters) {
	var jc = new JiraClient();
	var fetch = function(user, query, fieldName, callback) {
		if (user) {
			if (query === '') {
				query = '%';
			}
			jc.get('user/search?username=' + query, function(results) {
				$.each(results, function() {
					this.value = this.name;
					this.displayName = this.displayName + ' (' + this.name + ')';
				});
				callback(results, query);
			});
		} else {
			fieldName = replaceAll(fieldName, '"', '');
			fieldName = replaceAll(fieldName, ' ', '+');
			var params = 'fieldName=' + fieldName + '&fieldValue=';
			var fieldValue = query;
			if (fieldValue && fieldValue !== '') {
				fieldValue = replaceAll(fieldValue, '"', '');
				fieldValue = replaceAll(fieldValue, ' ', '+');
				params += fieldValue;
			}
			jc.get('jql/autocompletedata/suggestions?' + params, function(results) {
				results = results.results;
				$.each(results, function() {
					this.displayName = replaceAll(this.displayName, '</b>', '');
					this.displayName = replaceAll(this.displayName, '<b>', '');
				});
				callback(results, query);
			});

		}
	};
	$.each(filters, function() {
		var f = this;
		if (f.type === 'date') {
			f.plugin = 'datepicker';
			f.plugin_config = {
				format : 'yyyy/mm/dd',
				todayBtn : 'linked',
				todayHighlight : true,
				autoclose : true
			};
		}

		if (f.auto) {
			var fieldName = f.field;
			var user = f.user;
			f.plugin = 'selectize';
			f.plugin_config = {
				valueField : 'value',
				labelField : 'displayName',
				searchField : [ 'displayName' ],
				options : [],
				create : false,
				highlight : false,
				hideSelected : true,
				preload : 'focus',
				placeholder : 'Start typing...',
				maxItems : null,
				load : function(query, callback) {
					fetch(user, query, fieldName, callback);
				},
				onItemAdd : function(value, $item) {
					if (user) {
						$item[0].innerHTML = $item[0].innerHTML.replace(' (' + value + ')', '');
					}
				}
			};

			f.valueSetter = function(rule, value) {
				var callback = function(results, val) {
					rule.$el.find('.rule-value-container input')[0].selectize.addOption(results);
					rule.$el.find('.rule-value-container input')[0].selectize.addItem(val);
				};
				if (rule.operator.multiple) {
					$.each(value.split(','), function() {
						fetch(user, this.toString(), fieldName, callback);
					});
				} else {
					fetch(user, value, fieldName, callback);
				}
			};
		}
	});
	var initRuleInput = function(rule) {
		if (rule.filter.plugin == 'selectize') {
			var oldMaxItems = rule.filter.plugin_config.maxItems;
			rule.filter.plugin_config.maxItems = rule.operator.multiple ? null : 1;
			var newMaxItems = rule.filter.plugin_config.maxItems;
			if (oldMaxItems !== newMaxItems) {
				if (rule.$el.find('.rule-value-container input')[0]) {
					rule.$el.find('.rule-value-container input')[0].selectize.destroy();
					rule.$el.find('.rule-value-container input')[0].value = null;
					rule.$el.find('.rule-value-container input').selectize(rule.filter.plugin_config);
				}
			}
			rule.$el.find('.rule-value-container').css('min-width', '300px').find('.selectize-control').removeClass('form-control');
		} else {
			if (rule.filter.plugin == 'datepicker') {
				if (rule.operator.type === 'last_n' || rule.operator.type === 'next_n') {
					$(rule.$el.find('.rule-value-container input')).datepicker("destroy");
				}
			}
			rule.$el.find('.rule-value-container input').css('padding-left', '5px');
			if (rule.filter.type === 'date') {
				rule.$el.find('.rule-value-container input').css('width', '100px');
			}
		}
	};

	$(ele).on('afterUpdateRuleOperator.queryBuilder', function(e, rule) {
		initRuleInput(rule);
	});
	$(ele).on('afterCreateRuleInput.queryBuilder', function(e, rule) {
		initRuleInput(rule);
	});

	var operators = [];

	$.each(GLOBAL.operatorMapFE, function(key, value) {

		if (key === 'last_n' || key === 'next_n') {
			operators.push({
				type : key,
				nb_inputs : 1,
				apply_to : 'datetime'
			});
		} else {
			operators.push({
				type : key
			});
		}
	});

	$(ele).queryBuilder({
		plugins : [ 'bt-tooltip-errors' ],
		filters : filters,
		operators : operators
	});
};

Filter.prototype.jql = function() {
	var ac = new AioClient();
	var filterType = this.type();
	var jql = '';
	if (filterType === 'jql') {
		jql = $('#aio-filter-jql').val();
	} else {
		if (filterType === 'jira') {
			if ($('#aio-filter-jira').length > 0) {
				jql = $('#aio-filter-jira :selected').data().jql;
			}
		} else {
			if (filterType === 'custom') {
				var rules = $('#aio-filter-custom').queryBuilder('getRules');
				jql = this.customJql(rules);
			}
		}
	}
	var allFields = getSectionFields('row').concat(getSectionFields('column')).concat(getSectionFields('data'));
	var fieldJql = '';
	var obj = this;
	$.each(allFields, function() {
		var field = this;
		if (field.filterValue && !$.isEmptyObject(JSON.parse(field.filterValue))) {
			$.each(GLOBAL.filters, function() {
				if (field.name === 'Epic Name') {
					return false;
				}
				if ((this.id === 'filter_' + field.id) || field.id === 'worklog_started' || field.id === 'worklog_author.name' || field.id === 'project_name') {
					var _fieldJql = obj.customJql(JSON.parse(field.filterValue));
					if (_fieldJql !== '') {
						if (fieldJql === '') {
							fieldJql = _fieldJql;
						} else {
							fieldJql = fieldJql + ' and ' + _fieldJql;
						}
					}
					return false;
				}
			});
		}
	});
	if (fieldJql !== '') {
		if (jql === '') {
			jql = fieldJql;
		} else {
			jql = jql + ' and ' + fieldJql;
		}
	}
	return jql;
};
Filter.prototype.type = function() {
	if ($("ul#tabs-filter").length > 0) {
		return $("ul#tabs-filter li.active a").attr('aria-controls');
	} else {
		return 'jira';
	}
};

Filter.prototype.getValue = function(filterType) {
	var value = '';
	if (filterType === 'jql') {
		value = $('#aio-filter-jql').val();
	} else {
		if (filterType === 'jira') {
			if ($('#aio-filter-jira').length > 0) {
				value = $('#aio-filter-jira :selected').data().id;
			}
		} else {
			if (filterType === 'custom') {
				value = JSON.stringify($('#aio-filter-custom').queryBuilder('getRules'));
			}
		}
	}
	if (value) {
		return value;
	}
	return '';
};

Filter.prototype.setValue = function(filterType, value) {
	if (filterType === 'jql') {
		jql = $('#aio-filter-jql').val(value);
	} else {
		if (filterType === 'jira') {
			var exists = (value && (0 !== $('#aio-filter-jira option[value=' + value + ']').length));
			if (exists) {
				$('#aio-filter-jira').val(value);
				GLOBAL.jiraFilterId = value;
			}
		} else {
			if (filterType === 'custom') {
				try {
					$('#aio-filter-custom').queryBuilder('setRules', JSON.parse(value));
				} catch (err) {
				}
			}
		}
	}
};

Filter.prototype.isInOperator = function(operator) {
	return operator.toLowerCase() === 'in' || operator.toLowerCase() === 'not_in';
};
Filter.prototype.isBetweenOperator = function(operator) {
	return operator.toLowerCase() === 'between';
};
Filter.prototype.isEmptyOperator = function(operator) {
	return operator.toLowerCase() === 'is_empty' || operator.toLowerCase() === 'is_not_empty';
};
Filter.prototype.isDaysOperator = function(operator) {
	return operator.toLowerCase() === 'last_n' || operator.toLowerCase() === 'next_n';
};
Filter.prototype.customJql = function(rules, condition) {
	var obj = this;
	var jql = '';

	if (!condition) {
		condition = rules['condition'];
		rules = rules['rules'];
	}
	if (!rules) {
		return '';
	}

	var i = 0;
	$.each(rules, function() {
		if (this['condition']) {
			jql = (jql ? ('(' + jql + ') ' + condition + ' ') : '') + '(' + obj.customJql(this['rules'], this['condition']) + ")";
		} else {
			var operator = this['operator'];
			var isInOp = obj.isInOperator(operator);
			var isBetweenOp = obj.isBetweenOperator(operator);
			var isEmptyOp = obj.isEmptyOperator(operator);
			var isDaysOp = obj.isDaysOperator(operator);
			var val = this['value'];
			if (!isBetweenOp && !isDaysOp) {
				if (isInOp) {
					var quotedVals = [];
					$.each(val.split(','), function() {
						if (this.toString().indexOf('"') === 0) {
							quotedVals.push(this.toString().trim());
						} else {
							quotedVals.push('"' + this.toString().trim() + '"');
						}
					});
					val = quotedVals.toString();
				} else {
					if (isEmptyOp) {
						val = 'empty';
					} else {

						if (val.indexOf('"') === 0) {
							val = val;
						} else {
							if (isNaN(val)) {
								val = '"' + val + '"';
							} else {
								val = val;
							}
						}
					}
				}
			}
			if (isBetweenOp) {
				jql += (i > 0 ? ' ' + condition + ' ' : '') + '(' + this['field'] + ' >= "' + val[0] + '" and ' + this['field'] + ' <= "' + val[1] + '")';
			} else {
				if (isDaysOp) {
					var minus = '';
					if (operator === 'last_n') {
						minus = '-';
					}
					jql += (i > 0 ? ' ' + condition + ' ' : '') + '(' + this['field'] + ' >=startOfDay(' + minus + val + 'd) and ' + this['field'] + ' < startOfDay(1d))';
				} else {
					operator = GLOBAL.operatorMapFE[operator];
					jql += (i > 0 ? ' ' + condition + ' ' : '') + '(' + this['field'] + ' ' + operator + ' ' + (isInOp ? '(' : '') + val + (isInOp ? ')' : '') + ')';
				}
			}

			i++;
		}
	});
	return "(" + jql + ")";
};

Filter.prototype.fieldFilter = function(data) {
	$('#dialog-field-filter-condition').queryBuilder('destroy');
	var field = data.field;
	GLOBAL.filterFieldData = data;
	var filters = [];
	var filter = null;
	$.each(GLOBAL.filters, function() {
		if (field.name === 'Epic Name') {
			return false;
		}
		if (this.id === 'filter_' + field.id) {
			filter = JSON.parse(JSON.stringify(this));
			return false;
		}
		if (this.id === 'filter_project' && field.id === 'project_name') {
			filter = JSON.parse(JSON.stringify(this));
			return false;
		}
	});
	if (!filter) {
		filter = {};
		filter.id = 'filter_' + field.id;
		filter.label = field.name;
		filter.field = field.name;
		switch (field.type) {
		case 'NUMBER':
			filter.type = "double";
			break;
		case 'TIMESTAMP':
			filter.type = "date";
			break;
		default:
			filter.type = "string";
			break;
		}
		if (field.id === 'worklog_author.name') {
			filter.field = 'worklogAuthor';
			filter.user = true;
			filter.auto = true;
			filter.operators = [ 'equal', 'not_equal', 'in', 'not_in' ];
		}
		if (field.id === 'worklog_started') {
			filter.field = 'worklogDate';
		}
	}
	if (filter.type === "double") {
		filter.operators = [ 'equal', 'not_equal', 'less', 'less_or_equal', 'greater', 'greater_or_equal' ];
	}
	if (filter.type === "date") {
		filter.operators = [ 'between', 'less', 'less_or_equal', 'greater', 'greater_or_equal','last_n' ];
	}
	if (filter.type === "string") {
		if (filter.operators) {
			removeValuesFromArray(filter.operators, [ 'is_empty', 'is_not_empty', 'greater', 'greater_or_equal', 'less', 'less_or_equal' ]);
		} else {
			filter.operators = [ 'equal', 'not_equal', 'contains', 'not_contains' ];
		}
	}
	if (field.aggregate) {
		filter.label = fieldDisplay(field, true);
	}
	filters.push(filter);

	this.buildCustomInterface($('#dialog-field-filter-condition'), filters);
	try {
		$('#dialog-field-filter-condition').queryBuilder('setRules', JSON.parse(field.filterValue));
	} catch (err) {
	}
	$('#dialog-field-filter').modal({
		backdrop : 'static',
		keyboard : false
	});
};
Filter.prototype.saveFieldFilter = function() {
	var value = JSON.stringify($('#dialog-field-filter-condition').queryBuilder('getRules'));
	GLOBAL.filterFieldData.field.filterValue = value;
	addField(GLOBAL.filterFieldData.section, GLOBAL.filterFieldData.field, true);
	$('#dialog-field-filter').modal('hide');
};
