$(document).ready(function() {
	$('body').on('click', function(event) {
		if ($(event.target).closest('.xlfiltercontainer').length === 0) {
			$(".xlfiltercontainer").hide();
		}
	});
});
var xlFilters = {};

function attachGrpXlFilter(idx, f, c, $table) {
	if ($('#groupFilters').length === 0) {
		gf = $('<div id="groupFilters" style="margin-top:5px"></div>');
		gf.insertAfter(c);
	}
	$('#groupFilters').append('<button class="btn btn-default btn-sm btn-nofocus">' + (f.label ? f.label : f.name) + '<span id="filter-group-' + idx + '" class="xlfiltericon" style="margin-left:10px;margin-right:0px;float:none"><i class="fa fa-filter" aria-hidden="true"></i></button></span> ');
	attachXlFilter(idx, $('#filter-group-' + idx), true, $table);
}
function attachXlFilter(idx, ele, grpBy, $table) {
	var fid = (grpBy ? 'grp-' : 'ngrp-') + idx;
	xlFilters[fid] = {
		idx : idx,
		uniqVal : [],
		uniqValSel : {},
		grpBy : grpBy
	};
	$(ele).parent().append($('<div class="xlfiltercontainer"><div class="xlfilter"></div><div><button id="ok" type="button"  class="btn btn-xs btn-primary">Ok</button> <button id="close" type="button" class="btn btn-xs btn-default">Cancel</button></div><div>'));
	var filterGrid = $(ele).parent().find(".xlfilter");
	var filterGridCont = $(ele).parent().find(".xlfiltercontainer");
	var $closeBtn = filterGridCont.find("#close");
	var $okBtn = filterGridCont.find("#ok");

	$closeBtn.click(function() {
		filterGridCont.hide();
		return false;
	});

	$okBtn.click(function() {
		var all = true;
		filterGrid.find(".grid-item").each(function() {
			var sel = $(this).find("input").is(":checked");
			xlFilters[fid].uniqValSel[$(this).data().val] = sel;
			if (!sel) {
				all = false;
			}
		});

		if (!all) {
			$(ele).css('color', '#e50000');
		} else {
			$(ele).css('color', '#ecb5ae');
		}
		filterGridCont.hide();
		doFiltering($(ele).parent(), $table);
		return false;
	});

	$(ele).click(function(e) {
		e.stopPropagation();
		showFilterOption(fid, $(this).parent(), e, grpBy, $table);
	});
};

function showFilterOption(fid, tdObject, e, grpBy, $table) {
	var filterGrid = $(tdObject).find(".xlfilter");
	var filterGridCont = $(tdObject).find(".xlfiltercontainer");

	if (filterGridCont.is(":visible")) {
		filterGridCont.hide();
		return;
	}

	$(".xlfiltercontainer").hide();
	filterGrid.empty();

	var allSelected = true;
	filterGrid.append('<div class="checkbox"><label><input id="all" type="checkbox">Select All</label></div>');

	if (xlFilters[fid].uniqVal.length === 0) {
		var $rows = $table.find("tbody tr");
		$rows.each(function(ind, ele) {
			if (grpBy) {
				if (!isGrpHdr($(ele).children()[0])) {
					return true;
				}
				var currentTd = $($(ele).children()[0]);
				if (currentTd.hasClass('aio-gh-' + xlFilters[fid].idx)) {
					var val = tdVal(currentTd);
					xlFilters[fid].uniqVal.push(val);
				}
			} else {
				if (isGrpHdr($(ele).children()[0])) {
					return true;
				}
				var val = eleVal(xlFilters[fid].idx, ele);
				xlFilters[fid].uniqVal.push(val);
			}
		});
		xlFilters[fid].uniqVal = uniq(xlFilters[fid].uniqVal);
		$.each(xlFilters[fid].uniqVal, function() {
			xlFilters[fid].uniqValSel[this] = true;
		});
	}
	$.each(xlFilters[fid].uniqVal, function() {
		var chk = $('<div class="grid-item checkbox"><label><input type="checkbox" ' + (xlFilters[fid].uniqValSel[this] ? 'checked' : '') + '>' + this + '</label></div>');
		chk.data({
			val : this.toString()
		});
		filterGrid.append(chk);
		if (!xlFilters[fid].uniqValSel[this]) {
			allSelected = false;
		}
	});

	if (!allSelected) {
		filterGrid.find("#all").prop("checked", false);
	} else {
		filterGrid.find("#all").prop("checked", true);
	}

	filterGridCont.show();
	filterGridCont.offset({
		top : e.pageY,
		left : e.pageX - 23
	});
	var $gridItems = filterGrid.find(".grid-item").find("[type='checkbox']");
	var $all = filterGrid.find("#all");

	$gridItems.click(function(event) {
		if (!$(this).is(":checked")) {
			$all.prop("checked", false);
		}
	});

	$all.change(function() {
		filterGrid.find(".grid-item [type='checkbox']").prop("checked", $(this).is(":checked"));
	})

	filterGridCont.click(function(event) {
		event.stopPropagation();
	});

	return filterGrid;
}

function doFiltering(tdObject, $table) {
	var $rows = $table.find("tbody tr");
	var filteredCols = [];
	$.each(xlFilters, function() {
		if (this.uniqVal.length > 0) {
			filteredCols.push(this);
		}
	});
	$rows.each(function(ind, ele) {
		$(ele).data('hide', false);
	});
	$rows.each(function(ind, ele) {
		if (!$(ele).data('hide')) {
			$.each(filteredCols, function() {
				var val = null;
				if (this.grpBy) {
					if (!isGrpHdr($(ele).children()[0])) {
						return true;
					}
					var currentTd = $($(ele).children()[0]);
					if (currentTd.hasClass('aio-gh-' + this.idx)) {
						val = tdVal(currentTd);
					} else {
						return true;
					}
				} else {
					if (isGrpHdr($(ele).children()[0])) {
						return true;
					}
					val = eleVal(this.idx, ele);
				}

				if (!this.uniqValSel[val]) {
					$(ele).data('hide', true);
					if (this.grpBy) {
						var childRows = Grid.findGroupChildren($(ele).children()[0]);
						childRows.data('hide', true);
					}
					return false;
				}
			});
		}
	});
	$rows.each(function(ind, ele) {
		if ($(ele).data('hide')) {
			$(ele).hide();
		} else {
			$(ele).show();
		}
	});

}

function eleVal(idx, ele) {
	var currentTd = $(ele).children()[idx];
	return tdVal(currentTd);
}
function tdVal(td) {
	var e = $(td).find('pre');
	if (e.find('a').length > 0) {
		e = e.find('a');
	}
	var val = e.html();
	return val;
}

function isGrpHdr(ele) {
	return $(ele).hasClass('aio-gh');
}