var AioDto = function() {
};
AioDto.prototype.build = function() {
	var dto = {};
	dto.aioReportId = GLOBAL.aioReportId;
	dto.type = getReportType();
	if ($('#aio-report-name').length > 0) {
		dto.name = $('#aio-report-name').editable('getValue', true);
	}
	if (dto.name === '') {
		dto.name = 'No name';
	}
	dto.row = getSectionFields('row');
	dto.column = getSectionFields('column');
	dto.data = getSectionFields('data');
	dto.issues = [];
	var filter = new Filter();
	dto.filterType = filter.type();
	dto.filterValue = filter.getValue(dto.filterType);
	dto.jql = filter.jql();
	dto.baseJql = dto.jql;
	dto.quickTimesheet = GLOBAL.quickTimesheet;
	dto.timeInStatus = GLOBAL.timeInStatus;
	dto.loggedInUserName = GLOBAL.loggedInUserName;
	dto.timeEntry = false;

	if (dto.type === 'timesheet') {
		var tsh = new TimesheetHelper();
		dto.dateRange = tsh.getDateRange();
		dto.startDate = tsh.getStartDate();
		dto.endDate = tsh.getEndDate();
		dto.days = tsh.getDays();
		dto.timesheetInterval = tsh.getInterval();
		var fWlDt = clone(findField('worklog_started'));
		if (dto.timesheetInterval === 'daily') {
			fWlDt.pattern = 'MMM dd, yyyy';
		}
		if (dto.timesheetInterval === 'weekly') {
			fWlDt.pattern = 'w-yyyy';
		}
		if (dto.timesheetInterval === 'monthly') {
			fWlDt.pattern = 'MMM-yyyy';
		}
		if (dto.timesheetInterval === 'quarterly') {
			fWlDt.pattern = 'Quarter';
		}
		dto.column.push(fWlDt);
		dto.data.push(findField('worklog_timeSpentSeconds'));
		var timesheetJql = tsh.getJql();
		if (dto.jql === '') {
			dto.jql = timesheetJql;
		} else {
			if (timesheetJql != '') {
				dto.jql = '(' + dto.jql + ') and ' + timesheetJql;
			}
		}
		dto.users = tsh.getUsers();
		dto.projects = tsh.getProjects();
		dto.issueTypes = tsh.getIssueTypes();
		dto.includeSubTasks = tsh.getIncludeSubTasks();
		dto.subIssueTypes = GLOBAL.subIssueTypes;
		dto.includeNonWorklog = tsh.getIncludeNonWorklog();
	} else {
		if (dto.type === 'trend') {
			var trh = new TrendHelper();
			dto.trendField = trh.getField();
			dto.trendValues = trh.getValues();
			dto.trendInterval = trh.getInterval();
			dto.trendOutputFormat = trh.getOutputFormat();
			dto.dateRange = trh.getDateRange();
			dto.startDate = trh.getStartDate();
			dto.endDate = trh.getEndDate();
			dto.breakByIssueType = trh.getBreakByIssueType();
			dto.showPercentages = trh.getShowPercentages();
			dto.showCumulative = trh.getShowCumulative();
			dto.issueTypes = GLOBAL.parentIssueTypes.concat(GLOBAL.subIssueTypes);
			if (dto.trendOutputFormat === 'table') {
				if (dto.trendField === 'created_resolved') {
					dto.row = [ findField('aio_event') ];
				} else {
					dto.row = [ findField(trh.getField()) ];
				}
				if (dto.breakByIssueType) {
					dto.row.push(findField('issuetype'));
				}
				dto.column = [ findField('aio_interval') ];
			} else {
				if (dto.trendField === 'created_resolved') {
					dto.column = [ findField('aio_event') ];
				} else {
					dto.column = [ findField(trh.getField()) ];
				}
				dto.row = [ findField('aio_interval') ];
			}
			if (dto.showPercentages) {
				dto.data = [ findField('aio_total_percent') ];
			} else {
				dto.data = [ findField('aio_total') ];
			}
		} else {
			if (dto.type === 'time-in-status') {
				var tish = new TimeInStatusHelper();
				dto.type = 'matrix';
				dto.projects = tish.getProjects();
				var measure = $('#aio-tis-measure').val();
				if (measure.indexOf('changelog_status') === 0) {
					dto.column = [ findField('changelog_status') ];
					var statuses = tish.getStatuses();
					if (statuses == '') {
						dto.column[0].filterValue = null;
					} else {
						dto.column[0].filterValue = JSON.stringify({
							"condition" : "AND",
							"rules" : [ {
								"id" : "filter_changelog_status",
								"field" : "History Status",
								"type" : "string",
								"input" : "text",
								"operator" : "in",
								"value" : tish.getStatuses()
							} ]
						});
					}
				} else {
					dto.column = [ findField('changelog_assignee') ];
				}
				dto.data = [ findField(measure) ];
			} else {
				if (dto.type === 'timesheet-entry') {
					dto.type = 'timesheet';
					var tsh = new TimeEntryHelper();
					dto.dateRange = 'custom';
					dto.startDate = tsh.getStartDate();
					dto.endDate = tsh.getEndDate();
					dto.timesheetInterval = 'daily';
					dto.row.push(findField('issuekey'));
					dto.row.push(findField('summary'));
					var fpr = findField('project_name')
					fpr.groupBy = true;
					dto.row.push(fpr);
					var fWlDt = clone(findField('worklog_started'));
					fWlDt.pattern = 'MMM dd, yyyy';
					dto.column.push(fWlDt);
					dto.data.push(findField('worklog_timeSpentSeconds'));
					dto.jql = tsh.getJql(dto.startDate, dto.endDate);
					dto.timeEntry = true;
					dto.users = [ {
						'userkey' : GLOBAL.loggedInUserKey,
						'username' : GLOBAL.loggedInUserName,
						'type' : 'user'
					} ];
				}
			}
		}
	}
	return dto;
};
