$(function() {
	$(".sortable").sortable({
		opacity : 0.7,
		revert : true,
		tolerance : "pointer",
		placeholder : "ui-sortable-placeholder",
		forcePlaceholderSize : true
	});
	$(".sortable").disableSelection();

	$(".droppable").droppable({
		classes : {
			"ui-droppable-active" : "ui-state-active",
			"ui-droppable-hover" : "ui-state-hover"
		},
		drop : function(event, ui) {
			if (!$(ui.draggable[0]).hasClass('dropdown')) {
				addField($(this), $(ui.draggable[0]).data().field);
			}
		},
		accept : function(ui) {
			var accepts = $(this).attr('accepts');
			if (accepts === 'both') {
				return true;
			}
			if (accepts === 'dimension') {
				return !$(ui).data().field.measure;
			}
			if (accepts === 'measure') {
				return $(ui).data().field.measure;
			}
		}
	});
});