$(function() {
	$('#myCustomTrigger').remove();
	var _load = function() {
		if (GLOBAL.schemaLoaded && GLOBAL.issueTypesLoaded) {
			GLOBAL.doNotAutoHideAlert = true;
			GLOBAL.doNotShowAlert = true;
			new DashboardItemView().render();
			$('#dashboard-select-saved-report').change(function() {
				displayConfig();
			});
		} else {
			setTimeout(function() {
				_load();
			}, 500);
		}
	};
	_load();
});
var displayConfig = function(config) {
	GLOBAL.dashboardConfig = {};
	var configType;
	if (config) {
		configType = GLOBAL.configType[config.aioReport];
		if (!configType) {
			configType = GLOBAL.configType[config.report];
		}
	} else {
		configType = GLOBAL.configType[$('#dashboard-select-saved-report')
				.val()];
	}
	var elShow, elHide;
	if (configType === 'table') {
		elShow = $('#div-gadget-rows');
		elHide = $('#div-gadget-pixels');
		GLOBAL.dashboardConfig.height = '';
	} else {
		elShow = $('#div-gadget-pixels');
		elHide = $('#div-gadget-rows');
		GLOBAL.dashboardConfig.height = 400;
	}

	elShow.show();
	elHide.hide();
	if (config && config.height && !isNaN(config.height)) {
		elShow.find("input").val(config.height);
		GLOBAL.dashboardConfig = config;
	} else {
		elShow.find("input").val(GLOBAL.dashboardConfig.height);
	}
};

var ReportView = function() {
	return {
		setTitle : function(config) {
			if (config) {
				AP.require([ 'jira' ],
						function(jira) {
							jira.setDashboardItemTitle('AIO: '
									+ (config.title === '' ? 'No name'
											: config.title));
						});
			} else {
				AP.require([ 'jira' ], function(jira) {
					jira.setDashboardItemTitle('AIO');
				});
			}
		},
		render : function(configuration) {
			GLOBAL.CONFIG_VIEW = false;
			displayConfig(configuration);
			this.setTitle(configuration);
			var rs = new ReportService();
			rs.ac.post('open', {
				aioReportId : configuration.aioReport,
				legacyReportId : configuration.report,
				schema : GLOBAL.schema,
				dashboard : true
			}, function(results) {
				function timeout() {
					if (!GLOBAL.CONFIG_VIEW && configuration.refreshPeriod
							&& configuration.refreshPeriod > 0) {
						setTimeout(function() {
							if (!GLOBAL.CONFIG_VIEW) {
								(new ReportService()).runDto(results, false);
								timeout();
							}
						}, Number(configuration.refreshPeriod) * 60000);
					}
				}
				rs.runDto(results, false);
				timeout();

			});
			$('#dashboardReportResults').show();
			$('#dashboardItemConfigTemplate').hide();

		}
	};
};

var DashboardItemConfigurationView = function() {
	return {
		render : function(config) {
			GLOBAL.CONFIG_VIEW = true;
			$('#dashboardReportResults').hide();
			$('#dashboardItemConfigTemplate').show();
			if (config) {
				if (config.aioReport) {
					$('#dashboard-select-saved-report').val(config.aioReport);
				} else {
					$('#dashboard-select-saved-report').val(config.report);
				}
				if (config.refreshPeriod) {
					$('#dashboard-select-refresh-report').val(
							config.refreshPeriod);
				} else {
					$('#dashboard-select-refresh-report').val(-1);
				}
			}
			displayConfig(config);
			$('#btn-dashboard-save').click(
					function(e) {
						e.preventDefault();
						var service = new DashboardItemConfigurationService();
						var $title = $('#dashboard-select-saved-report').find(
								':selected').html();
						var $report = $('#dashboard-select-saved-report').find(
								':selected').val();
						var configType = GLOBAL.configType[$report];
						var $height = (configType === 'table' ? $(
								'#dashboard-txt-rows').val() : $(
								'#dashboard-txt-pixels').val());
						var $refreshPeriod = $(
								'#dashboard-select-refresh-report').find(
								':selected').val();
						var configuration = {
							aioReport : $report,
							title : $title,
							height : $height,
							refreshPeriod : $refreshPeriod
						};
						service.save(configuration, function() {
							new ReportView().render(configuration);
						});
					});
		}
	};
};

var DashboardItemConfigurationService = function() {
	return {
		getConfiguration : function(configuredCallback, errorCallback) {
			AP.require([ 'request' ], function(request) {
				request({
					url : '/rest/api/latest/dashboard/' + GLOBAL.dashboard
							+ '/items/' + GLOBAL.dashboardItem
							+ '/properties/itemkey',
					success : function(response) {
						configuredCallback(JSON.parse(response).value);
					}
				});
			});
		},
		isConfigured : function(configuredCallback, notConfiguredCallback) {
			var that = this;
			AP.require([ 'request' ], function(request) {
				request({
					url : '/rest/api/latest/dashboard/' + GLOBAL.dashboard
							+ '/items/' + GLOBAL.dashboardItem + '/properties',
					success : function(response) {
						var arrayOfProperties = JSON.parse(response).keys;
						var configured = false;
						$.each(arrayOfProperties, function(index, prop) {
							if (prop.key == 'itemkey') {
								configured = true;
							}
						});
						if (configured) {
							that.getConfiguration(configuredCallback);
						} else {
							notConfiguredCallback();
						}
					}
				});
			});
		},
		save : function(configuration, successCallback) {
			AP.require([ 'request' ], function(request) {
				request({
					url : '/rest/api/latest/dashboard/' + GLOBAL.dashboard
							+ '/items/' + GLOBAL.dashboardItem
							+ '/properties/itemkey',
					type : 'PUT',
					contentType : 'application/json',
					data : JSON.stringify(configuration),
					success : successCallback
				});
			});
		}
	};
};

var DashboardItemView = function() {
	return {
		render : function() {
			var service = new DashboardItemConfigurationService();
			service.isConfigured(function(config) {
				new ReportView().render(config);
			}, function() {
				new DashboardItemConfigurationView().render();
			});
		}
	};
};

AP.require([ 'jira' ], function(jira) {
	jira.DashboardItem.onDashboardItemEdit(function() {
		new DashboardItemConfigurationService().getConfiguration(function(
				config) {
			new DashboardItemConfigurationView().render(config);
		});
	});
});