var AioClient = function() {
};

AioClient.prototype.post = function(url, _data, cb) {
	$.ajax({
		type : 'POST',
		url : clientUrl(url),
		cache : false,
		contentType : 'application/json; charset=UTF-8',
		dataType : 'json',
		data : JSON.stringify({
			data : _data,
			metrics : GLOBAL.metrics
		}),
		success : function(response) {
			GLOBAL.metrics = response.metrics;
			GLOBAL.metrics.et = (new Date()).getTime();
			cb(response.results);
		},
		error : function(request, status, err) {
			(new AioAlert()).error(request);
			$('#dialog-block-ui').modal('hide');
		}
	});
};

AioClient.prototype.get = function(url, cb, params, _public) {

	$.ajax({
		type : 'GET',
		url : clientUrl(url, _public) + (params ? ('&' + params) : ''),
		cache : false,
		success : function(response) {
			cb(response.results);
		},
		error : function(request, status, err) {
			(new AioAlert()).error(request);
			$('#dialog-block-ui').modal('hide');
			$('.aio-spinner').hide();
		}
	});
};