var AioChart = function(view) {
	this.view = view;
};

AioChart.prototype.render = function(dto, element, type) {
	$(element).show();
	$(element).html('');
	if (GLOBAL.dashboardConfig && GLOBAL.dashboardConfig.height) {
		$(element).css('height', GLOBAL.dashboardConfig.height + 'px');
	} else {
		$(element).css('height', 'calc(100%)');
	}
	if (type === 'bar') {
		this.bar(dto, element);
	}
	if (type === 'line') {
		this.line(dto, element);
	}
	if (type === 'pie') {
		this.pie(dto, element);
	}
};

AioChart.prototype.bar = function(dto, element) {

	var buildDataset = function(index, aggregateField, results) {
		var dataset = {};
		if (aggregateField) {
			dataset.key = aggregateField.label ? aggregateField.label : aggregateField.name;
		} else {
			dataset.key = aggregateField.toString();
		}
		dataset.values = [];
		$.each(results, function() {
			dataset.values.push({
				label : this[0],
				value : (isNaN(this[index + 1]) ? 0 : this[index + 1])
			});
		});
		return dataset;
	}

	var render = function(_data, index, rowLabel, dataLabel) {
		nv.addGraph(function() {
			var chart = null;
			if (dto.data.length > 1) {
				chart = nv.models.multiBarChart();
				chart.rotateLabels(-45);
			} else {
				chart = nv.models.discreteBarChart().showValues(true);
				chart.xAxis.rotateLabels(-45);
			}
			chart.x(function(d) {
				return d.label;
			}).y(function(d) {
				return d.value;
			}).duration(350);
			chart.margin({
				bottom : 150,
				left : 100
			});

			var id = 'bar_' + index;
			$(element).append('<div id="div_' + id + '"></div><svg id="' + id + '"></svg>');
			d3.select("#" + id).datum(_data).call(chart);
			if (rowLabel) {
				$("#div_" + id).append('<h4>' + rowLabel + ' - ' + dataLabel + '</h4>');
			}
			nv.utils.windowResize(chart.update);
		});
	}

	var data = [];
	var obj = this;
	if (dto.column.length === 0) {
		$.each(dto.data, function(index) {
			data.push(buildDataset(index, this, obj.view));
		});
		render(data, 0);
	} else {
		if (obj.view.chartData.length === 1) {
			$.each(dto.data, function(index) {
				data.push(buildDataset(index, this, obj.view.chartData[0]));
			});
			render(data, 0);
		} else {
			$.each(obj.view.chartData, function(i) {
				data = [];
				var v = this;
				$.each(dto.data, function(j) {
					data.push(buildDataset(j, this, v));
				});
				var df = obj.view.dataFields[i];
				var rf = dto.row[0];
				render(data, i, (rf.label ? rf.label : rf.name), (df.label ? df.label : df.name));
			});
		}
	}
};

AioChart.prototype.line = function(dto, element) {
	var buildDataset = function(index, aggregateField, results) {
		var dataset = {};
		if (aggregateField) {
			dataset.key = aggregateField.label ? aggregateField.label : aggregateField.name;
		} else {
			dataset.key = aggregateField.toString();
		}
		dataset.values = [];
		$.each(results, function(i) {
			dataset.values.push({
				x : i,
				y : (isNaN(this[index + 1]) ? 0 : this[index + 1])
			});
		});
		return dataset;
	}
	var rowField = dto.row[0];
	var xAxisLabel = rowField.label ? rowField.label : rowField.name;

	var render = function(_data, index, view, rowLabel, dataLabel) {
		nv.addGraph(function() {
			var chart = nv.models.lineChart().options({
				duration : 300,
				useInteractiveGuideline : true,
			});
			chart.xAxis.axisLabel(xAxisLabel).tickFormat(function(d) {
				if (d % 1 === 0) {
					return view[d][0];
				} else {
					return '';
				}
			});
			chart.xAxis.rotateLabels(-45);
			chart.margin({
				bottom : 150,
				left : 100
			});

			var id = 'line_' + index;
			$(element).append('<div id="div_' + id + '"></div><svg id="' + id + '"></svg>');
			d3.select("#" + id).datum(_data).call(chart);
			if (rowLabel) {
				$("#div_" + id).append('<h4>' + rowLabel + ' - ' + dataLabel + '</h4>');
			}
			nv.utils.windowResize(chart.update);
		});
	}
	var data = [];
	var obj = this;
	if (dto.column.length === 0) {
		$.each(dto.data, function(index) {
			data.push(buildDataset(index, this, obj.view));
		});
		render(data, 0, obj.view);
	} else {
		if (obj.view.chartData.length === 1) {
			$.each(dto.data, function(index) {
				data.push(buildDataset(index, this, obj.view.chartData[0]));
			});
			render(data, 0, obj.view.chartData[0]);
		} else {
			$.each(obj.view.chartData, function(i) {
				data = [];
				var v = this;
				$.each(dto.data, function(j) {
					data.push(buildDataset(j, this, v));
				});
				var df = obj.view.dataFields[i];
				render(data, i, v, xAxisLabel, (df.label ? df.label : df.name));
			});
		}
	}
};

AioChart.prototype.pie = function(dto, element) {
	var obj = this;
	$.each(dto.data, function(index) {
		var data = [];
		var total = 0;
		$.each(obj.view, function() {
			var val = (isNaN(this[index + 1]) ? 0 : this[index + 1]);
			total += val;
			data.push([ this[0], val ]);
		});
		nv.addGraph(function() {
			var chart = nv.models.pieChart().x(function(d) {
				var p = Math.round(d[1] * 1000 / total);
				p = p / 10;
				return d[0] + ' (' + (d[1] ? d[1] : '-') + ', ' + p + '%)';
			}).y(function(d) {
				return d[1];
			}).showLabels(true).labelType("key").labelThreshold(0.01);
			var id = 'pie_' + index;
			$(element).append('<div id="div_' + id + '"></div><svg id="' + id + '"></svg>');
			d3.select("#" + id).datum(data).transition().duration(1200).call(chart);
			$("#div_" + id).append('<h4>' + (dto.row[0].label ? dto.row[0].label : dto.row[0].name) + ' - ' + (dto.data[index].label ? dto.data[index].label : dto.data[index].name) + '</h4>');
			nv.utils.windowResize(chart.update);
		});
	});
};