var AioAdmin = function() {

};

$(function() {
	var jc = new JiraClient();
	var ac = new AioClient();
	jc.get('groups/picker?maxResults=5000', function(groups) {
		var g = groups.groups;
		var table = $('#groups');
		$.each(g, function() {
			var tr = $('<tr></tr>');
			tr.append(td = $('<td></td>'));
			td.html(this.name);
			tr.append(td = $('<td style="text-align:center"><input type="checkbox" name="aio_access_create" value="' + this.name + '"></td>'));
			tr.append(td = $('<td style="text-align:center"><input type="checkbox" name="aio_access_other_time" value="' + this.name + '"></td>'));
			table.append(tr);
		});
		ac.get('getPermissions', function(response) {
			var p = response;
			if (JSON.stringify(p) === '{}') {
				$("input[type='checkbox'][name='aio_access_create']").each(function() {
					$(this).attr('checked', true);
				});
				$("input[type='checkbox'][name='aio_access_other_time']").each(function() {
					$(this).attr('checked', true);
				});
			} else {
				var accessCreateGroups = p['aio_access_create'];
				var accessOtherTimeGroups = p['aio_access_other_time'];

				$.each(accessCreateGroups, function() {
					$("input[type='checkbox'][name='aio_access_create'][value='" + this + "']").each(function() {
						$(this).attr('checked', true);
					});
				});
				$.each(accessOtherTimeGroups, function() {
					$("input[type='checkbox'][name='aio_access_other_time'][value='" + this + "']").each(function() {
						$(this).attr('checked', true);
					});
				});
			}
		});
	});

	$('[data-toggle="tooltip"]').tooltip({
		template : '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
	});

	$('#save').click(function() {
		var accessCreateGroups = [];
		$("input[type='checkbox'][name='aio_access_create']:checked").each(function() {
			accessCreateGroups.push($(this).val());
		});
		var accessOtherTimeGroups = [];
		$("input[type='checkbox'][name='aio_access_other_time']:checked").each(function() {
			accessOtherTimeGroups.push($(this).val());
		});
		ac.post('savePermissions', {
			'aio_access_create' : accessCreateGroups,
			'aio_access_other_time' : accessOtherTimeGroups
		}, function(response) {
			if (GLOBAL.cloud) {
				jc.post('/properties/aio_access', {
					'aio_access_create' : accessCreateGroups,
					'aio_access_other_time' : accessOtherTimeGroups
				}, function(response) {
				}, false, true, true);
			}
			(new AioAlert()).success('Permissions saved successfully.');
		});

	});

	$('#save_preferences').click(function() {
		var preferences = [];
		var allValid = true;
		$("input").each(function() {
			if ($(this).attr("aioValType")) {
				if ($(this).attr("aioValType") === 'number') {
					if (isNaN($(this).val()) || $(this).val().trim() === '') {
						allValid = false;
						(new AioAlert()).warning('Please provide a valid number.');
					} else {
						preferences.push({
							'key' : $(this).attr("key"),
							'val' : $(this).val()
						});
					}
				}
				if ($(this).attr("aioValType") === 'checkbox') {
					preferences.push({
						'key' : $(this).attr("name"),
						'val' : $(this).is(':checked')
					});
				}
			}
		});
		if (allValid) {
			ac.post('saveAddOnPreferences', {
				'preferences' : preferences
			}, function(response) {
				(new AioAlert()).success('Preferences saved successfully.');
			});
		}
	});

	$('#cancel').click(function() {
		if (GLOBAL.cloud) {

		} else {

		}
	});
});