/*
 * Decompiled with CFR 0.152.
 */
package repackage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import repackage.Repackager;

public class Repackage {
    private File _sourceBase;
    private File _targetBase;
    private List _fromPackages;
    private List _toPackages;
    private Pattern _packagePattern;
    private Repackager _repackager;
    private Map _movedDirs;
    private List _moveAlongFiles;
    private int _skippedFiles;

    public static void main(String[] args) throws Exception {
        new Repackage(args).repackage();
    }

    private Repackage(String[] args) {
        String sourceDir = null;
        String targetDir = null;
        String repackageSpec = null;
        boolean failure = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-repackage") && i2 + 1 < args.length) {
                repackageSpec = args[++i2];
                continue;
            }
            if (args[i2].equals("-f") && i2 + 1 < args.length) {
                sourceDir = args[++i2];
                continue;
            }
            if (args[i2].equals("-t") && i2 + 1 < args.length) {
                targetDir = args[++i2];
                continue;
            }
            failure = true;
        }
        if (failure || repackageSpec == null || sourceDir == null ^ targetDir == null) {
            throw new RuntimeException("Usage: repackage -repackage [spec] [ -f [sourcedir] -t [targetdir] ]");
        }
        this._repackager = new Repackager(repackageSpec);
        if (sourceDir == null || targetDir == null) {
            return;
        }
        this._sourceBase = new File(sourceDir);
        this._targetBase = new File(targetDir);
    }

    public void repackage() throws Exception {
        if (this._sourceBase == null || this._targetBase == null) {
            System.out.println(this._repackager.repackage(this.readInputStream(System.in)).toString());
            return;
        }
        this._fromPackages = this._repackager.getFromPackages();
        this._toPackages = this._repackager.getToPackages();
        this._packagePattern = Pattern.compile("^\\s*package\\s+((?:\\w|\\.)*)\\s*;", 8);
        this._moveAlongFiles = new ArrayList();
        this._movedDirs = new HashMap();
        this._targetBase.mkdirs();
        ArrayList files = new ArrayList();
        this.fillFiles(files, this._sourceBase);
        System.out.println("Repackaging " + files.size() + " files ...");
        int prefixLength = this._sourceBase.getCanonicalPath().length();
        for (int i2 = 0; i2 < files.size(); ++i2) {
            File from = (File)files.get(i2);
            String name = from.getCanonicalPath().substring(prefixLength + 1);
            this.repackageFile(name);
        }
        this.finishMovingFiles();
        if (this._skippedFiles > 0) {
            System.out.println("Skipped " + this._skippedFiles + " unmodified files.");
        }
    }

    private boolean fileIsUnchanged(String name) {
        File sourceFile = new File(this._sourceBase, name);
        File targetFile = new File(this._targetBase, name);
        return sourceFile.lastModified() < targetFile.lastModified();
    }

    public void repackageFile(String name) throws IOException {
        if (name.endsWith(".java")) {
            this.repackageJavaFile(name);
        } else if (name.endsWith(".xsdconfig") || name.endsWith(".xml") || name.endsWith(".g")) {
            this.repackageNonJavaFile(name);
        } else if (name.startsWith("bin" + File.separatorChar)) {
            this.repackageNonJavaFile(name);
        } else {
            this.moveAlongWithJavaFiles(name);
        }
    }

    public void moveAlongWithJavaFiles(String name) {
        this._moveAlongFiles.add(name);
    }

    public void finishMovingFiles() throws IOException {
        Iterator i2 = this._moveAlongFiles.iterator();
        while (i2.hasNext()) {
            String name;
            String toName = name = (String)i2.next();
            String srcDir = Repackager.dirForPath(name);
            String toDir = (String)this._movedDirs.get(srcDir);
            if (toDir != null) {
                toName = new File(toDir, new File(name).getName()).toString();
            }
            if (name.endsWith(".html")) {
                this.repackageNonJavaFile(name, toName);
                continue;
            }
            this.justMoveNonJavaFile(name, toName);
        }
    }

    public void repackageNonJavaFile(String name) throws IOException {
        File sourceFile = new File(this._sourceBase, name);
        File targetFile = new File(this._targetBase, name);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
        } else {
            this.writeFile(targetFile, this._repackager.repackage(this.readFile(sourceFile)));
        }
    }

    public void repackageNonJavaFile(String sourceName, String targetName) throws IOException {
        File sourceFile = new File(this._sourceBase, sourceName);
        File targetFile = new File(this._targetBase, targetName);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
        } else {
            this.writeFile(targetFile, this._repackager.repackage(this.readFile(sourceFile)));
        }
    }

    public void justMoveNonJavaFile(String sourceName, String targetName) throws IOException {
        File sourceFile = new File(this._sourceBase, sourceName);
        File targetFile = new File(this._targetBase, targetName);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
        } else {
            Repackage.copyFile(sourceFile, targetFile);
        }
    }

    public void repackageJavaFile(String name) throws IOException {
        File sourceFile = new File(this._sourceBase, name);
        StringBuffer sb = this.readFile(sourceFile);
        Matcher packageMatcher = this._packagePattern.matcher(sb);
        if (packageMatcher.find()) {
            boolean swapped;
            String pkg = packageMatcher.group(1);
            int pkgStart = packageMatcher.start(1);
            int pkgEnd = packageMatcher.end(1);
            if (packageMatcher.find()) {
                throw new RuntimeException("Two package specifications found: " + name);
            }
            ArrayList filePath = Repackager.splitPath(name, File.separatorChar);
            String srcDir = Repackager.dirForPath(name);
            do {
                swapped = false;
                for (int i2 = 1; i2 < filePath.size(); ++i2) {
                    String spec1 = (String)filePath.get(i2 - 1);
                    String spec2 = (String)filePath.get(i2);
                    if (spec1.indexOf(58) >= spec2.indexOf(58)) continue;
                    filePath.set(i2 - 1, spec2);
                    filePath.set(i2, spec1);
                    swapped = true;
                }
            } while (swapped);
            ArrayList pkgPath = Repackager.splitPath(pkg, '.');
            int f2 = filePath.size() - 2;
            if (f2 < 0 || filePath.size() - 1 < pkgPath.size()) {
                throw new RuntimeException("Package spec differs from file path: " + name);
            }
            for (int i3 = pkgPath.size() - 1; i3 >= 0; --i3) {
                if (!pkgPath.get(i3).equals(filePath.get(f2))) {
                    throw new RuntimeException("Package spec differs from file path: " + name);
                }
                --f2;
            }
            List changeTo = null;
            List changeFrom = null;
            block3: for (int i4 = 0; i4 < this._fromPackages.size(); ++i4) {
                List from = (List)this._fromPackages.get(i4);
                if (from.size() > pkgPath.size()) continue;
                for (int j2 = 0; j2 < from.size(); ++j2) {
                    if (!from.get(j2).equals(pkgPath.get(j2))) continue block3;
                }
                changeFrom = from;
                changeTo = (List)this._toPackages.get(i4);
                break;
            }
            if (changeTo != null) {
                int i5;
                String newPkg = "";
                String newName = "";
                for (i5 = 0; i5 < changeTo.size(); ++i5) {
                    if (i5 > 0) {
                        newPkg = newPkg + ".";
                        newName = newName + File.separatorChar;
                    }
                    newPkg = newPkg + changeTo.get(i5);
                    newName = newName + changeTo.get(i5);
                }
                for (i5 = filePath.size() - pkgPath.size() - 2; i5 >= 0; --i5) {
                    newName = (String)filePath.get(i5) + File.separatorChar + newName;
                }
                for (i5 = changeFrom.size(); i5 < pkgPath.size(); ++i5) {
                    newName = newName + File.separatorChar + (String)pkgPath.get(i5);
                    newPkg = newPkg + '.' + (String)pkgPath.get(i5);
                }
                newName = newName + File.separatorChar + (String)filePath.get(filePath.size() - 1);
                sb.replace(pkgStart, pkgEnd, newPkg);
                name = newName;
                String newDir = Repackager.dirForPath(name);
                if (!srcDir.equals(newDir)) {
                    this._movedDirs.put(srcDir, newDir);
                }
            }
        }
        File targetFile = new File(this._targetBase, name);
        if (sourceFile.lastModified() < targetFile.lastModified()) {
            ++this._skippedFiles;
            return;
        }
        this.writeFile(new File(this._targetBase, name), this._repackager.repackage(sb));
    }

    void writeFile(File f2, StringBuffer chars) throws IOException {
        f2.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(f2);
        OutputStreamWriter w2 = new OutputStreamWriter(out);
        StringReader r2 = new StringReader(chars.toString());
        Repackage.copy(r2, w2);
        ((Reader)r2).close();
        ((Writer)w2).close();
        ((OutputStream)out).close();
    }

    StringBuffer readFile(File f2) throws IOException {
        FileInputStream in2 = new FileInputStream(f2);
        InputStreamReader r2 = new InputStreamReader(in2);
        StringWriter w2 = new StringWriter();
        Repackage.copy(r2, w2);
        w2.close();
        ((Reader)r2).close();
        ((InputStream)in2).close();
        return w2.getBuffer();
    }

    StringBuffer readInputStream(InputStream is2) throws IOException {
        InputStreamReader r2 = new InputStreamReader(is2);
        StringWriter w2 = new StringWriter();
        Repackage.copy(r2, w2);
        w2.close();
        ((Reader)r2).close();
        return w2.getBuffer();
    }

    public static void copyFile(File from, File to) throws IOException {
        to.getParentFile().mkdirs();
        FileInputStream in2 = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        Repackage.copy(in2, out);
        out.close();
        in2.close();
    }

    public static void copy(InputStream in2, OutputStream out) throws IOException {
        int n2;
        byte[] buffer = new byte[16384];
        while ((n2 = in2.read(buffer, 0, buffer.length)) >= 0) {
            out.write(buffer, 0, n2);
        }
    }

    public static void copy(Reader r2, Writer w2) throws IOException {
        int n2;
        char[] buffer = new char[16384];
        while ((n2 = r2.read(buffer, 0, buffer.length)) >= 0) {
            w2.write(buffer, 0, n2);
        }
    }

    public void fillFiles(ArrayList files, File file) throws IOException {
        if (!file.isDirectory()) {
            files.add(file);
            return;
        }
        if (file.getName().equals("build")) {
            return;
        }
        if (file.getName().equals("CVS")) {
            return;
        }
        String[] entries = file.list();
        for (int i2 = 0; i2 < entries.length; ++i2) {
            this.fillFiles(files, new File(file, entries[i2]));
        }
    }

    public void recursiveDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            String[] entries = file.list();
            for (int i2 = 0; i2 < entries.length; ++i2) {
                this.recursiveDelete(new File(file, entries[i2]));
            }
        }
        file.delete();
    }
}

