/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedList;

public class ClassUtils {
    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> a2) {
        for (Class<?> c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            if (c2.isAnnotationPresent(a2)) {
                return true;
            }
            if (!ClassUtils.isAnnotationPresentOnInterfaces(c2, a2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresentOnInterfaces(Class<?> clazz, Class<? extends Annotation> a2) {
        for (Class<?> i2 : clazz.getInterfaces()) {
            if (i2.isAnnotationPresent(a2)) {
                return true;
            }
            if (!ClassUtils.isAnnotationPresentOnInterfaces(i2, a2)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> aClazz) {
        for (Class<?> c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            T anno = c2.getAnnotation(aClazz);
            if (anno == null) continue;
            return anno;
        }
        LinkedList q2 = new LinkedList();
        q2.add(clazz);
        while (!q2.isEmpty()) {
            Class c3 = (Class)q2.remove();
            if (c3 == null) continue;
            if (c3.isInterface()) {
                T anno = c3.getAnnotation(aClazz);
                if (anno != null) {
                    return anno;
                }
            } else {
                q2.add(c3.getSuperclass());
            }
            q2.addAll(Arrays.asList(c3.getInterfaces()));
        }
        return null;
    }
}

