/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.TriggerFiredBundle;

public class PropertySettingJobFactory
extends SimpleJobFactory {
    private boolean warnIfNotFound = false;
    private boolean throwIfNotFound = false;

    @Override
    public Job newJob(TriggerFiredBundle bundle, Scheduler scheduler) throws SchedulerException {
        Job job = super.newJob(bundle, scheduler);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll(scheduler.getContext());
        jobDataMap.putAll(bundle.getJobDetail().getJobDataMap());
        jobDataMap.putAll(bundle.getTrigger().getJobDataMap());
        this.setBeanProps(job, jobDataMap);
        return job;
    }

    protected void setBeanProps(Object obj, JobDataMap data) throws SchedulerException {
        BeanInfo bi2 = null;
        try {
            bi2 = Introspector.getBeanInfo(obj.getClass());
        }
        catch (IntrospectionException e2) {
            this.handleError("Unable to introspect Job class.", e2);
        }
        PropertyDescriptor[] propDescs = bi2.getPropertyDescriptors();
        for (Map.Entry entry : data.getWrappedMap().entrySet()) {
            String name = (String)entry.getKey();
            String c2 = name.substring(0, 1).toUpperCase(Locale.US);
            String methName = "set" + c2 + name.substring(1);
            Method setMeth = this.getSetMethod(methName, propDescs);
            Class<?> paramType = null;
            Object o2 = null;
            try {
                if (setMeth == null) {
                    this.handleError("No setter on Job class " + obj.getClass().getName() + " for property '" + name + "'");
                    continue;
                }
                paramType = setMeth.getParameterTypes()[0];
                o2 = entry.getValue();
                Object parm = null;
                if (paramType.isPrimitive()) {
                    if (o2 == null) {
                        this.handleError("Cannot set primitive property '" + name + "' on Job class " + obj.getClass().getName() + " to null.");
                        continue;
                    }
                    if (paramType.equals(Integer.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Integer.valueOf((String)o2);
                        } else if (o2 instanceof Integer) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Long.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Long.valueOf((String)o2);
                        } else if (o2 instanceof Long) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Float.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Float.valueOf((String)o2);
                        } else if (o2 instanceof Float) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Double.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Double.valueOf((String)o2);
                        } else if (o2 instanceof Double) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Boolean.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Boolean.valueOf((String)o2);
                        } else if (o2 instanceof Boolean) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Byte.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Byte.valueOf((String)o2);
                        } else if (o2 instanceof Byte) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Short.TYPE)) {
                        if (o2 instanceof String) {
                            parm = Short.valueOf((String)o2);
                        } else if (o2 instanceof Short) {
                            parm = o2;
                        }
                    } else if (paramType.equals(Character.TYPE)) {
                        if (o2 instanceof String) {
                            String str = (String)o2;
                            if (str.length() == 1) {
                                parm = Character.valueOf(str.charAt(0));
                            }
                        } else if (o2 instanceof Character) {
                            parm = o2;
                        }
                    }
                } else if (o2 != null && paramType.isAssignableFrom(o2.getClass())) {
                    parm = o2;
                }
                if (o2 != null && parm == null) {
                    this.handleError("The setter on Job class " + obj.getClass().getName() + " for property '" + name + "' expects a " + paramType + " but was given " + o2.getClass().getName());
                    continue;
                }
                setMeth.invoke(obj, parm);
            }
            catch (NumberFormatException nfe) {
                this.handleError("The setter on Job class " + obj.getClass().getName() + " for property '" + name + "' expects a " + paramType + " but was given " + o2.getClass().getName(), nfe);
            }
            catch (IllegalArgumentException e3) {
                this.handleError("The setter on Job class " + obj.getClass().getName() + " for property '" + name + "' expects a " + paramType + " but was given " + o2.getClass().getName(), e3);
            }
            catch (IllegalAccessException e4) {
                this.handleError("The setter on Job class " + obj.getClass().getName() + " for property '" + name + "' could not be accessed.", e4);
            }
            catch (InvocationTargetException e5) {
                this.handleError("The setter on Job class " + obj.getClass().getName() + " for property '" + name + "' could not be invoked.", e5);
            }
        }
    }

    private void handleError(String message) throws SchedulerException {
        this.handleError(message, null);
    }

    private void handleError(String message, Exception e2) throws SchedulerException {
        if (this.isThrowIfPropertyNotFound()) {
            throw new SchedulerException(message, e2);
        }
        if (this.isWarnIfPropertyNotFound()) {
            if (e2 == null) {
                this.getLog().warn(message);
            } else {
                this.getLog().warn(message, (Throwable)e2);
            }
        }
    }

    private Method getSetMethod(String name, PropertyDescriptor[] props) {
        for (int i2 = 0; i2 < props.length; ++i2) {
            Method wMeth = props[i2].getWriteMethod();
            if (wMeth == null || wMeth.getParameterTypes().length != 1 || !wMeth.getName().equals(name)) continue;
            return wMeth;
        }
        return null;
    }

    public boolean isThrowIfPropertyNotFound() {
        return this.throwIfNotFound;
    }

    public void setThrowIfPropertyNotFound(boolean throwIfNotFound) {
        this.throwIfNotFound = throwIfNotFound;
    }

    public boolean isWarnIfPropertyNotFound() {
        return this.warnIfNotFound;
    }

    public void setWarnIfPropertyNotFound(boolean warnIfNotFound) {
        this.warnIfNotFound = warnIfNotFound;
    }
}

