/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.spi.OperableTrigger;

public class TriggerUtils {
    private TriggerUtils() {
    }

    public static List<Date> computeFireTimes(OperableTrigger trigg, Calendar cal, int numTimes) {
        Date d2;
        LinkedList<Date> lst = new LinkedList<Date>();
        OperableTrigger t2 = (OperableTrigger)trigg.clone();
        if (t2.getNextFireTime() == null) {
            t2.computeFirstFireTime(cal);
        }
        for (int i2 = 0; i2 < numTimes && (d2 = t2.getNextFireTime()) != null; ++i2) {
            lst.add(d2);
            t2.triggered(cal);
        }
        return Collections.unmodifiableList(lst);
    }

    public static Date computeEndTimeToAllowParticularNumberOfFirings(OperableTrigger trigg, Calendar cal, int numTimes) {
        Date d2;
        OperableTrigger t2 = (OperableTrigger)trigg.clone();
        if (t2.getNextFireTime() == null) {
            t2.computeFirstFireTime(cal);
        }
        int c2 = 0;
        Date endTime = null;
        for (int i2 = 0; i2 < numTimes && (d2 = t2.getNextFireTime()) != null; ++i2) {
            t2.triggered(cal);
            if (++c2 != numTimes) continue;
            endTime = d2;
        }
        if (endTime == null) {
            return null;
        }
        endTime = new Date(endTime.getTime() + 1000L);
        return endTime;
    }

    public static List<Date> computeFireTimesBetween(OperableTrigger trigg, Calendar cal, Date from, Date to) {
        Date d2;
        LinkedList<Date> lst = new LinkedList<Date>();
        OperableTrigger t2 = (OperableTrigger)trigg.clone();
        if (t2.getNextFireTime() == null) {
            t2.setStartTime(from);
            t2.setEndTime(to);
            t2.computeFirstFireTime(cal);
        }
        while ((d2 = t2.getNextFireTime()) != null) {
            if (d2.before(from)) {
                t2.triggered(cal);
                continue;
            }
            if (d2.after(to)) break;
            lst.add(d2);
            t2.triggered(cal);
        }
        return Collections.unmodifiableList(lst);
    }
}

