/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueUuid
extends Value {
    private static final int PRECISION = 16;
    private static final int DISPLAY_SIZE = 36;
    private final long high;
    private final long low;

    private ValueUuid(long l2, long l3) {
        this.high = l2;
        this.low = l3;
    }

    @Override
    public int hashCode() {
        return (int)(this.high >>> 32 ^ this.high ^ this.low >>> 32 ^ this.low);
    }

    public static ValueUuid getNewRandom() {
        long l2 = MathUtils.secureRandomLong();
        long l3 = MathUtils.secureRandomLong();
        l2 = l2 & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        l3 = l3 & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new ValueUuid(l2, l3);
    }

    public static ValueUuid get(byte[] byArray) {
        if (byArray.length < 16) {
            return ValueUuid.get(StringUtils.convertBytesToHex(byArray));
        }
        long l2 = Utils.readLong(byArray, 0);
        long l3 = Utils.readLong(byArray, 8);
        return (ValueUuid)Value.cache(new ValueUuid(l2, l3));
    }

    public static ValueUuid get(long l2, long l3) {
        return (ValueUuid)Value.cache(new ValueUuid(l2, l3));
    }

    public static ValueUuid get(String string) {
        long l2 = 0L;
        long l3 = 0L;
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                l2 = l2 << 4 | (long)(c2 - 48);
            } else if (c2 >= 'a' && c2 <= 'f') {
                l2 = l2 << 4 | (long)(c2 - 97 + 10);
            } else {
                if (c2 == '-') continue;
                if (c2 >= 'A' && c2 <= 'F') {
                    l2 = l2 << 4 | (long)(c2 - 65 + 10);
                } else {
                    if (c2 <= ' ') continue;
                    throw DbException.get(22018, string);
                }
            }
            if (n2++ != 15) continue;
            l3 = l2;
            l2 = 0L;
        }
        return (ValueUuid)Value.cache(new ValueUuid(l3, l2));
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.getString());
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public long getPrecision() {
        return 16L;
    }

    private static void appendHex(StringBuilder stringBuilder, long l2, int n2) {
        for (int i2 = n2 * 8 - 4; i2 >= 0; i2 -= 8) {
            stringBuilder.append(Integer.toHexString((int)(l2 >> i2) & 0xF)).append(Integer.toHexString((int)(l2 >> i2 - 4) & 0xF));
        }
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(36);
        ValueUuid.appendHex(stringBuilder, this.high >> 32, 4);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.high >> 16, 2);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.high, 2);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.low >> 48, 2);
        stringBuilder.append('-');
        ValueUuid.appendHex(stringBuilder, this.low, 6);
        return stringBuilder.toString();
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        if (value == this) {
            return 0;
        }
        ValueUuid valueUuid = (ValueUuid)value;
        if (this.high == valueUuid.high) {
            return MathUtils.compareLong(this.low, valueUuid.low);
        }
        return this.high > valueUuid.high ? 1 : -1;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueUuid && this.compareSecure((Value)object, null) == 0;
    }

    @Override
    public Object getObject() {
        return new UUID(this.high, this.low);
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[16];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)(this.high >> 8 * (7 - i2) & 0xFFL);
            byArray[8 + i2] = (byte)(this.low >> 8 * (7 - i2) & 0xFFL);
        }
        return byArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setBytes(n2, this.getBytes());
    }

    public long getHigh() {
        return this.high;
    }

    public long getLow() {
        return this.low;
    }

    @Override
    public int getDisplaySize() {
        return 36;
    }
}

