/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.TimeZone;
import org.h2.api.TimestampWithTimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueTime;

public class ValueTimestampTimeZone
extends Value {
    public static final int PRECISION = 30;
    static final int DISPLAY_SIZE = 30;
    static final int DEFAULT_SCALE = 10;
    private final long dateValue;
    private final long timeNanos;
    private final short timeZoneOffsetMins;

    private ValueTimestampTimeZone(long l2, long l3, short s2) {
        if (l3 < 0L || l3 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l3);
        }
        if (s2 < -720 || s2 >= 720) {
            throw new IllegalArgumentException("timeZoneOffsetMins out of range " + s2);
        }
        this.dateValue = l2;
        this.timeNanos = l3;
        this.timeZoneOffsetMins = s2;
    }

    public static ValueTimestampTimeZone fromDateValueAndNanos(long l2, long l3, short s2) {
        return (ValueTimestampTimeZone)Value.cache(new ValueTimestampTimeZone(l2, l3, s2));
    }

    public static ValueTimestampTimeZone get(TimestampWithTimeZone timestampWithTimeZone) {
        long l2 = timestampWithTimeZone.getTime();
        long l3 = timestampWithTimeZone.getNanos() % 1000000;
        long l4 = DateTimeUtils.dateValueFromDate(l2);
        return ValueTimestampTimeZone.fromDateValueAndNanos(l4, l3 += DateTimeUtils.nanosFromDate(l2), timestampWithTimeZone.getTimeZoneOffsetMins());
    }

    public static ValueTimestampTimeZone fromMillisNanos(long l2, int n2, short s2) {
        long l3 = DateTimeUtils.dateValueFromDate(l2);
        long l4 = (long)n2 + DateTimeUtils.nanosFromDate(l2);
        return ValueTimestampTimeZone.fromDateValueAndNanos(l3, l4, s2);
    }

    public static ValueTimestampTimeZone fromMillis(long l2, short s2) {
        long l3 = DateTimeUtils.dateValueFromDate(l2);
        long l4 = DateTimeUtils.nanosFromDate(l2);
        return ValueTimestampTimeZone.fromDateValueAndNanos(l3, l4, s2);
    }

    public static ValueTimestampTimeZone parse(String string) {
        try {
            return ValueTimestampTimeZone.parseTry(string);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP WITH TIMEZONE", string);
        }
    }

    private static ValueTimestampTimeZone parseTry(String string) {
        long l2;
        int n2;
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n3 = string.indexOf(84);
        }
        if (n3 < 0) {
            n3 = string.length();
            n2 = -1;
        } else {
            n2 = n3 + 1;
        }
        long l3 = DateTimeUtils.parseDateValue(string, 0, n3);
        short s2 = 0;
        if (n2 < 0) {
            l2 = 0L;
        } else {
            int n4 = string.length();
            if (string.endsWith("Z")) {
                --n4;
            } else {
                String string2;
                int n5 = string.indexOf(43, n3);
                if (n5 < 0) {
                    n5 = string.indexOf(45, n3);
                }
                TimeZone timeZone = null;
                if (n5 >= 0) {
                    string2 = "GMT" + string.substring(n5);
                    timeZone = TimeZone.getTimeZone(string2);
                    if (!timeZone.getID().startsWith(string2)) {
                        throw new IllegalArgumentException(string2 + " (" + timeZone.getID() + "?)");
                    }
                    n4 = n5;
                } else {
                    n5 = string.indexOf(32, n3 + 1);
                    if (n5 > 0) {
                        string2 = string.substring(n5 + 1);
                        timeZone = TimeZone.getTimeZone(string2);
                        if (!timeZone.getID().startsWith(string2)) {
                            throw new IllegalArgumentException(string2);
                        }
                        n4 = n5;
                    }
                }
                if (timeZone != null) {
                    long l4 = DateTimeUtils.convertDateValueToDate(l3).getTime();
                    s2 = (short)(timeZone.getOffset(l4) / 1000 / 60);
                }
            }
            l2 = DateTimeUtils.parseTimeNanos(string, n3 + 1, n4, true);
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(l3, l2, s2);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    public short getTimeZoneOffsetMins() {
        return this.timeZoneOffsetMins;
    }

    @Override
    public Timestamp getTimestamp() {
        Timestamp timestamp = DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.timeNanos);
        return new TimestampWithTimeZone(timestamp.getTime(), timestamp.getNanos(), this.getTimeZoneOffsetMins());
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(30);
        ValueDate.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        ValueTime.appendTime(stringBuilder, this.timeNanos, true);
        ValueTimestampTimeZone.appendTimeZone(stringBuilder, this.timeZoneOffsetMins);
        return stringBuilder.toString();
    }

    private static void appendTimeZone(StringBuilder stringBuilder, short s2) {
        if (s2 < 0) {
            stringBuilder.append('-');
            s2 = -s2;
        } else {
            stringBuilder.append('+');
        }
        int n2 = s2 / 60;
        short s3 = s2 = (short)(s2 - n2 * 60);
        StringUtils.appendZeroPadded(stringBuilder, 2, n2);
        if (s3 != 0) {
            stringBuilder.append(':');
            StringUtils.appendZeroPadded(stringBuilder, 2, s3);
        }
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP WITH TIMEZONE '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 30L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 30;
    }

    @Override
    public Value convertScale(boolean bl2, int n2) {
        if (n2 >= 10) {
            return this;
        }
        if (n2 < 0) {
            throw DbException.getInvalidValueException("scale", n2);
        }
        long l2 = this.timeNanos;
        BigDecimal bigDecimal = BigDecimal.valueOf(l2);
        bigDecimal = bigDecimal.movePointLeft(9);
        bigDecimal = ValueDecimal.setScale(bigDecimal, n2);
        long l3 = (bigDecimal = bigDecimal.movePointRight(9)).longValue();
        if (l3 == l2) {
            return this;
        }
        return ValueTimestampTimeZone.fromDateValueAndNanos(this.dateValue, l3, this.timeZoneOffsetMins);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
        int n2 = MathUtils.compareLong(this.dateValue, valueTimestampTimeZone.dateValue);
        if (n2 != 0) {
            return n2;
        }
        n2 = MathUtils.compareLong(this.timeNanos, valueTimestampTimeZone.timeNanos);
        if (n2 != 0) {
            return n2;
        }
        return MathUtils.compareInt(this.timeZoneOffsetMins, valueTimestampTimeZone.timeZoneOffsetMins);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestampTimeZone)) {
            return false;
        }
        ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)object;
        return this.dateValue == valueTimestampTimeZone.dateValue && this.timeNanos == valueTimestampTimeZone.timeNanos && this.timeZoneOffsetMins == valueTimestampTimeZone.timeZoneOffsetMins;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32 ^ (long)this.timeZoneOffsetMins);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setString(n2, this.getString());
    }

    @Override
    public Value add(Value value) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIMEZONE values is unsupported");
    }

    @Override
    public Value subtract(Value value) {
        throw DbException.getUnsupportedException("manipulating TIMESTAMP WITH TIMEZONE values is unsupported");
    }
}

