/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueTime;

public class ValueTimestamp
extends Value {
    public static final int PRECISION = 23;
    static final int DISPLAY_SIZE = 23;
    static final int DEFAULT_SCALE = 10;
    private final long dateValue;
    private final long timeNanos;

    private ValueTimestamp(long l2, long l3) {
        this.dateValue = l2;
        if (l3 < 0L || l3 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l3);
        }
        this.timeNanos = l3;
    }

    public static ValueTimestamp fromDateValueAndNanos(long l2, long l3) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(l2, l3));
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        long l2 = timestamp.getTime();
        long l3 = timestamp.getNanos() % 1000000;
        long l4 = DateTimeUtils.dateValueFromDate(l2);
        return ValueTimestamp.fromDateValueAndNanos(l4, l3 += DateTimeUtils.nanosFromDate(l2));
    }

    public static ValueTimestamp fromMillisNanos(long l2, int n2) {
        long l3 = DateTimeUtils.dateValueFromDate(l2);
        long l4 = (long)n2 + DateTimeUtils.nanosFromDate(l2);
        return ValueTimestamp.fromDateValueAndNanos(l3, l4);
    }

    public static ValueTimestamp fromMillis(long l2) {
        long l3 = DateTimeUtils.dateValueFromDate(l2);
        long l4 = DateTimeUtils.nanosFromDate(l2);
        return ValueTimestamp.fromDateValueAndNanos(l3, l4);
    }

    public static ValueTimestamp parse(String string) {
        try {
            return ValueTimestamp.parseTry(string);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP", string);
        }
    }

    private static ValueTimestamp parseTry(String string) {
        long l2;
        int n2;
        int n3 = string.indexOf(32);
        if (n3 < 0) {
            n3 = string.indexOf(84);
        }
        if (n3 < 0) {
            n3 = string.length();
            n2 = -1;
        } else {
            n2 = n3 + 1;
        }
        long l3 = DateTimeUtils.parseDateValue(string, 0, n3);
        if (n2 < 0) {
            l2 = 0L;
        } else {
            int n4;
            int n5 = string.length();
            TimeZone timeZone = null;
            if (string.endsWith("Z")) {
                timeZone = TimeZone.getTimeZone("UTC");
                --n5;
            } else {
                String string2;
                n4 = string.indexOf(43, n3);
                if (n4 < 0) {
                    n4 = string.indexOf(45, n3);
                }
                if (n4 >= 0) {
                    string2 = "GMT" + string.substring(n4);
                    timeZone = TimeZone.getTimeZone(string2);
                    if (!timeZone.getID().startsWith(string2)) {
                        throw new IllegalArgumentException(string2 + " (" + timeZone.getID() + "?)");
                    }
                    n5 = n4;
                } else {
                    n4 = string.indexOf(32, n3 + 1);
                    if (n4 > 0) {
                        string2 = string.substring(n4 + 1);
                        timeZone = TimeZone.getTimeZone(string2);
                        if (!timeZone.getID().startsWith(string2)) {
                            throw new IllegalArgumentException(string2);
                        }
                        n5 = n4;
                    }
                }
            }
            l2 = DateTimeUtils.parseTimeNanos(string, n3 + 1, n5, true);
            if (timeZone != null) {
                n4 = DateTimeUtils.yearFromDateValue(l3);
                int n6 = DateTimeUtils.monthFromDateValue(l3);
                int n7 = DateTimeUtils.dayFromDateValue(l3);
                long l4 = l2 / 1000000L;
                l2 -= l4 * 1000000L;
                long l5 = l4 / 1000L;
                l4 -= l5 * 1000L;
                int n8 = (int)(l5 / 60L);
                l5 -= (long)(n8 * 60);
                int n9 = n8 / 60;
                long l6 = DateTimeUtils.getMillis(timeZone, n4, n6, n7, n9, n8 -= n9 * 60, (int)l5, (int)l4);
                l4 = DateTimeUtils.convertToLocal(new Date(l6), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long l7 = 86400000L;
                long l8 = (l4 >= 0L ? l4 : l4 - l7 + 1L) / l7;
                l3 = DateTimeUtils.dateValueFromAbsoluteDay(l8);
                l2 += (l4 -= l8 * l7) * 1000000L;
            }
        }
        return ValueTimestamp.fromDateValueAndNanos(l3, l2);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.timeNanos);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(23);
        ValueDate.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        ValueTime.appendTime(stringBuilder, this.timeNanos, true);
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 23L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 23;
    }

    @Override
    public Value convertScale(boolean bl2, int n2) {
        if (n2 >= 10) {
            return this;
        }
        if (n2 < 0) {
            throw DbException.getInvalidValueException("scale", n2);
        }
        long l2 = this.timeNanos;
        BigDecimal bigDecimal = BigDecimal.valueOf(l2);
        bigDecimal = bigDecimal.movePointLeft(9);
        bigDecimal = ValueDecimal.setScale(bigDecimal, n2);
        long l3 = (bigDecimal = bigDecimal.movePointRight(9)).longValue();
        if (l3 == l2) {
            return this;
        }
        return ValueTimestamp.fromDateValueAndNanos(this.dateValue, l3);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value;
        int n2 = MathUtils.compareLong(this.dateValue, valueTimestamp.dateValue);
        if (n2 != 0) {
            return n2;
        }
        return MathUtils.compareLong(this.timeNanos, valueTimestamp.timeNanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)object;
        return this.dateValue == valueTimestamp.dateValue && this.timeNanos == valueTimestamp.timeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setTimestamp(n2, this.getTimestamp());
    }

    @Override
    public Value add(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l2 = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long l3 = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        return DateTimeUtils.normalizeTimestamp(l2 + l3, this.timeNanos + valueTimestamp.timeNanos);
    }

    @Override
    public Value subtract(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l2 = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long l3 = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        return DateTimeUtils.normalizeTimestamp(l2 - l3, this.timeNanos - valueTimestamp.timeNanos);
    }
}

