/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueTime
extends Value {
    public static final int PRECISION = 6;
    static final int DISPLAY_SIZE = 8;
    private final long nanos;

    private ValueTime(long l2) {
        this.nanos = l2;
    }

    public static ValueTime fromNanos(long l2) {
        return (ValueTime)Value.cache(new ValueTime(l2));
    }

    public static ValueTime get(Time time) {
        return ValueTime.fromNanos(DateTimeUtils.nanosFromDate(time.getTime()));
    }

    public static ValueTime fromMillis(long l2) {
        return ValueTime.fromNanos(DateTimeUtils.nanosFromDate(l2));
    }

    public static ValueTime parse(String string) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(string, 0, string.length(), false));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIME", string);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public Time getTime() {
        return DateTimeUtils.convertNanoToTime(this.nanos);
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(8);
        ValueTime.appendTime(stringBuilder, this.nanos, false);
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "TIME '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 6L;
    }

    @Override
    public int getDisplaySize() {
        return 8;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        return MathUtils.compareLong(this.nanos, ((ValueTime)value).nanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ValueTime && this.nanos == ((ValueTime)object).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTime();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setTime(n2, this.getTime());
    }

    @Override
    public Value add(Value value) {
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        return ValueTime.fromNanos(this.nanos + valueTime.getNanos());
    }

    @Override
    public Value subtract(Value value) {
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        return ValueTime.fromNanos(this.nanos - valueTime.getNanos());
    }

    @Override
    public Value multiply(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos * value.getDouble()));
    }

    @Override
    public Value divide(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos / value.getDouble()));
    }

    @Override
    public int getSignum() {
        return Long.signum(this.nanos);
    }

    @Override
    public Value negate() {
        return ValueTime.fromNanos(-this.nanos);
    }

    static void appendTime(StringBuilder stringBuilder, long l2, boolean bl2) {
        if (l2 < 0L) {
            stringBuilder.append('-');
            l2 = -l2;
        }
        long l3 = l2 / 1000000L;
        l2 -= l3 * 1000000L;
        long l4 = l3 / 1000L;
        l3 -= l4 * 1000L;
        long l5 = l4 / 60L;
        l4 -= l5 * 60L;
        long l6 = l5 / 60L;
        StringUtils.appendZeroPadded(stringBuilder, 2, l6);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, l5 -= l6 * 60L);
        stringBuilder.append(':');
        StringUtils.appendZeroPadded(stringBuilder, 2, l4);
        if (bl2 || l3 > 0L || l2 > 0L) {
            stringBuilder.append('.');
            int n2 = stringBuilder.length();
            StringUtils.appendZeroPadded(stringBuilder, 3, l3);
            if (l2 > 0L) {
                StringUtils.appendZeroPadded(stringBuilder, 6, l2);
            }
            for (int i2 = stringBuilder.length() - 1; i2 > n2 && stringBuilder.charAt(i2) == '0'; --i2) {
                stringBuilder.deleteCharAt(i2);
            }
        }
    }
}

