/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.SysProperties;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueString
extends Value {
    private static final ValueString EMPTY = new ValueString("");
    protected final String value;

    protected ValueString(String string) {
        this.value = string;
    }

    @Override
    public String getSQL() {
        return StringUtils.quoteStringSQL(this.value);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueString && this.value.equals(((ValueString)object).value);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueString valueString = (ValueString)value;
        return compareMode.compareString(this.value, valueString.value, false);
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public long getPrecision() {
        return this.value.length();
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setString(n2, this.value);
    }

    @Override
    public int getDisplaySize() {
        return this.value.length();
    }

    @Override
    public int getMemory() {
        return this.value.length() * 2 + 48;
    }

    @Override
    public Value convertPrecision(long l2, boolean bl2) {
        if (l2 == 0L || (long)this.value.length() <= l2) {
            return this;
        }
        int n2 = MathUtils.convertLongToInt(l2);
        return this.getNew(this.value.substring(0, n2));
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int getType() {
        return 13;
    }

    public static Value get(String string) {
        return ValueString.get(string, false);
    }

    public static Value get(String string, boolean bl2) {
        if (string.isEmpty()) {
            return bl2 ? ValueNull.INSTANCE : EMPTY;
        }
        ValueString valueString = new ValueString(StringUtils.cache(string));
        if (string.length() > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueString;
        }
        return Value.cache(valueString);
    }

    protected Value getNew(String string) {
        return ValueString.get(string);
    }
}

