/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;

public class ValueResultSet
extends Value {
    private final ResultSet result;

    private ValueResultSet(ResultSet resultSet) {
        this.result = resultSet;
    }

    public static ValueResultSet get(ResultSet resultSet) {
        ValueResultSet valueResultSet = new ValueResultSet(resultSet);
        return valueResultSet;
    }

    public static ValueResultSet getCopy(ResultSet resultSet, int n2) {
        try {
            int n3;
            Object[] objectArray;
            int n4;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n5 = resultSetMetaData.getColumnCount();
            SimpleResultSet simpleResultSet = new SimpleResultSet();
            simpleResultSet.setAutoClose(false);
            ValueResultSet valueResultSet = new ValueResultSet(simpleResultSet);
            for (n4 = 0; n4 < n5; ++n4) {
                objectArray = resultSetMetaData.getColumnLabel(n4 + 1);
                n3 = resultSetMetaData.getColumnType(n4 + 1);
                int n6 = resultSetMetaData.getPrecision(n4 + 1);
                int n7 = resultSetMetaData.getScale(n4 + 1);
                simpleResultSet.addColumn((String)objectArray, n3, n6, n7);
            }
            for (n4 = 0; n4 < n2 && resultSet.next(); ++n4) {
                objectArray = new Object[n5];
                for (n3 = 0; n3 < n5; ++n3) {
                    objectArray[n3] = resultSet.getObject(n3 + 1);
                }
                simpleResultSet.addRow(objectArray);
            }
            return valueResultSet;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    public int getType() {
        return 18;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getString() {
        try {
            StatementBuilder statementBuilder = new StatementBuilder("(");
            this.result.beforeFirst();
            ResultSetMetaData resultSetMetaData = this.result.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            int n3 = 0;
            while (this.result.next()) {
                if (n3 > 0) {
                    statementBuilder.append(", ");
                }
                statementBuilder.append('(');
                statementBuilder.resetCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    statementBuilder.appendExceptFirst(", ");
                    int n4 = DataType.getValueTypeFromResultSet(resultSetMetaData, i2 + 1);
                    Value value = DataType.readValue(null, this.result, i2 + 1, n4);
                    statementBuilder.append(value.getString());
                }
                statementBuilder.append(')');
                ++n3;
            }
            this.result.beforeFirst();
            return statementBuilder.append(')').toString();
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        return this == value ? 0 : super.toString().compareTo(value.toString());
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public Object getObject() {
        return this.result;
    }

    @Override
    public ResultSet getResultSet() {
        return this.result;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    @Override
    public String getSQL() {
        return "";
    }

    @Override
    public Value convertPrecision(long l2, boolean bl2) {
        if (!bl2) {
            return this;
        }
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        simpleResultSet.setAutoClose(false);
        return ValueResultSet.get(simpleResultSet);
    }
}

