/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLong
extends Value {
    public static final BigInteger MAX = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigDecimal MIN_BD = BigDecimal.valueOf(Long.MIN_VALUE);
    public static final int PRECISION = 19;
    public static final int DISPLAY_SIZE = 20;
    private static final BigInteger MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final int STATIC_SIZE = 100;
    private static final ValueLong[] STATIC_CACHE = new ValueLong[100];
    private final long value;

    private ValueLong(long l2) {
        this.value = l2;
    }

    @Override
    public Value add(Value value) {
        ValueLong valueLong = (ValueLong)value;
        long l2 = this.value + valueLong.value;
        int n2 = Long.signum(this.value);
        int n3 = Long.signum(valueLong.value);
        int n4 = Long.signum(l2);
        if (n2 != n3 || n4 == n3 || n2 == 0 || n3 == 0) {
            return ValueLong.get(l2);
        }
        throw this.getOverflow();
    }

    @Override
    public int getSignum() {
        return Long.signum(this.value);
    }

    @Override
    public Value negate() {
        if (this.value == Long.MIN_VALUE) {
            throw this.getOverflow();
        }
        return ValueLong.get(-this.value);
    }

    private DbException getOverflow() {
        return DbException.get(22003, Long.toString(this.value));
    }

    @Override
    public Value subtract(Value value) {
        int n2;
        ValueLong valueLong = (ValueLong)value;
        int n3 = Long.signum(this.value);
        if (n3 == (n2 = Long.signum(valueLong.value)) || n2 == 0) {
            return ValueLong.get(this.value - valueLong.value);
        }
        return this.add(valueLong.negate());
    }

    private static boolean isInteger(long l2) {
        return l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE;
    }

    @Override
    public Value multiply(Value value) {
        BigInteger bigInteger;
        ValueLong valueLong = (ValueLong)value;
        long l2 = this.value * valueLong.value;
        if (this.value == 0L || this.value == 1L || valueLong.value == 0L || valueLong.value == 1L) {
            return ValueLong.get(l2);
        }
        if (ValueLong.isInteger(this.value) && ValueLong.isInteger(valueLong.value)) {
            return ValueLong.get(l2);
        }
        BigInteger bigInteger2 = BigInteger.valueOf(this.value);
        BigInteger bigInteger3 = bigInteger2.multiply(bigInteger = BigInteger.valueOf(valueLong.value));
        if (bigInteger3.compareTo(MIN) < 0 || bigInteger3.compareTo(MAX) > 0) {
            throw this.getOverflow();
        }
        return ValueLong.get(bigInteger3.longValue());
    }

    @Override
    public Value divide(Value value) {
        ValueLong valueLong = (ValueLong)value;
        if (valueLong.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value / valueLong.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueLong valueLong = (ValueLong)value;
        if (valueLong.value == 0L) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueLong.get(this.value % valueLong.value);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueLong valueLong = (ValueLong)value;
        return MathUtils.compareLong(this.value, valueLong.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 19L;
    }

    @Override
    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setLong(n2, this.value);
    }

    public static ValueLong get(long l2) {
        if (l2 >= 0L && l2 < 100L) {
            return STATIC_CACHE[(int)l2];
        }
        return (ValueLong)Value.cache(new ValueLong(l2));
    }

    @Override
    public int getDisplaySize() {
        return 20;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueLong && this.value == ((ValueLong)object).value;
    }

    static {
        for (int i2 = 0; i2 < 100; ++i2) {
            ValueLong.STATIC_CACHE[i2] = new ValueLong(i2);
        }
    }
}

