/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.LobStorageInterface;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLobDb
extends Value
implements Value.ValueClob,
Value.ValueBlob {
    private final int type;
    private final long lobId;
    private final byte[] hmac;
    private final byte[] small;
    private final DataHandler handler;
    private final long precision;
    private final String fileName;
    private final FileStore tempFile;
    private int tableId;
    private int hash;

    private ValueLobDb(int n2, DataHandler dataHandler, int n3, long l2, byte[] byArray, long l3) {
        this.type = n2;
        this.handler = dataHandler;
        this.tableId = n3;
        this.lobId = l2;
        this.hmac = byArray;
        this.precision = l3;
        this.small = null;
        this.fileName = null;
        this.tempFile = null;
    }

    private ValueLobDb(int n2, byte[] byArray, long l2) {
        this.type = n2;
        this.small = byArray;
        this.precision = l2;
        this.lobId = 0L;
        this.hmac = null;
        this.handler = null;
        this.fileName = null;
        this.tempFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb(DataHandler dataHandler, Reader reader, long l2) throws IOException {
        this.type = 16;
        this.handler = dataHandler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(dataHandler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        long l3 = 0L;
        try (FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(this.tempFile, null, null);){
            char[] cArray = new char[4096];
            while (true) {
                int n2 = ValueLobDb.getBufferSize(this.handler, false, l2);
                if ((n2 = IOUtils.readFully(reader, cArray, n2)) == 0) {
                    break;
                }
                byte[] byArray = new String(cArray, 0, n2).getBytes("UTF-8");
                fileStoreOutputStream.write(byArray);
                l3 += (long)n2;
            }
        }
        this.precision = l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueLobDb(DataHandler dataHandler, byte[] byArray, int n2, InputStream inputStream, long l2) throws IOException {
        this.type = 15;
        this.handler = dataHandler;
        this.small = null;
        this.lobId = 0L;
        this.hmac = null;
        this.fileName = ValueLobDb.createTempLobFileName(dataHandler);
        this.tempFile = this.handler.openFile(this.fileName, "rw", false);
        this.tempFile.autoDelete();
        FileStoreOutputStream fileStoreOutputStream = new FileStoreOutputStream(this.tempFile, null, null);
        long l3 = 0L;
        boolean bl2 = this.handler.getLobCompressionAlgorithm(15) != null;
        try {
            do {
                l3 += (long)n2;
                fileStoreOutputStream.write(byArray, 0, n2);
                if ((l2 -= (long)n2) <= 0L) {
                    break;
                }
                n2 = ValueLobDb.getBufferSize(this.handler, bl2, l2);
            } while ((n2 = IOUtils.readFully(inputStream, byArray, n2)) > 0);
        }
        finally {
            fileStoreOutputStream.close();
        }
        this.precision = l3;
    }

    private static String createTempLobFileName(DataHandler dataHandler) throws IOException {
        String string = dataHandler.getDatabasePath();
        if (string.length() == 0) {
            string = SysProperties.PREFIX_TEMP_FILE;
        }
        return FileUtils.createTempFile(string, ".temp.db", true, true);
    }

    public static ValueLobDb create(int n2, DataHandler dataHandler, int n3, long l2, byte[] byArray, long l3) {
        return new ValueLobDb(n2, dataHandler, n3, l2, byArray, l3);
    }

    @Override
    public Value convertTo(int n2) {
        if (n2 == this.type) {
            return this;
        }
        if (n2 == 16) {
            if (this.handler != null) {
                Value value = this.handler.getLobStorage().createClob(this.getReader(), -1L);
                return value;
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(n2, this.small);
            }
        } else if (n2 == 15) {
            if (this.handler != null) {
                Value value = this.handler.getLobStorage().createBlob(this.getInputStream(), -1L);
                return value;
            }
            if (this.small != null) {
                return ValueLobDb.createSmallLob(n2, this.small);
            }
        }
        return super.convertTo(n2);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.small == null && this.tableId >= 0;
    }

    public boolean isStored() {
        return this.small == null && this.fileName == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            Object object = this.handler.getLobSyncObject();
            synchronized (object) {
                FileUtils.delete(this.fileName);
            }
        }
        if (this.handler != null) {
            this.handler.getLobStorage().removeLob(this);
        }
    }

    @Override
    public Value copy(DataHandler dataHandler, int n2) {
        if (this.small == null) {
            ValueLobDb valueLobDb = this.handler.getLobStorage().copyLob(this, n2, this.getPrecision());
            return valueLobDb;
        }
        if (this.small.length > dataHandler.getMaxLengthInplaceLob()) {
            LobStorageInterface lobStorageInterface = dataHandler.getLobStorage();
            Value value = this.type == 15 ? lobStorageInterface.createBlob(this.getInputStream(), this.getPrecision()) : lobStorageInterface.createClob(this.getReader(), this.getPrecision());
            Value value2 = value.copy(dataHandler, n2);
            value.remove();
            return value2;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public String getString() {
        int n2 = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return new String(this.small, Constants.UTF8);
                }
                return IOUtils.readStringAndClose(this.getReader(), n2);
            }
            byte[] byArray = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), n2);
            return StringUtils.convertBytesToHex(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        Object object;
        if (value instanceof ValueLobDb) {
            object = (ValueLobDb)value;
            if (value == this) {
                return 0;
            }
            if (this.lobId == ((ValueLobDb)object).lobId && this.small == null && ((ValueLobDb)object).small == null) {
                return 0;
            }
        }
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(value.getString()));
        }
        object = value.getBytesNoCopy();
        return Utils.compareNotNullSigned(this.getBytes(), (byte[])object);
    }

    @Override
    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public InputStream getInputStream() {
        if (this.small != null) {
            return new ByteArrayInputStream(this.small);
        }
        if (this.fileName != null) {
            FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
            boolean bl2 = SysProperties.lobCloseBetweenReads;
            return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, false, bl2), 4096);
        }
        long l2 = this.type == 15 ? this.precision : -1L;
        try {
            return this.handler.getLobStorage().getInputStream(this, this.hmac, l2);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.toString());
        }
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        long l2 = this.getPrecision();
        if (l2 > Integer.MAX_VALUE || l2 <= 0L) {
            l2 = -1L;
        }
        if (this.type == 15) {
            preparedStatement.setBinaryStream(n2, this.getInputStream(), (int)l2);
        } else {
            preparedStatement.setCharacterStream(n2, this.getReader(), (int)l2);
        }
    }

    @Override
    public String getSQL() {
        if (this.type == 16) {
            String string = this.getString();
            return StringUtils.quoteStringSQL(string);
        }
        byte[] byArray = this.getBytes();
        String string = StringUtils.convertBytesToHex(byArray);
        return "X'" + string + "'";
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* table: ").append(this.tableId).append(" id: ").append(this.lobId).append(" */)");
        return stringBuilder.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueLobDb && this.compareSecure((Value)object, null) == 0;
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 104;
        }
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        return this;
    }

    @Override
    public ValueLobDb copyToResult() {
        if (this.handler == null) {
            return this;
        }
        LobStorageInterface lobStorageInterface = this.handler.getLobStorage();
        if (lobStorageInterface.isReadOnly()) {
            return this;
        }
        return lobStorageInterface.copyLob(this, -3, this.getPrecision());
    }

    public long getLobId() {
        return this.lobId;
    }

    @Override
    public String toString() {
        return "lob: " + this.fileName + " table: " + this.tableId + " id: " + this.lobId;
    }

    public static ValueLobDb createTempClob(Reader reader, long l2, DataHandler dataHandler) {
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, 4096);
        try {
            char[] cArray;
            Object object;
            int n2;
            boolean bl2 = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l3 = Long.MAX_VALUE;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLobDb.getBufferSize(dataHandler, bl2, l3)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(bufferedReader, -1);
                cArray = ((String)object).toCharArray();
                n2 = cArray.length;
            } else {
                cArray = new char[n2];
                bufferedReader.mark(n2);
                n2 = IOUtils.readFully(bufferedReader, cArray, n2);
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                object = new String(cArray, 0, n2).getBytes(Constants.UTF8);
                return ValueLobDb.createSmallLob(16, (byte[])object, n2);
            }
            bufferedReader.reset();
            object = new ValueLobDb(dataHandler, bufferedReader, l3);
            return object;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public static ValueLobDb createTempBlob(InputStream inputStream, long l2, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n2;
            boolean bl2;
            long l3 = Long.MAX_VALUE;
            boolean bl3 = bl2 = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLobDb.getBufferSize(dataHandler, bl2, l3)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n2 = byArray.length;
            } else {
                byArray = DataUtils.newBytes(n2);
                n2 = IOUtils.readFully(inputStream, byArray, n2);
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = DataUtils.newBytes(n2);
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return ValueLobDb.createSmallLob(15, byArray2, byArray2.length);
            }
            ValueLobDb valueLobDb = new ValueLobDb(dataHandler, byArray, n2, inputStream, l3);
            return valueLobDb;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl2, long l2) {
        long l3;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        int n2 = dataHandler.getMaxLengthInplaceLob();
        long l4 = l3 = bl2 ? 131072L : 4096L;
        if (l3 < l2 && l3 <= (long)n2) {
            l3 = Math.min(l2, (long)n2 + 1L);
            l3 = MathUtils.roundUpLong(l3, 4096L);
        }
        l3 = Math.min(l2, l3);
        if ((l3 = (long)MathUtils.convertLongToInt(l3)) < 0L) {
            l3 = Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    @Override
    public Value convertPrecision(long l2, boolean bl2) {
        ValueLobDb valueLobDb;
        if (this.precision <= l2) {
            return this;
        }
        if (this.type == 16) {
            if (this.handler == null) {
                try {
                    int n2 = MathUtils.convertLongToInt(l2);
                    String string = IOUtils.readStringAndClose(this.getReader(), n2);
                    byte[] byArray = string.getBytes(Constants.UTF8);
                    valueLobDb = ValueLobDb.createSmallLob(this.type, byArray, string.length());
                }
                catch (IOException iOException) {
                    throw DbException.convertIOException(iOException, null);
                }
            } else {
                valueLobDb = ValueLobDb.createTempClob(this.getReader(), l2, this.handler);
            }
        } else if (this.handler == null) {
            try {
                int n3 = MathUtils.convertLongToInt(l2);
                byte[] byArray = IOUtils.readBytesAndClose(this.getInputStream(), n3);
                valueLobDb = ValueLobDb.createSmallLob(this.type, byArray, byArray.length);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        } else {
            valueLobDb = ValueLobDb.createTempBlob(this.getInputStream(), l2, this.handler);
        }
        return valueLobDb;
    }

    public static Value createSmallLob(int n2, byte[] byArray) {
        int n3 = n2 == 16 ? new String(byArray, Constants.UTF8).length() : byArray.length;
        return ValueLobDb.createSmallLob(n2, byArray, n3);
    }

    public static ValueLobDb createSmallLob(int n2, byte[] byArray, long l2) {
        return new ValueLobDb(n2, byArray, l2);
    }
}

