/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLob
extends Value {
    private static int dirCounter;
    private final int type;
    private long precision;
    private DataHandler handler;
    private int tableId;
    private int objectId;
    private String fileName;
    private boolean linked;
    private byte[] small;
    private int hash;
    private boolean compressed;
    private FileStore tempFile;

    private ValueLob(int n2, DataHandler dataHandler, String string, int n3, int n4, boolean bl2, long l2, boolean bl3) {
        this.type = n2;
        this.handler = dataHandler;
        this.fileName = string;
        this.tableId = n3;
        this.objectId = n4;
        this.linked = bl2;
        this.precision = l2;
        this.compressed = bl3;
    }

    private ValueLob(int n2, byte[] byArray) {
        this.type = n2;
        this.small = byArray;
        if (byArray != null) {
            this.precision = n2 == 15 ? (long)byArray.length : (long)this.getString().length();
        }
    }

    private static ValueLob copy(ValueLob valueLob) {
        ValueLob valueLob2 = new ValueLob(valueLob.type, valueLob.handler, valueLob.fileName, valueLob.tableId, valueLob.objectId, valueLob.linked, valueLob.precision, valueLob.compressed);
        valueLob2.small = valueLob.small;
        valueLob2.hash = valueLob.hash;
        return valueLob2;
    }

    private static ValueLob createSmallLob(int n2, byte[] byArray) {
        return new ValueLob(n2, byArray);
    }

    private static String getFileName(DataHandler dataHandler, int n2, int n3) {
        if (SysProperties.CHECK && n2 == 0 && n3 == 0) {
            DbException.throwInternalError("0 LOB");
        }
        String string = n2 < 0 ? ".temp" : ".t" + n2;
        return ValueLob.getFileNamePrefix(dataHandler.getDatabasePath(), n3) + string + ".lob.db";
    }

    public static ValueLob openLinked(int n2, DataHandler dataHandler, int n3, int n4, long l2, boolean bl2) {
        String string = ValueLob.getFileName(dataHandler, n3, n4);
        return new ValueLob(n2, dataHandler, string, n3, n4, true, l2, bl2);
    }

    public static ValueLob openUnlinked(int n2, DataHandler dataHandler, int n3, int n4, long l2, boolean bl2, String string) {
        return new ValueLob(n2, dataHandler, string, n3, n4, false, l2, bl2);
    }

    private static ValueLob createClob(Reader reader, long l2, DataHandler dataHandler) {
        try {
            char[] cArray;
            Object object;
            int n2;
            if (dataHandler == null) {
                String string = IOUtils.readStringAndClose(reader, (int)l2);
                return ValueLob.createSmallLob(16, string.getBytes(Constants.UTF8));
            }
            boolean bl2 = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l3 = Long.MAX_VALUE;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLob.getBufferSize(dataHandler, bl2, l3)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(reader, -1);
                cArray = ((String)object).toCharArray();
                n2 = cArray.length;
            } else {
                cArray = new char[n2];
                n2 = IOUtils.readFully(reader, cArray, n2);
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                object = new String(cArray, 0, n2).getBytes(Constants.UTF8);
                return ValueLob.createSmallLob(16, (byte[])object);
            }
            object = new ValueLob(16, null);
            super.createFromReader(cArray, n2, reader, l3, dataHandler);
            return object;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl2, long l2) {
        long l3;
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        int n2 = dataHandler.getMaxLengthInplaceLob();
        long l4 = l3 = bl2 ? 131072L : 4096L;
        if (l3 < l2 && l3 <= (long)n2) {
            l3 = Math.min(l2, (long)n2 + 1L);
            l3 = MathUtils.roundUpLong(l3, 4096L);
        }
        l3 = Math.min(l2, l3);
        if ((l3 = (long)MathUtils.convertLongToInt(l3)) < 0L) {
            l3 = Integer.MAX_VALUE;
        }
        return (int)l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromReader(char[] cArray, int n2, Reader reader, long l2, DataHandler dataHandler) throws IOException {
        FileStoreOutputStream fileStoreOutputStream = this.initLarge(dataHandler);
        boolean bl2 = dataHandler.getLobCompressionAlgorithm(16) != null;
        try {
            do {
                this.precision += (long)n2;
                byte[] byArray = new String(cArray, 0, n2).getBytes(Constants.UTF8);
                fileStoreOutputStream.write(byArray, 0, byArray.length);
                if ((l2 -= (long)n2) <= 0L) {
                    break;
                }
                n2 = ValueLob.getBufferSize(dataHandler, bl2, l2);
            } while ((n2 = IOUtils.readFully(reader, cArray, n2)) != 0);
        }
        finally {
            fileStoreOutputStream.close();
        }
    }

    private static String getFileNamePrefix(String string, int n2) {
        int n3 = n2 % SysProperties.LOB_FILES_PER_DIRECTORY;
        String string2 = n3 > 0 ? SysProperties.FILE_SEPARATOR + n2 : "";
        n2 /= SysProperties.LOB_FILES_PER_DIRECTORY;
        while (n2 > 0) {
            n3 = n2 % SysProperties.LOB_FILES_PER_DIRECTORY;
            string2 = SysProperties.FILE_SEPARATOR + n3 + ".lobs.db" + string2;
            n2 /= SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        string2 = FileUtils.toRealPath(string + ".lobs.db" + string2);
        return string2;
    }

    private static int getNewObjectId(DataHandler dataHandler) {
        int n2;
        String string;
        String string2 = dataHandler.getDatabasePath();
        if (string2 != null && string2.length() == 0) {
            string2 = new File(Utils.getProperty("java.io.tmpdir", "."), SysProperties.PREFIX_TEMP_FILE).getAbsolutePath();
        }
        int n3 = 0;
        int n4 = SysProperties.LOB_FILES_PER_DIRECTORY;
        while (true) {
            string = ValueLob.getFileNamePrefix(string2, n3);
            String[] stringArray = ValueLob.getFileList(dataHandler, string);
            int n5 = 0;
            boolean[] blArray = new boolean[n4];
            String[] stringArray2 = stringArray;
            int n6 = stringArray2.length;
            for (int i2 = 0; i2 < n6; ++i2) {
                int n7;
                String string3 = stringArray2[i2];
                if (!string3.endsWith(".db")) continue;
                string3 = FileUtils.getName(string3);
                String string4 = string3.substring(0, string3.indexOf(46));
                try {
                    n7 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n7 = -1;
                }
                if (n7 <= 0) continue;
                ++n5;
                blArray[n7 % n4] = true;
            }
            n2 = -1;
            if (n5 < n4) {
                for (n6 = 1; n6 < n4; ++n6) {
                    if (blArray[n6]) continue;
                    n2 = n6;
                    break;
                }
            }
            if (n2 > 0) break;
            if (n3 > Integer.MAX_VALUE / n4) {
                n3 = 0;
                dirCounter = MathUtils.randomInt(n4 - 1) * n4;
                continue;
            }
            n6 = dirCounter++ / (n4 - 1) + 1;
            n3 *= n4;
            n3 += n6 * n4;
        }
        ValueLob.invalidateFileList(dataHandler, string);
        return n3 += n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateFileList(DataHandler dataHandler, String string) {
        SmallLRUCache<String, String[]> smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache != null) {
            SmallLRUCache<String, String[]> smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                smallLRUCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getFileList(DataHandler dataHandler, String string) {
        String[] stringArray;
        SmallLRUCache<String, String[]> smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache == null) {
            stringArray = FileUtils.newDirectoryStream(string).toArray(new String[0]);
        } else {
            SmallLRUCache<String, String[]> smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                stringArray = (String[])smallLRUCache.get(string);
                if (stringArray == null) {
                    stringArray = FileUtils.newDirectoryStream(string).toArray(new String[0]);
                    smallLRUCache.put(string, stringArray);
                }
            }
        }
        return stringArray;
    }

    private static ValueLob createBlob(InputStream inputStream, long l2, DataHandler dataHandler) {
        try {
            byte[] byArray;
            int n2;
            boolean bl2;
            if (dataHandler == null) {
                byte[] byArray2 = IOUtils.readBytesAndClose(inputStream, (int)l2);
                return ValueLob.createSmallLob(15, byArray2);
            }
            long l3 = Long.MAX_VALUE;
            boolean bl3 = bl2 = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l2 >= 0L && l2 < l3) {
                l3 = l2;
            }
            if ((n2 = ValueLob.getBufferSize(dataHandler, bl2, l3)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n2 = byArray.length;
            } else {
                byArray = DataUtils.newBytes(n2);
                n2 = IOUtils.readFully(inputStream, byArray, n2);
            }
            if (n2 <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray3 = DataUtils.newBytes(n2);
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                return ValueLob.createSmallLob(15, byArray3);
            }
            ValueLob valueLob = new ValueLob(15, null);
            valueLob.createFromStream(byArray, n2, inputStream, l3, dataHandler);
            return valueLob;
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreOutputStream initLarge(DataHandler dataHandler) {
        this.handler = dataHandler;
        this.tableId = 0;
        this.linked = false;
        this.precision = 0L;
        this.small = null;
        this.hash = 0;
        String string = dataHandler.getLobCompressionAlgorithm(this.type);
        this.compressed = string != null;
        Object object = dataHandler;
        synchronized (object) {
            String string2 = dataHandler.getDatabasePath();
            if (string2 != null && string2.length() == 0) {
                string2 = new File(Utils.getProperty("java.io.tmpdir", "."), SysProperties.PREFIX_TEMP_FILE).getAbsolutePath();
            }
            this.objectId = ValueLob.getNewObjectId(dataHandler);
            this.fileName = ValueLob.getFileNamePrefix(string2, this.objectId) + ".temp.db";
            this.tempFile = dataHandler.openFile(this.fileName, "rw", false);
            this.tempFile.autoDelete();
        }
        object = new FileStoreOutputStream(this.tempFile, dataHandler, string);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromStream(byte[] byArray, int n2, InputStream inputStream, long l2, DataHandler dataHandler) throws IOException {
        FileStoreOutputStream fileStoreOutputStream = this.initLarge(dataHandler);
        boolean bl2 = dataHandler.getLobCompressionAlgorithm(15) != null;
        try {
            do {
                this.precision += (long)n2;
                fileStoreOutputStream.write(byArray, 0, n2);
                if ((l2 -= (long)n2) <= 0L) {
                    break;
                }
                n2 = ValueLob.getBufferSize(dataHandler, bl2, l2);
            } while ((n2 = IOUtils.readFully(inputStream, byArray, n2)) > 0);
        }
        finally {
            fileStoreOutputStream.close();
        }
    }

    @Override
    public Value convertTo(int n2) {
        if (n2 == this.type) {
            return this;
        }
        if (n2 == 16) {
            ValueLob valueLob = ValueLob.createClob(this.getReader(), -1L, this.handler);
            return valueLob;
        }
        if (n2 == 15) {
            ValueLob valueLob = ValueLob.createBlob(this.getInputStream(), -1L, this.handler);
            return valueLob;
        }
        return super.convertTo(n2);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.linked;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void remove() {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
                this.tempFile = null;
            }
            ValueLob.deleteFile(this.handler, this.fileName);
        }
    }

    @Override
    public Value copy(DataHandler dataHandler, int n2) {
        if (this.fileName == null) {
            this.tableId = n2;
            return this;
        }
        if (this.linked) {
            ValueLob valueLob = ValueLob.copy(this);
            valueLob.objectId = ValueLob.getNewObjectId(dataHandler);
            valueLob.tableId = n2;
            String string = ValueLob.getFileName(dataHandler, valueLob.tableId, valueLob.objectId);
            ValueLob.copyFileTo(dataHandler, this.fileName, string);
            valueLob.fileName = string;
            valueLob.linked = true;
            return valueLob;
        }
        if (!this.linked) {
            this.tableId = n2;
            String string = ValueLob.getFileName(dataHandler, this.tableId, this.objectId);
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
                this.tempFile = null;
            }
            ValueLob.renameFile(dataHandler, this.fileName, string);
            this.fileName = string;
            this.linked = true;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getPrecision() {
        return this.precision;
    }

    @Override
    public String getString() {
        int n2 = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return new String(this.small, Constants.UTF8);
                }
                return IOUtils.readStringAndClose(this.getReader(), n2);
            }
            byte[] byArray = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), n2);
            return StringUtils.convertBytesToHex(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.fileName);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.fileName);
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.type == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        if (this.type == 16) {
            return Integer.signum(this.getString().compareTo(value.getString()));
        }
        byte[] byArray = value.getBytesNoCopy();
        return Utils.compareNotNullSigned(this.getBytes(), byArray);
    }

    @Override
    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public InputStream getInputStream() {
        if (this.fileName == null) {
            return new ByteArrayInputStream(this.small);
        }
        FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
        boolean bl2 = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, this.compressed, bl2), 4096);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        long l2 = this.getPrecision();
        if (l2 > Integer.MAX_VALUE || l2 <= 0L) {
            l2 = -1L;
        }
        if (this.type == 15) {
            preparedStatement.setBinaryStream(n2, this.getInputStream(), (int)l2);
        } else {
            preparedStatement.setCharacterStream(n2, this.getReader(), (int)l2);
        }
    }

    @Override
    public String getSQL() {
        if (this.type == 16) {
            String string = this.getString();
            return StringUtils.quoteStringSQL(string);
        }
        byte[] byArray = this.getBytes();
        String string = StringUtils.convertBytesToHex(byArray);
        return "X'" + string + "'";
    }

    @Override
    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* ").append(this.fileName).append(" */)");
        return stringBuilder.toString();
    }

    @Override
    public byte[] getSmall() {
        return this.small;
    }

    @Override
    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueLob && this.compareSecure((Value)object, null) == 0;
    }

    public void convertToFileIfRequired(DataHandler dataHandler) {
        try {
            if (this.small != null && this.small.length > dataHandler.getMaxLengthInplaceLob()) {
                boolean bl2 = dataHandler.getLobCompressionAlgorithm(this.type) != null;
                int n2 = ValueLob.getBufferSize(dataHandler, bl2, Long.MAX_VALUE);
                int n3 = this.tableId;
                if (this.type == 15) {
                    this.createFromStream(DataUtils.newBytes(n2), 0, this.getInputStream(), Long.MAX_VALUE, dataHandler);
                } else {
                    this.createFromReader(new char[n2], 0, this.getReader(), Long.MAX_VALUE, dataHandler);
                }
                Value value = this.copy(dataHandler, n3);
                if (SysProperties.CHECK && value != this) {
                    DbException.throwInternalError();
                }
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler dataHandler, String string) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileUtils.delete(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileUtils.move(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileTo(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            try {
                IOUtils.copyFiles(string, string2);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
    }

    @Override
    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 104;
        }
        return 140;
    }

    @Override
    public ValueLob copyToTemp() {
        ValueLob valueLob = this.type == 16 ? ValueLob.createClob(this.getReader(), this.precision, this.handler) : ValueLob.createBlob(this.getInputStream(), this.precision, this.handler);
        return valueLob;
    }

    @Override
    public Value convertPrecision(long l2, boolean bl2) {
        if (this.precision <= l2) {
            return this;
        }
        ValueLob valueLob = this.type == 16 ? ValueLob.createClob(this.getReader(), l2, this.handler) : ValueLob.createBlob(this.getInputStream(), l2, this.handler);
        return valueLob;
    }
}

