/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.engine.SysProperties;
import org.h2.store.DataHandler;
import org.h2.util.JdbcUtils;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBytes;

public class ValueJavaObject
extends ValueBytes {
    private static final ValueJavaObject EMPTY = new ValueJavaObject(Utils.EMPTY_BYTES, null);
    private final DataHandler dataHandler;

    protected ValueJavaObject(byte[] byArray, DataHandler dataHandler) {
        super(byArray);
        this.dataHandler = dataHandler;
    }

    public static ValueJavaObject getNoCopy(Object object, byte[] byArray, DataHandler dataHandler) {
        ValueJavaObject valueJavaObject;
        if (byArray != null && byArray.length == 0) {
            return EMPTY;
        }
        if (SysProperties.serializeJavaObject) {
            if (byArray == null) {
                byArray = JdbcUtils.serialize(object, dataHandler);
            }
            valueJavaObject = new ValueJavaObject(byArray, dataHandler);
        } else {
            valueJavaObject = new NotSerialized(object, byArray, dataHandler);
        }
        if (byArray == null || byArray.length > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueJavaObject;
        }
        return (ValueJavaObject)Value.cache(valueJavaObject);
    }

    @Override
    public int getType() {
        return 19;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        Object object = JdbcUtils.deserialize(this.getBytesNoCopy(), this.getDataHandler());
        preparedStatement.setObject(n2, object, 2000);
    }

    @Override
    protected DataHandler getDataHandler() {
        return this.dataHandler;
    }

    private static class NotSerialized
    extends ValueJavaObject {
        private Object javaObject;
        private int displaySize = -1;

        NotSerialized(Object object, byte[] byArray, DataHandler dataHandler) {
            super(byArray, dataHandler);
            this.javaObject = object;
        }

        @Override
        public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
            preparedStatement.setObject(n2, this.getObject(), 2000);
        }

        @Override
        public byte[] getBytesNoCopy() {
            if (this.value == null) {
                this.value = JdbcUtils.serialize(this.javaObject, null);
            }
            return this.value;
        }

        @Override
        protected int compareSecure(Value value, CompareMode compareMode) {
            int n2;
            Object object = this.getObject();
            Object object2 = value.getObject();
            boolean bl2 = object instanceof Comparable;
            boolean bl3 = object2 instanceof Comparable;
            if (bl2 && bl3 && Utils.haveCommonComparableSuperclass(object.getClass(), object2.getClass())) {
                Comparable comparable = (Comparable)object;
                return comparable.compareTo(object2);
            }
            if (object.getClass() != object2.getClass()) {
                if (bl2 != bl3) {
                    return bl2 ? -1 : 1;
                }
                return object.getClass().getName().compareTo(object2.getClass().getName());
            }
            int n3 = this.hashCode();
            if (n3 == (n2 = value.hashCode())) {
                if (object.equals(object2)) {
                    return 0;
                }
                return Utils.compareNotNullSigned(this.getBytesNoCopy(), value.getBytesNoCopy());
            }
            return n3 > n2 ? 1 : -1;
        }

        @Override
        public String getString() {
            String string = this.getObject().toString();
            if (this.displaySize == -1) {
                this.displaySize = string.length();
            }
            return string;
        }

        @Override
        public long getPrecision() {
            return 0L;
        }

        @Override
        public int hashCode() {
            if (this.hash == 0) {
                this.hash = this.getObject().hashCode();
            }
            return this.hash;
        }

        @Override
        public Object getObject() {
            if (this.javaObject == null) {
                this.javaObject = JdbcUtils.deserialize(this.value, this.getDataHandler());
            }
            return this.javaObject;
        }

        @Override
        public int getDisplaySize() {
            if (this.displaySize == -1) {
                this.displaySize = this.getString().length();
            }
            return this.displaySize;
        }

        @Override
        public int getMemory() {
            if (this.value == null) {
                return DataType.getDataType((int)this.getType()).memory;
            }
            int n2 = super.getMemory();
            if (this.javaObject != null) {
                n2 *= 2;
            }
            return n2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof NotSerialized)) {
                return false;
            }
            return this.getObject().equals(((NotSerialized)object).getObject());
        }

        @Override
        public Value convertPrecision(long l2, boolean bl2) {
            return this;
        }
    }
}

