/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 128;
    private static final int DYNAMIC_SIZE = 256;
    private static final ValueInt[] STATIC_CACHE = new ValueInt[128];
    private static final ValueInt[] DYNAMIC_CACHE = new ValueInt[256];
    private final int value;

    private ValueInt(int n2) {
        this.value = n2;
    }

    public static ValueInt get(int n2) {
        if (n2 >= 0 && n2 < 128) {
            return STATIC_CACHE[n2];
        }
        ValueInt valueInt = DYNAMIC_CACHE[n2 & 0xFF];
        if (valueInt == null || valueInt.value != n2) {
            ValueInt.DYNAMIC_CACHE[n2 & 0xFF] = valueInt = new ValueInt(n2);
        }
        return valueInt;
    }

    @Override
    public Value add(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return ValueInt.checkRange((long)this.value + (long)valueInt.value);
    }

    private static ValueInt checkRange(long l2) {
        if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
            throw DbException.get(22003, Long.toString(l2));
        }
        return ValueInt.get((int)l2);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueInt.checkRange(-((long)this.value));
    }

    @Override
    public Value subtract(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return ValueInt.checkRange((long)this.value - (long)valueInt.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueInt valueInt = (ValueInt)value;
        return ValueInt.checkRange((long)this.value * (long)valueInt.value);
    }

    @Override
    public Value divide(Value value) {
        ValueInt valueInt = (ValueInt)value;
        if (valueInt.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value / valueInt.value);
    }

    @Override
    public Value modulus(Value value) {
        ValueInt valueInt = (ValueInt)value;
        if (valueInt.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value % valueInt.value);
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueInt valueInt = (ValueInt)value;
        return MathUtils.compareInt(this.value, valueInt.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 10L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setInt(n2, this.value);
    }

    @Override
    public int getDisplaySize() {
        return 11;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueInt && this.value == ((ValueInt)object).value;
    }

    static {
        for (int i2 = 0; i2 < 128; ++i2) {
            ValueInt.STATIC_CACHE[i2] = new ValueInt(i2);
        }
    }
}

