/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueByte
extends Value {
    static final int PRECISION = 3;
    static final int DISPLAY_SIZE = 4;
    private final byte value;

    private ValueByte(byte by2) {
        this.value = by2;
    }

    @Override
    public Value add(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return ValueByte.checkRange(this.value + valueByte.value);
    }

    private static ValueByte checkRange(int n2) {
        if (n2 < -128 || n2 > 127) {
            throw DbException.get(22003, Integer.toString(n2));
        }
        return ValueByte.get((byte)n2);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueByte.checkRange(-this.value);
    }

    @Override
    public Value subtract(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return ValueByte.checkRange(this.value - valueByte.value);
    }

    @Override
    public Value multiply(Value value) {
        ValueByte valueByte = (ValueByte)value;
        return ValueByte.checkRange(this.value * valueByte.value);
    }

    @Override
    public Value divide(Value value) {
        ValueByte valueByte = (ValueByte)value;
        if (valueByte.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value / valueByte.value));
    }

    @Override
    public Value modulus(Value value) {
        ValueByte valueByte = (ValueByte)value;
        if (valueByte.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueByte.get((byte)(this.value % valueByte.value));
    }

    @Override
    public String getSQL() {
        return this.getString();
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public byte getByte() {
        return this.value;
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueByte valueByte = (ValueByte)value;
        return MathUtils.compareInt(this.value, valueByte.value);
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public long getPrecision() {
        return 3L;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) throws SQLException {
        preparedStatement.setByte(n2, this.value);
    }

    public static ValueByte get(byte by2) {
        return (ValueByte)Value.cache(new ValueByte(by2));
    }

    @Override
    public int getDisplaySize() {
        return 4;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueByte && this.value == ((ValueByte)object).value;
    }
}

