/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import org.h2.util.MathUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueArray
extends Value {
    private final Class<?> componentType;
    private final Value[] values;
    private int hash;

    private ValueArray(Class<?> clazz, Value[] valueArray) {
        this.componentType = clazz;
        this.values = valueArray;
    }

    private ValueArray(Value[] valueArray) {
        this(Object.class, valueArray);
    }

    public static ValueArray get(Value[] valueArray) {
        return new ValueArray(valueArray);
    }

    public static ValueArray get(Class<?> clazz, Value[] valueArray) {
        return new ValueArray(clazz, valueArray);
    }

    @Override
    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int n2 = 1;
        for (Value value : this.values) {
            n2 = n2 * 31 + value.hashCode();
        }
        this.hash = n2;
        return n2;
    }

    public Value[] getList() {
        return this.values;
    }

    @Override
    public int getType() {
        return 17;
    }

    public Class<?> getComponentType() {
        return this.componentType;
    }

    @Override
    public long getPrecision() {
        long l2 = 0L;
        for (Value value : this.values) {
            l2 += value.getPrecision();
        }
        return l2;
    }

    @Override
    public String getString() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getString());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueArray valueArray = (ValueArray)value;
        if (this.values == valueArray.values) {
            return 0;
        }
        int n2 = this.values.length;
        int n3 = valueArray.values.length;
        int n4 = Math.min(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            Value value2 = this.values[i2];
            Value value3 = valueArray.values[i2];
            int n5 = value2.compareTo(value3, compareMode);
            if (n5 == 0) continue;
            return n5;
        }
        return n2 > n3 ? 1 : (n2 == n3 ? 0 : -1);
    }

    @Override
    public Object getObject() {
        int n2 = this.values.length;
        Object[] objectArray = (Object[])Array.newInstance(this.componentType, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.values[i2].getObject();
        }
        return objectArray;
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n2) {
        throw this.throwUnsupportedExceptionForType("PreparedStatement.set");
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value.getSQL());
        }
        if (this.values.length == 1) {
            statementBuilder.append(',');
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public String getTraceSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        for (Value value : this.values) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(value == null ? "null" : value.getTraceSQL());
        }
        return statementBuilder.append(')').toString();
    }

    @Override
    public int getDisplaySize() {
        long l2 = 0L;
        for (Value value : this.values) {
            l2 += (long)value.getDisplaySize();
        }
        return MathUtils.convertLongToInt(l2);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ValueArray)) {
            return false;
        }
        ValueArray valueArray = (ValueArray)object;
        if (this.values == valueArray.values) {
            return true;
        }
        int n2 = this.values.length;
        if (n2 != valueArray.values.length) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.values[i2].equals(valueArray.values[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getMemory() {
        int n2 = 32;
        for (Value value : this.values) {
            n2 += value.getMemory() + 8;
        }
        return n2;
    }

    @Override
    public Value convertPrecision(long l2, boolean bl2) {
        if (!bl2) {
            return this;
        }
        ArrayList<Value> arrayList = New.arrayList();
        for (Value value : this.values) {
            if ((l2 -= Math.max(1L, (value = value.convertPrecision(l2, true)).getPrecision())) < 0L) break;
            arrayList.add(value);
        }
        Value[] valueArray = new Value[arrayList.size()];
        arrayList.toArray(valueArray);
        return ValueArray.get(valueArray);
    }
}

