/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.security.SHA256;
import org.h2.store.Data;
import org.h2.store.DataReader;
import org.h2.tools.SimpleResultSet;
import org.h2.util.DateTimeUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.MathUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTimestampUtc;
import org.h2.value.ValueUuid;

public class Transfer {
    private static final int BUFFER_SIZE = 65536;
    private static final int LOB_MAGIC = 4660;
    private static final int LOB_MAC_SALT_LENGTH = 16;
    private Socket socket;
    private DataInputStream in;
    private DataOutputStream out;
    private SessionInterface session;
    private boolean ssl;
    private int version;
    private byte[] lobMacSalt;

    public Transfer(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized void init() throws IOException {
        if (this.socket != null) {
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 65536));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 65536));
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public Transfer writeBoolean(boolean bl2) throws IOException {
        this.out.writeByte((byte)(bl2 ? (char)'\u0001' : '\u0000'));
        return this;
    }

    public boolean readBoolean() throws IOException {
        return this.in.readByte() == 1;
    }

    private Transfer writeByte(byte by2) throws IOException {
        this.out.writeByte(by2);
        return this;
    }

    private byte readByte() throws IOException {
        return this.in.readByte();
    }

    public Transfer writeInt(int n2) throws IOException {
        this.out.writeInt(n2);
        return this;
    }

    public int readInt() throws IOException {
        return this.in.readInt();
    }

    public Transfer writeLong(long l2) throws IOException {
        this.out.writeLong(l2);
        return this;
    }

    public long readLong() throws IOException {
        return this.in.readLong();
    }

    private Transfer writeDouble(double d2) throws IOException {
        this.out.writeDouble(d2);
        return this;
    }

    private Transfer writeFloat(float f2) throws IOException {
        this.out.writeFloat(f2);
        return this;
    }

    private double readDouble() throws IOException {
        return this.in.readDouble();
    }

    private float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public Transfer writeString(String string) throws IOException {
        if (string == null) {
            this.out.writeInt(-1);
        } else {
            int n2 = string.length();
            this.out.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.out.writeChar(string.charAt(i2));
            }
        }
        return this;
    }

    public String readString() throws IOException {
        int n2 = this.in.readInt();
        if (n2 == -1) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.in.readChar());
        }
        String string = stringBuilder.toString();
        string = StringUtils.cache(string);
        return string;
    }

    public Transfer writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(byArray.length);
            this.out.write(byArray);
        }
        return this;
    }

    public Transfer writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        return this;
    }

    public byte[] readBytes() throws IOException {
        int n2 = this.readInt();
        if (n2 == -1) {
            return null;
        }
        byte[] byArray = DataUtils.newBytes(n2);
        this.in.readFully(byArray);
        return byArray;
    }

    public void readBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.in.readFully(byArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.socket != null) {
            try {
                if (this.out != null) {
                    this.out.flush();
                }
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
                DbException.traceThrowable(iOException);
            }
            finally {
                this.socket = null;
            }
        }
    }

    public void writeValue(Value value) throws IOException {
        int n2 = value.getType();
        this.writeInt(n2);
        switch (n2) {
            case 0: {
                break;
            }
            case 12: 
            case 19: {
                this.writeBytes(value.getBytesNoCopy());
                break;
            }
            case 20: {
                ValueUuid valueUuid = (ValueUuid)value;
                this.writeLong(valueUuid.getHigh());
                this.writeLong(valueUuid.getLow());
                break;
            }
            case 1: {
                this.writeBoolean(value.getBoolean());
                break;
            }
            case 2: {
                this.writeByte(value.getByte());
                break;
            }
            case 9: {
                if (this.version >= 9) {
                    this.writeLong(((ValueTime)value).getNanos());
                    break;
                }
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(value.getTime()));
                    break;
                }
                this.writeLong(value.getTime().getTime());
                break;
            }
            case 10: {
                if (this.version >= 9) {
                    this.writeLong(((ValueDate)value).getDateValue());
                    break;
                }
                if (this.version >= 7) {
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(value.getDate()));
                    break;
                }
                this.writeLong(value.getDate().getTime());
                break;
            }
            case 11: {
                if (this.version >= 9) {
                    ValueTimestamp valueTimestamp = (ValueTimestamp)value;
                    this.writeLong(valueTimestamp.getDateValue());
                    this.writeLong(valueTimestamp.getTimeNanos());
                    break;
                }
                if (this.version >= 7) {
                    Timestamp timestamp = value.getTimestamp();
                    this.writeLong(DateTimeUtils.getTimeLocalWithoutDst(timestamp));
                    this.writeInt(timestamp.getNanos() % 1000000);
                    break;
                }
                Timestamp timestamp = value.getTimestamp();
                this.writeLong(timestamp.getTime());
                this.writeInt(timestamp.getNanos() % 1000000);
                break;
            }
            case 23: {
                ValueTimestampUtc valueTimestampUtc = (ValueTimestampUtc)value;
                this.writeLong(valueTimestampUtc.getUtcDateTimeNanos());
                break;
            }
            case 24: {
                ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
                this.writeLong(valueTimestampTimeZone.getDateValue());
                this.writeLong(valueTimestampTimeZone.getTimeNanos());
                this.writeInt(valueTimestampTimeZone.getTimeZoneOffsetMins());
                break;
            }
            case 6: {
                this.writeString(value.getString());
                break;
            }
            case 7: {
                this.writeDouble(value.getDouble());
                break;
            }
            case 8: {
                this.writeFloat(value.getFloat());
                break;
            }
            case 4: {
                this.writeInt(value.getInt());
                break;
            }
            case 5: {
                this.writeLong(value.getLong());
                break;
            }
            case 3: {
                this.writeInt(value.getShort());
                break;
            }
            case 13: 
            case 14: 
            case 21: {
                this.writeString(value.getString());
                break;
            }
            case 15: {
                ValueLobDb valueLobDb;
                if (this.version >= 11 && value instanceof ValueLobDb && (valueLobDb = (ValueLobDb)value).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(valueLobDb.getTableId());
                    this.writeLong(valueLobDb.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(valueLobDb.getLobId()));
                    }
                    this.writeLong(valueLobDb.getPrecision());
                    break;
                }
                long l2 = value.getPrecision();
                if (l2 < 0L) {
                    throw DbException.get(90067, "length=" + l2);
                }
                this.writeLong(l2);
                long l3 = IOUtils.copyAndCloseInput(value.getInputStream(), this.out);
                if (l3 != l2) {
                    throw DbException.get(90067, "length:" + l2 + " written:" + l3);
                }
                this.writeInt(4660);
                break;
            }
            case 16: {
                ValueLobDb valueLobDb;
                if (this.version >= 11 && value instanceof ValueLobDb && (valueLobDb = (ValueLobDb)value).isStored()) {
                    this.writeLong(-1L);
                    this.writeInt(valueLobDb.getTableId());
                    this.writeLong(valueLobDb.getLobId());
                    if (this.version >= 12) {
                        this.writeBytes(this.calculateLobMac(valueLobDb.getLobId()));
                    }
                    this.writeLong(valueLobDb.getPrecision());
                    break;
                }
                long l4 = value.getPrecision();
                if (l4 < 0L) {
                    throw DbException.get(90067, "length=" + l4);
                }
                if (l4 > Integer.MAX_VALUE) {
                    throw DbException.get(90067, "length=" + l4);
                }
                this.writeLong(l4);
                Reader reader = value.getReader();
                Data.copyString(reader, this.out);
                this.writeInt(4660);
                break;
            }
            case 17: {
                ValueArray valueArray = (ValueArray)value;
                Value[] valueArray2 = valueArray.getList();
                int n3 = valueArray2.length;
                Class<?> clazz = valueArray.getComponentType();
                if (clazz == Object.class) {
                    this.writeInt(n3);
                } else {
                    this.writeInt(-(n3 + 1));
                    this.writeString(clazz.getName());
                }
                for (Value value2 : valueArray2) {
                    this.writeValue(value2);
                }
                break;
            }
            case 18: {
                try {
                    int n4;
                    ResultSet resultSet = ((ValueResultSet)value).getResultSet();
                    resultSet.beforeFirst();
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n5 = resultSetMetaData.getColumnCount();
                    this.writeInt(n5);
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.writeString(resultSetMetaData.getColumnName(n4 + 1));
                        this.writeInt(resultSetMetaData.getColumnType(n4 + 1));
                        this.writeInt(resultSetMetaData.getPrecision(n4 + 1));
                        this.writeInt(resultSetMetaData.getScale(n4 + 1));
                    }
                    while (resultSet.next()) {
                        this.writeBoolean(true);
                        for (n4 = 0; n4 < n5; ++n4) {
                            int n6 = DataType.getValueTypeFromResultSet(resultSetMetaData, n4 + 1);
                            Value value3 = DataType.readValue(this.session, resultSet, n4 + 1, n6);
                            this.writeValue(value3);
                        }
                    }
                    this.writeBoolean(false);
                    resultSet.beforeFirst();
                    break;
                }
                catch (SQLException sQLException) {
                    throw DbException.convertToIOException(sQLException);
                }
            }
            case 22: {
                if (this.version >= 14) {
                    this.writeBytes(value.getBytesNoCopy());
                    break;
                }
                this.writeString(value.getString());
                break;
            }
            default: {
                throw DbException.get(90067, "type=" + n2);
            }
        }
    }

    public Value readValue() throws IOException {
        int n2 = this.readInt();
        switch (n2) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 12: {
                return ValueBytes.getNoCopy(this.readBytes());
            }
            case 20: {
                return ValueUuid.get(this.readLong(), this.readLong());
            }
            case 19: {
                return ValueJavaObject.getNoCopy(null, this.readBytes(), this.session.getDataHandler());
            }
            case 1: {
                return ValueBoolean.get(this.readBoolean());
            }
            case 2: {
                return ValueByte.get(this.readByte());
            }
            case 10: {
                if (this.version >= 9) {
                    return ValueDate.fromDateValue(this.readLong());
                }
                if (this.version >= 7) {
                    return ValueDate.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()));
                }
                return ValueDate.fromMillis(this.readLong());
            }
            case 9: {
                if (this.version >= 9) {
                    return ValueTime.fromNanos(this.readLong());
                }
                if (this.version >= 7) {
                    return ValueTime.fromMillis(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()));
                }
                return ValueTime.fromMillis(this.readLong());
            }
            case 11: {
                if (this.version >= 9) {
                    return ValueTimestamp.fromDateValueAndNanos(this.readLong(), this.readLong());
                }
                if (this.version >= 7) {
                    return ValueTimestamp.fromMillisNanos(DateTimeUtils.getTimeUTCWithoutDst(this.readLong()), this.readInt() % 1000000);
                }
                return ValueTimestamp.fromMillisNanos(this.readLong(), this.readInt() % 1000000);
            }
            case 23: {
                return ValueTimestampUtc.fromNanos(this.readLong());
            }
            case 24: {
                return ValueTimestampTimeZone.fromDateValueAndNanos(this.readLong(), this.readLong(), (short)this.readInt());
            }
            case 6: {
                return ValueDecimal.get(new BigDecimal(this.readString()));
            }
            case 7: {
                return ValueDouble.get(this.readDouble());
            }
            case 8: {
                return ValueFloat.get(this.readFloat());
            }
            case 4: {
                return ValueInt.get(this.readInt());
            }
            case 5: {
                return ValueLong.get(this.readLong());
            }
            case 3: {
                return ValueShort.get((short)this.readInt());
            }
            case 13: {
                return ValueString.get(this.readString());
            }
            case 14: {
                return ValueStringIgnoreCase.get(this.readString());
            }
            case 21: {
                return ValueStringFixed.get(this.readString());
            }
            case 15: {
                long l2 = this.readLong();
                if (this.version >= 11 && l2 == -1L) {
                    int n3 = this.readInt();
                    long l3 = this.readLong();
                    byte[] byArray = this.version >= 12 ? this.readBytes() : null;
                    long l4 = this.readLong();
                    return ValueLobDb.create(15, this.session.getDataHandler(), n3, l3, byArray, l4);
                }
                Value value = this.session.getDataHandler().getLobStorage().createBlob(this.in, l2);
                int n4 = this.readInt();
                if (n4 != 4660) {
                    throw DbException.get(90067, "magic=" + n4);
                }
                return value;
            }
            case 16: {
                long l5 = this.readLong();
                if (this.version >= 11) {
                    if (l5 == -1L) {
                        int n5 = this.readInt();
                        long l6 = this.readLong();
                        byte[] byArray = this.version >= 12 ? this.readBytes() : null;
                        long l7 = this.readLong();
                        return ValueLobDb.create(16, this.session.getDataHandler(), n5, l6, byArray, l7);
                    }
                    if (l5 < 0L || l5 > Integer.MAX_VALUE) {
                        throw DbException.get(90067, "length=" + l5);
                    }
                    DataReader dataReader = new DataReader(this.in);
                    int n6 = (int)l5;
                    char[] cArray = new char[n6];
                    IOUtils.readFully(dataReader, cArray, n6);
                    int n7 = this.readInt();
                    if (n7 != 4660) {
                        throw DbException.get(90067, "magic=" + n7);
                    }
                    byte[] byArray = new String(cArray).getBytes(Constants.UTF8);
                    return ValueLobDb.createSmallLob(16, byArray, l5);
                }
                Value value = this.session.getDataHandler().getLobStorage().createClob(new DataReader(this.in), l5);
                int n8 = this.readInt();
                if (n8 != 4660) {
                    throw DbException.get(90067, "magic=" + n8);
                }
                return value;
            }
            case 17: {
                int n9 = this.readInt();
                Class clazz = Object.class;
                if (n9 < 0) {
                    n9 = -(n9 + 1);
                    clazz = JdbcUtils.loadUserClass(this.readString());
                }
                Value[] valueArray = new Value[n9];
                for (int i2 = 0; i2 < n9; ++i2) {
                    valueArray[i2] = this.readValue();
                }
                return ValueArray.get(clazz, valueArray);
            }
            case 18: {
                SimpleResultSet simpleResultSet = new SimpleResultSet();
                simpleResultSet.setAutoClose(false);
                int n10 = this.readInt();
                for (int i3 = 0; i3 < n10; ++i3) {
                    simpleResultSet.addColumn(this.readString(), this.readInt(), this.readInt(), this.readInt());
                }
                while (this.readBoolean()) {
                    Object[] objectArray = new Object[n10];
                    for (int i4 = 0; i4 < n10; ++i4) {
                        objectArray[i4] = this.readValue().getObject();
                    }
                    simpleResultSet.addRow(objectArray);
                }
                return ValueResultSet.get(simpleResultSet);
            }
            case 22: {
                if (this.version >= 14) {
                    return ValueGeometry.get(this.readBytes());
                }
                return ValueGeometry.get(this.readString());
            }
        }
        throw DbException.get(90067, "type=" + n2);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSession(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public void setSSL(boolean bl2) {
        this.ssl = bl2;
    }

    public Transfer openNewConnection() throws IOException {
        InetAddress inetAddress = this.socket.getInetAddress();
        int n2 = this.socket.getPort();
        Socket socket = NetUtils.createSocket(inetAddress, n2, this.ssl);
        Transfer transfer = new Transfer(null);
        transfer.setSocket(socket);
        transfer.setSSL(this.ssl);
        return transfer;
    }

    public void setVersion(int n2) {
        this.version = n2;
    }

    public synchronized boolean isClosed() {
        return this.socket == null || this.socket.isClosed();
    }

    public void verifyLobMac(byte[] byArray, long l2) {
        byte[] byArray2 = this.calculateLobMac(l2);
        if (!Utils.compareSecure(byArray, byArray2)) {
            throw DbException.get(90067, "Invalid lob hmac; possibly the connection was re-opened internally");
        }
    }

    private byte[] calculateLobMac(long l2) {
        if (this.lobMacSalt == null) {
            this.lobMacSalt = MathUtils.secureRandomBytes(16);
        }
        byte[] byArray = new byte[8];
        Utils.writeLong(byArray, 0, l2);
        byte[] byArray2 = SHA256.getHashWithSalt(byArray, this.lobMacSalt);
        return byArray2;
    }
}

