/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.h2.api.TimestampWithTimeZone;
import org.h2.engine.Constants;
import org.h2.engine.SessionInterface;
import org.h2.engine.SysProperties;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.Utils;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLobDb;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueResultSet;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueStringFixed;
import org.h2.value.ValueStringIgnoreCase;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueTimestampUtc;
import org.h2.value.ValueUuid;

public class DataType {
    public static final int TYPE_RESULT_SET = -10;
    public static final Class<?> GEOMETRY_CLASS;
    private static final String GEOMETRY_CLASS_NAME = "com.vividsolutions.jts.geom.Geometry";
    private static final ArrayList<DataType> TYPES;
    private static final HashMap<String, DataType> TYPES_BY_NAME;
    private static final ArrayList<DataType> TYPES_BY_VALUE_TYPE;
    public int type;
    public String name;
    public int sqlType;
    public String jdbc;
    public int sqlTypePos;
    public long maxPrecision;
    public int minScale;
    public int maxScale;
    public boolean decimal;
    public String prefix;
    public String suffix;
    public String params;
    public boolean autoIncrement;
    public boolean caseSensitive;
    public boolean supportsPrecision;
    public boolean supportsScale;
    public long defaultPrecision;
    public int defaultScale;
    public int defaultDisplaySize;
    public boolean hidden;
    public int memory;

    private static void add(int n2, int n3, String string, DataType dataType, String[] stringArray, int n4) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            DataType dataType2 = new DataType();
            dataType2.type = n2;
            dataType2.sqlType = n3;
            dataType2.jdbc = string;
            dataType2.name = stringArray[i2];
            dataType2.autoIncrement = dataType.autoIncrement;
            dataType2.decimal = dataType.decimal;
            dataType2.maxPrecision = dataType.maxPrecision;
            dataType2.maxScale = dataType.maxScale;
            dataType2.minScale = dataType.minScale;
            dataType2.params = dataType.params;
            dataType2.prefix = dataType.prefix;
            dataType2.suffix = dataType.suffix;
            dataType2.supportsPrecision = dataType.supportsPrecision;
            dataType2.supportsScale = dataType.supportsScale;
            dataType2.defaultPrecision = dataType.defaultPrecision;
            dataType2.defaultScale = dataType.defaultScale;
            dataType2.defaultDisplaySize = dataType.defaultDisplaySize;
            dataType2.caseSensitive = dataType.caseSensitive;
            dataType2.hidden = i2 > 0;
            dataType2.memory = n4;
            for (DataType dataType3 : TYPES) {
                if (dataType3.sqlType != dataType2.sqlType) continue;
                ++dataType2.sqlTypePos;
            }
            TYPES_BY_NAME.put(dataType2.name, dataType2);
            if (TYPES_BY_VALUE_TYPE.get(n2) == null) {
                TYPES_BY_VALUE_TYPE.set(n2, dataType2);
            }
            TYPES.add(dataType2);
        }
    }

    private static DataType createDecimal(int n2, int n3, int n4, int n5, boolean bl2, boolean bl3) {
        DataType dataType = new DataType();
        dataType.maxPrecision = n2;
        dataType.defaultPrecision = n3;
        dataType.defaultScale = n4;
        dataType.defaultDisplaySize = n5;
        if (bl2) {
            dataType.params = "PRECISION,SCALE";
            dataType.supportsPrecision = true;
            dataType.supportsScale = true;
        }
        dataType.decimal = true;
        dataType.autoIncrement = bl3;
        return dataType;
    }

    private static DataType createDate(int n2, String string, int n3, int n4) {
        DataType dataType = new DataType();
        dataType.prefix = string + " '";
        dataType.suffix = "'";
        dataType.maxPrecision = n2;
        dataType.supportsScale = n3 != 0;
        dataType.maxScale = n3;
        dataType.defaultPrecision = n2;
        dataType.defaultScale = n3;
        dataType.defaultDisplaySize = n4;
        return dataType;
    }

    private static DataType createString(boolean bl2) {
        DataType dataType = new DataType();
        dataType.prefix = "'";
        dataType.suffix = "'";
        dataType.params = "LENGTH";
        dataType.caseSensitive = bl2;
        dataType.supportsPrecision = true;
        dataType.maxPrecision = Integer.MAX_VALUE;
        dataType.defaultPrecision = Integer.MAX_VALUE;
        dataType.defaultDisplaySize = Integer.MAX_VALUE;
        return dataType;
    }

    private static DataType createLob() {
        DataType dataType = DataType.createString(true);
        dataType.maxPrecision = Long.MAX_VALUE;
        dataType.defaultPrecision = Long.MAX_VALUE;
        return dataType;
    }

    public static ArrayList<DataType> getTypes() {
        return TYPES;
    }

    public static Value readValue(SessionInterface sessionInterface, ResultSet resultSet, int n2, int n3) {
        try {
            Value value;
            switch (n3) {
                case 0: {
                    return ValueNull.INSTANCE;
                }
                case 12: {
                    byte[] byArray = resultSet.getBytes(n2);
                    value = byArray == null ? ValueNull.INSTANCE : ValueBytes.getNoCopy(byArray);
                    break;
                }
                case 20: {
                    byte[] byArray = resultSet.getBytes(n2);
                    value = byArray == null ? ValueNull.INSTANCE : ValueUuid.get(byArray);
                    break;
                }
                case 1: {
                    boolean bl2 = resultSet.getBoolean(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueBoolean.get(bl2);
                    break;
                }
                case 2: {
                    byte by2 = resultSet.getByte(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueByte.get(by2);
                    break;
                }
                case 10: {
                    Date date = resultSet.getDate(n2);
                    value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
                    break;
                }
                case 9: {
                    Time time = resultSet.getTime(n2);
                    value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
                    break;
                }
                case 11: {
                    Timestamp timestamp = resultSet.getTimestamp(n2);
                    value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
                    break;
                }
                case 23: {
                    Timestamp timestamp = resultSet.getTimestamp(n2);
                    value = timestamp == null ? ValueNull.INSTANCE : ValueTimestampUtc.fromMillisNanos(timestamp.getTime(), timestamp.getNanos());
                    break;
                }
                case 24: {
                    TimestampWithTimeZone timestampWithTimeZone = (TimestampWithTimeZone)resultSet.getTimestamp(n2);
                    value = timestampWithTimeZone == null ? ValueNull.INSTANCE : ValueTimestampTimeZone.get(timestampWithTimeZone);
                    break;
                }
                case 6: {
                    BigDecimal bigDecimal = resultSet.getBigDecimal(n2);
                    value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
                    break;
                }
                case 7: {
                    double d2 = resultSet.getDouble(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueDouble.get(d2);
                    break;
                }
                case 8: {
                    float f2 = resultSet.getFloat(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueFloat.get(f2);
                    break;
                }
                case 4: {
                    int n4 = resultSet.getInt(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueInt.get(n4);
                    break;
                }
                case 5: {
                    long l2 = resultSet.getLong(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueLong.get(l2);
                    break;
                }
                case 3: {
                    short s2 = resultSet.getShort(n2);
                    value = resultSet.wasNull() ? ValueNull.INSTANCE : ValueShort.get(s2);
                    break;
                }
                case 14: {
                    String string = resultSet.getString(n2);
                    value = string == null ? ValueNull.INSTANCE : ValueStringIgnoreCase.get(string);
                    break;
                }
                case 21: {
                    String string = resultSet.getString(n2);
                    value = string == null ? ValueNull.INSTANCE : ValueStringFixed.get(string);
                    break;
                }
                case 13: {
                    String string = resultSet.getString(n2);
                    value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
                    break;
                }
                case 16: {
                    Reader reader;
                    String string;
                    value = sessionInterface == null ? ((string = resultSet.getString(n2)) == null ? ValueNull.INSTANCE : ValueLobDb.createSmallLob(16, string.getBytes(Constants.UTF8))) : ((reader = resultSet.getCharacterStream(n2)) == null ? ValueNull.INSTANCE : sessionInterface.getDataHandler().getLobStorage().createClob(new BufferedReader(reader), -1L));
                    if (sessionInterface == null) break;
                    sessionInterface.addTemporaryLob(value);
                    break;
                }
                case 15: {
                    if (sessionInterface == null) {
                        byte[] byArray = resultSet.getBytes(n2);
                        return byArray == null ? ValueNull.INSTANCE : ValueLobDb.createSmallLob(15, byArray);
                    }
                    InputStream inputStream = resultSet.getBinaryStream(n2);
                    Value value2 = value = inputStream == null ? ValueNull.INSTANCE : sessionInterface.getDataHandler().getLobStorage().createBlob(inputStream, -1L);
                    if (sessionInterface == null) break;
                    sessionInterface.addTemporaryLob(value);
                    break;
                }
                case 19: {
                    if (SysProperties.serializeJavaObject) {
                        byte[] byArray = resultSet.getBytes(n2);
                        value = byArray == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(null, byArray, sessionInterface.getDataHandler());
                        break;
                    }
                    Object object = resultSet.getObject(n2);
                    value = object == null ? ValueNull.INSTANCE : ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
                    break;
                }
                case 17: {
                    Array array = resultSet.getArray(n2);
                    if (array == null) {
                        return ValueNull.INSTANCE;
                    }
                    Object[] objectArray = (Object[])array.getArray();
                    if (objectArray == null) {
                        return ValueNull.INSTANCE;
                    }
                    int n5 = objectArray.length;
                    Value[] valueArray = new Value[n5];
                    for (int i2 = 0; i2 < n5; ++i2) {
                        valueArray[i2] = DataType.convertToValue(sessionInterface, objectArray[i2], 0);
                    }
                    value = ValueArray.get(valueArray);
                    break;
                }
                case 18: {
                    ResultSet resultSet2 = (ResultSet)resultSet.getObject(n2);
                    if (resultSet2 == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueResultSet.get(resultSet2);
                }
                case 22: {
                    Object object = resultSet.getObject(n2);
                    if (object == null) {
                        return ValueNull.INSTANCE;
                    }
                    return ValueGeometry.getFromGeometry(object);
                }
                default: {
                    throw DbException.throwInternalError("type=" + n3);
                }
            }
            return value;
        }
        catch (SQLException sQLException) {
            throw DbException.convert(sQLException);
        }
    }

    public static String getTypeClassName(int n2) {
        switch (n2) {
            case 1: {
                return Boolean.class.getName();
            }
            case 2: {
                return Byte.class.getName();
            }
            case 3: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case 5: {
                return Long.class.getName();
            }
            case 6: {
                return BigDecimal.class.getName();
            }
            case 9: {
                return Time.class.getName();
            }
            case 10: {
                return Date.class.getName();
            }
            case 11: 
            case 23: {
                return Timestamp.class.getName();
            }
            case 24: {
                return TimestampWithTimeZone.class.getName();
            }
            case 12: 
            case 20: {
                return byte[].class.getName();
            }
            case 13: 
            case 14: 
            case 21: {
                return String.class.getName();
            }
            case 15: {
                return Blob.class.getName();
            }
            case 16: {
                return Clob.class.getName();
            }
            case 7: {
                return Double.class.getName();
            }
            case 8: {
                return Float.class.getName();
            }
            case 0: {
                return null;
            }
            case 19: {
                return Object.class.getName();
            }
            case -1: {
                return Object.class.getName();
            }
            case 17: {
                return Array.class.getName();
            }
            case 18: {
                return ResultSet.class.getName();
            }
            case 22: {
                return GEOMETRY_CLASS_NAME;
            }
        }
        throw DbException.throwInternalError("type=" + n2);
    }

    public static DataType getDataType(int n2) {
        if (n2 == -1) {
            throw DbException.get(50004, "?");
        }
        DataType dataType = TYPES_BY_VALUE_TYPE.get(n2);
        if (dataType == null) {
            dataType = TYPES_BY_VALUE_TYPE.get(0);
        }
        return dataType;
    }

    public static int convertTypeToSQLType(int n2) {
        return DataType.getDataType((int)n2).sqlType;
    }

    public static int convertSQLTypeToValueType(int n2, String string) {
        switch (n2) {
            case 1111: 
            case 2000: {
                if (!string.equalsIgnoreCase("geometry")) break;
                return 22;
            }
        }
        return DataType.convertSQLTypeToValueType(n2);
    }

    public static int getValueTypeFromResultSet(ResultSetMetaData resultSetMetaData, int n2) throws SQLException {
        return DataType.convertSQLTypeToValueType(resultSetMetaData.getColumnType(n2), resultSetMetaData.getColumnTypeName(n2));
    }

    public static int convertSQLTypeToValueType(int n2) {
        switch (n2) {
            case -15: 
            case 1: {
                return 21;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return 13;
            }
            case 2: 
            case 3: {
                return 6;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case -6: {
                return 2;
            }
            case -5: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 6: 
            case 8: {
                return 7;
            }
            case -4: 
            case -3: 
            case -2: {
                return 12;
            }
            case 1111: 
            case 2000: {
                return 19;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 9;
            }
            case 93: {
                return 11;
            }
            case 2004: {
                return 15;
            }
            case 2005: 
            case 2011: {
                return 16;
            }
            case 0: {
                return 0;
            }
            case 2003: {
                return 17;
            }
            case -10: {
                return 18;
            }
        }
        throw DbException.get(50004, "" + n2);
    }

    public static int getTypeFromClass(Class<?> clazz) {
        if (clazz == null || Void.TYPE == clazz) {
            return 0;
        }
        if (clazz.isPrimitive()) {
            clazz = Utils.getNonPrimitiveClass(clazz);
        }
        if (String.class == clazz) {
            return 13;
        }
        if (Integer.class == clazz) {
            return 4;
        }
        if (Long.class == clazz) {
            return 5;
        }
        if (Boolean.class == clazz) {
            return 1;
        }
        if (Double.class == clazz) {
            return 7;
        }
        if (Byte.class == clazz) {
            return 2;
        }
        if (Short.class == clazz) {
            return 3;
        }
        if (Character.class == clazz) {
            throw DbException.get(22018, "char (not supported)");
        }
        if (Float.class == clazz) {
            return 8;
        }
        if (byte[].class == clazz) {
            return 12;
        }
        if (UUID.class == clazz) {
            return 20;
        }
        if (Void.class == clazz) {
            return 0;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return 6;
        }
        if (ResultSet.class.isAssignableFrom(clazz)) {
            return 18;
        }
        if (Value.ValueBlob.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Value.ValueClob.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 10;
        }
        if (Time.class.isAssignableFrom(clazz)) {
            return 9;
        }
        if (Timestamp.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (Clob.class.isAssignableFrom(clazz)) {
            return 16;
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Blob.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (Object[].class.isAssignableFrom(clazz)) {
            return 17;
        }
        if (DataType.isGeometryClass(clazz)) {
            return 22;
        }
        return 19;
    }

    public static Value convertToValue(SessionInterface sessionInterface, Object object, int n2) {
        Value value = DataType.convertToValue1(sessionInterface, object, n2);
        if (sessionInterface != null) {
            sessionInterface.addTemporaryLob(value);
        }
        return value;
    }

    private static Value convertToValue1(SessionInterface sessionInterface, Object object, int n2) {
        if (object == null) {
            return ValueNull.INSTANCE;
        }
        if (n2 == 19) {
            return ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
        }
        if (object instanceof String) {
            return ValueString.get((String)object);
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof Long) {
            return ValueLong.get((Long)object);
        }
        if (object instanceof Integer) {
            return ValueInt.get((Integer)object);
        }
        if (object instanceof BigInteger) {
            return ValueDecimal.get(new BigDecimal((BigInteger)object));
        }
        if (object instanceof BigDecimal) {
            return ValueDecimal.get((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return ValueBoolean.get((Boolean)object);
        }
        if (object instanceof Byte) {
            return ValueByte.get((Byte)object);
        }
        if (object instanceof Short) {
            return ValueShort.get((Short)object);
        }
        if (object instanceof Float) {
            return ValueFloat.get(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return ValueDouble.get((Double)object);
        }
        if (object instanceof byte[]) {
            return ValueBytes.get((byte[])object);
        }
        if (object instanceof Date) {
            return ValueDate.get((Date)object);
        }
        if (object instanceof Time) {
            return ValueTime.get((Time)object);
        }
        if (object instanceof Timestamp) {
            return ValueTimestamp.get((Timestamp)object);
        }
        if (object instanceof java.util.Date) {
            return ValueTimestamp.fromMillis(((java.util.Date)object).getTime());
        }
        if (object instanceof Reader) {
            BufferedReader bufferedReader = new BufferedReader((Reader)object);
            return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, -1L);
        }
        if (object instanceof Clob) {
            try {
                BufferedReader bufferedReader = new BufferedReader(((Clob)object).getCharacterStream());
                return sessionInterface.getDataHandler().getLobStorage().createClob(bufferedReader, -1L);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof InputStream) {
            return sessionInterface.getDataHandler().getLobStorage().createBlob((InputStream)object, -1L);
        }
        if (object instanceof Blob) {
            try {
                return sessionInterface.getDataHandler().getLobStorage().createBlob(((Blob)object).getBinaryStream(), -1L);
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
        if (object instanceof ResultSet) {
            if (object instanceof SimpleResultSet) {
                return ValueResultSet.get((ResultSet)object);
            }
            return ValueResultSet.getCopy((ResultSet)object, Integer.MAX_VALUE);
        }
        if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            return ValueUuid.get(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n3 = objectArray.length;
            Value[] valueArray = new Value[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                valueArray[i2] = DataType.convertToValue(sessionInterface, objectArray[i2], n2);
            }
            return ValueArray.get(object.getClass().getComponentType(), valueArray);
        }
        if (object instanceof Character) {
            return ValueStringFixed.get(((Character)object).toString());
        }
        if (DataType.isGeometry(object)) {
            return ValueGeometry.getFromGeometry(object);
        }
        return ValueJavaObject.getNoCopy(object, null, sessionInterface.getDataHandler());
    }

    public static boolean isGeometryClass(Class<?> clazz) {
        if (clazz == null || GEOMETRY_CLASS == null) {
            return false;
        }
        return GEOMETRY_CLASS.isAssignableFrom(clazz);
    }

    public static boolean isGeometry(Object object) {
        if (object == null) {
            return false;
        }
        return DataType.isGeometryClass(object.getClass());
    }

    public static DataType getTypeByName(String string) {
        return TYPES_BY_NAME.get(string);
    }

    public static boolean isLargeObject(int n2) {
        return n2 == 15 || n2 == 16;
    }

    public static boolean isStringType(int n2) {
        return n2 == 13 || n2 == 21 || n2 == 14;
    }

    public static boolean supportsAdd(int n2) {
        switch (n2) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static int getAddProofType(int n2) {
        switch (n2) {
            case 2: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 3: {
                return 5;
            }
        }
        return n2;
    }

    public static Object getDefaultForPrimitiveType(Class<?> clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        throw DbException.throwInternalError("primitive=" + clazz.toString());
    }

    public static Object convertTo(JdbcConnection jdbcConnection, Value value, Class<?> clazz) {
        if (clazz == Blob.class) {
            return new JdbcBlob(jdbcConnection, value, 0);
        }
        if (clazz == Clob.class) {
            return new JdbcClob(jdbcConnection, value, 0);
        }
        if (value.getType() == 19) {
            Object object;
            Object object2 = object = SysProperties.serializeJavaObject ? JdbcUtils.deserialize(value.getBytes(), jdbcConnection.getSession().getDataHandler()) : value.getObject();
            if (clazz.isAssignableFrom(object.getClass())) {
                return object;
            }
        }
        throw DbException.getUnsupportedException("converting to class " + clazz.getName());
    }

    static {
        Class clazz;
        TYPES = New.arrayList();
        TYPES_BY_NAME = New.hashMap();
        TYPES_BY_VALUE_TYPE = New.arrayList();
        try {
            clazz = JdbcUtils.loadUserClass(GEOMETRY_CLASS_NAME);
        }
        catch (Exception exception) {
            clazz = null;
        }
        GEOMETRY_CLASS = clazz;
        for (int i2 = 0; i2 < 25; ++i2) {
            TYPES_BY_VALUE_TYPE.add(null);
        }
        DataType.add(0, 0, "Null", new DataType(), new String[]{"NULL"}, 0);
        DataType.add(13, 12, "String", DataType.createString(true), new String[]{"VARCHAR", "VARCHAR2", "NVARCHAR", "NVARCHAR2", "VARCHAR_CASESENSITIVE", "CHARACTER VARYING", "TID"}, 48);
        DataType.add(13, -1, "String", DataType.createString(true), new String[]{"LONGVARCHAR", "LONGNVARCHAR"}, 48);
        DataType.add(21, 1, "String", DataType.createString(true), new String[]{"CHAR", "CHARACTER", "NCHAR"}, 48);
        DataType.add(14, 12, "String", DataType.createString(false), new String[]{"VARCHAR_IGNORECASE"}, 48);
        DataType.add(1, 16, "Boolean", DataType.createDecimal(1, 1, 0, 5, false, false), new String[]{"BOOLEAN", "BIT", "BOOL"}, 0);
        DataType.add(2, -6, "Byte", DataType.createDecimal(3, 3, 0, 4, false, false), new String[]{"TINYINT"}, 1);
        DataType.add(3, 5, "Short", DataType.createDecimal(5, 5, 0, 6, false, false), new String[]{"SMALLINT", "YEAR", "INT2"}, 20);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, false), new String[]{"INTEGER", "INT", "MEDIUMINT", "INT4", "SIGNED"}, 20);
        DataType.add(4, 4, "Int", DataType.createDecimal(10, 10, 0, 11, false, true), new String[]{"SERIAL"}, 20);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, false), new String[]{"BIGINT", "INT8", "LONG"}, 24);
        DataType.add(5, -5, "Long", DataType.createDecimal(19, 19, 0, 20, false, true), new String[]{"IDENTITY", "BIGSERIAL"}, 24);
        DataType.add(6, 3, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"DECIMAL", "DEC"}, 64);
        DataType.add(6, 2, "BigDecimal", DataType.createDecimal(Integer.MAX_VALUE, 65535, Short.MAX_VALUE, 65535, true, false), new String[]{"NUMERIC", "NUMBER"}, 64);
        DataType.add(8, 7, "Float", DataType.createDecimal(7, 7, 0, 15, false, false), new String[]{"REAL", "FLOAT4"}, 24);
        DataType.add(7, 8, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"DOUBLE", "DOUBLE PRECISION"}, 24);
        DataType.add(7, 6, "Double", DataType.createDecimal(17, 17, 0, 24, false, false), new String[]{"FLOAT", "FLOAT8"}, 24);
        DataType.add(9, 92, "Time", DataType.createDate(6, "TIME", 0, 8), new String[]{"TIME"}, 56);
        DataType.add(10, 91, "Date", DataType.createDate(8, "DATE", 0, 10), new String[]{"DATE"}, 56);
        DataType.add(11, 93, "Timestamp", DataType.createDate(23, "TIMESTAMP", 10, 23), new String[]{"TIMESTAMP", "DATETIME", "DATETIME2", "SMALLDATETIME"}, 56);
        DataType.add(23, 93, "TimestampUtc", DataType.createDate(23, "TIMESTAMP_UTC", 10, 23), new String[]{"TIMESTAMP_UTC"}, 56);
        DataType.add(24, 1111, "TimestampTimeZone", DataType.createDate(30, "TIMESTAMP_TZ", 10, 30), new String[]{"TIMESTAMP WITH TIMEZONE"}, 58);
        DataType.add(12, -3, "Bytes", DataType.createString(false), new String[]{"VARBINARY"}, 32);
        DataType.add(12, -2, "Bytes", DataType.createString(false), new String[]{"BINARY", "RAW", "BYTEA", "LONG RAW"}, 32);
        DataType.add(12, -4, "Bytes", DataType.createString(false), new String[]{"LONGVARBINARY"}, 32);
        DataType.add(20, -2, "Bytes", DataType.createString(false), new String[]{"UUID"}, 32);
        DataType.add(19, 1111, "Object", DataType.createString(false), new String[]{"OTHER", "OBJECT", "JAVA_OBJECT"}, 24);
        DataType.add(15, 2004, "Blob", DataType.createLob(), new String[]{"BLOB", "TINYBLOB", "MEDIUMBLOB", "LONGBLOB", "IMAGE", "OID"}, 104);
        DataType.add(16, 2005, "Clob", DataType.createLob(), new String[]{"CLOB", "TINYTEXT", "TEXT", "MEDIUMTEXT", "LONGTEXT", "NTEXT", "NCLOB"}, 104);
        DataType.add(22, 1111, "Geometry", DataType.createString(false), new String[]{"GEOMETRY"}, 32);
        DataType dataType = new DataType();
        dataType.prefix = "(";
        dataType.suffix = "')";
        DataType.add(17, 2003, "Array", dataType, new String[]{"ARRAY"}, 32);
        dataType = new DataType();
        DataType.add(18, -10, "ResultSet", dataType, new String[]{"RESULT_SET"}, 400);
        int n2 = TYPES_BY_VALUE_TYPE.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            DataType dataType2 = TYPES_BY_VALUE_TYPE.get(i3);
            if (dataType2 == null) {
                DbException.throwInternalError("unmapped type " + i3);
            }
            Value.getOrder(i3);
        }
    }
}

