/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.text.Collator;
import java.util.Locale;
import org.h2.engine.SysProperties;
import org.h2.util.StringUtils;
import org.h2.value.CompareModeDefault;
import org.h2.value.CompareModeIcu4J;

public class CompareMode {
    public static final String OFF = "OFF";
    public static final String DEFAULT = "DEFAULT_";
    public static final String ICU4J = "ICU4J_";
    public static final String SIGNED = "SIGNED";
    public static final String UNSIGNED = "UNSIGNED";
    private static volatile CompareMode lastUsed;
    private static final boolean CAN_USE_ICU4J;
    private final String name;
    private final int strength;
    private final boolean binaryUnsigned;

    protected CompareMode(String string, int n2, boolean bl2) {
        this.name = string;
        this.strength = n2;
        this.binaryUnsigned = bl2;
    }

    public static CompareMode getInstance(String string, int n2) {
        return CompareMode.getInstance(string, n2, SysProperties.SORT_BINARY_UNSIGNED);
    }

    public static CompareMode getInstance(String string, int n2, boolean bl2) {
        CompareMode compareMode = lastUsed;
        if (compareMode != null && StringUtils.equals(compareMode.name, string) && compareMode.strength == n2 && compareMode.binaryUnsigned == bl2) {
            return compareMode;
        }
        if (string == null || string.equals(OFF)) {
            compareMode = new CompareMode(string, n2, bl2);
        } else {
            boolean bl3;
            if (string.startsWith(ICU4J)) {
                bl3 = true;
                string = string.substring(ICU4J.length());
            } else if (string.startsWith(DEFAULT)) {
                bl3 = false;
                string = string.substring(DEFAULT.length());
            } else {
                bl3 = CAN_USE_ICU4J;
            }
            compareMode = bl3 ? new CompareModeIcu4J(string, n2, bl2) : new CompareModeDefault(string, n2, bl2);
        }
        lastUsed = compareMode;
        return compareMode;
    }

    public boolean equalsChars(String string, int n2, String string2, int n3, boolean bl2) {
        char c2 = string.charAt(n2);
        char c3 = string2.charAt(n3);
        if (bl2) {
            c2 = Character.toUpperCase(c2);
            c3 = Character.toUpperCase(c3);
        }
        return c2 == c3;
    }

    public int compareString(String string, String string2, boolean bl2) {
        if (bl2) {
            return string.compareToIgnoreCase(string2);
        }
        return string.compareTo(string2);
    }

    public static String getName(Locale locale) {
        Locale locale2 = Locale.ENGLISH;
        String string = locale.getDisplayLanguage(locale2) + ' ' + locale.getDisplayCountry(locale2) + ' ' + locale.getVariant();
        string = StringUtils.toUpperEnglish(string.trim().replace(' ', '_'));
        return string;
    }

    static boolean compareLocaleNames(Locale locale, String string) {
        return string.equalsIgnoreCase(locale.toString()) || string.equalsIgnoreCase(CompareMode.getName(locale));
    }

    public static Collator getCollator(String string) {
        String string2;
        String string3;
        Locale locale2;
        int n2;
        Collator collator = null;
        if (string.startsWith(ICU4J)) {
            string = string.substring(ICU4J.length());
        } else if (string.startsWith(DEFAULT)) {
            string = string.substring(DEFAULT.length());
        }
        if (string.length() == 2) {
            Locale[] localeArray = new Locale(StringUtils.toLowerEnglish(string), "");
            if (CompareMode.compareLocaleNames((Locale)localeArray, string)) {
                collator = Collator.getInstance((Locale)localeArray);
            }
        } else if (string.length() == 5 && (n2 = string.indexOf(95)) >= 0 && CompareMode.compareLocaleNames(locale2 = new Locale(string3 = StringUtils.toLowerEnglish(string.substring(0, n2)), string2 = string.substring(n2 + 1)), string)) {
            collator = Collator.getInstance(locale2);
        }
        if (collator == null) {
            for (Locale locale2 : Collator.getAvailableLocales()) {
                if (!CompareMode.compareLocaleNames(locale2, string)) continue;
                collator = Collator.getInstance(locale2);
                break;
            }
        }
        return collator;
    }

    public String getName() {
        return this.name == null ? OFF : this.name;
    }

    public int getStrength() {
        return this.strength;
    }

    public boolean isBinaryUnsigned() {
        return this.binaryUnsigned;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompareMode)) {
            return false;
        }
        CompareMode compareMode = (CompareMode)object;
        if (!this.getName().equals(compareMode.getName())) {
            return false;
        }
        if (this.strength != compareMode.strength) {
            return false;
        }
        return this.binaryUnsigned == compareMode.binaryUnsigned;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.strength ^ (this.binaryUnsigned ? -1 : 0);
    }

    static {
        boolean bl2 = false;
        try {
            Class.forName("com.ibm.icu.text.Collator");
            bl2 = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        CAN_USE_ICU4J = bl2;
    }
}

