/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.ArrayList;
import org.h2.message.DbException;
import org.h2.util.HashBase;
import org.h2.util.New;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ValueHashMap<V>
extends HashBase {
    private Value[] keys;
    private V[] values;

    public static <T> ValueHashMap<T> newInstance() {
        return new ValueHashMap();
    }

    @Override
    protected void reset(int n2) {
        super.reset(n2);
        this.keys = new Value[this.len];
        this.values = new Object[this.len];
    }

    @Override
    protected void rehash(int n2) {
        Value[] valueArray = this.keys;
        V[] VArray = this.values;
        this.reset(n2);
        int n3 = valueArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Value value = valueArray[i2];
            if (value == null || value == ValueNull.DELETED) continue;
            this.internalPut(value, VArray[i2]);
        }
    }

    private int getIndex(Value value) {
        return value.hashCode() & this.mask;
    }

    public void put(Value value, V v2) {
        this.checkSizePut();
        this.internalPut(value, v2);
    }

    private void internalPut(Value value, V v2) {
        int n2 = this.getIndex(value);
        int n3 = 1;
        int n4 = -1;
        do {
            Value value2;
            if ((value2 = this.keys[n2]) == null) {
                if (n4 >= 0) {
                    n2 = n4;
                    --this.deletedCount;
                }
                ++this.size;
                this.keys[n2] = value;
                this.values[n2] = v2;
                return;
            }
            if (value2 == ValueNull.DELETED) {
                if (n4 < 0) {
                    n4 = n2;
                }
            } else if (value2.equals(value)) {
                this.values[n2] = v2;
                return;
            }
            n2 = n2 + n3++ & this.mask;
        } while (n3 <= this.len);
        DbException.throwInternalError("hashmap is full");
    }

    public void remove(Value value) {
        this.checkSizeRemove();
        int n2 = this.getIndex(value);
        int n3 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n2]) == null) {
                return;
            }
            if (value2 != ValueNull.DELETED && value2.equals(value)) {
                this.keys[n2] = ValueNull.DELETED;
                this.values[n2] = null;
                ++this.deletedCount;
                --this.size;
                return;
            }
            n2 = n2 + n3++ & this.mask;
        } while (n3 <= this.len);
    }

    public V get(Value value) {
        int n2 = this.getIndex(value);
        int n3 = 1;
        do {
            Value value2;
            if ((value2 = this.keys[n2]) == null) {
                return null;
            }
            if (value2 != ValueNull.DELETED && value2.equals(value)) {
                return this.values[n2];
            }
            n2 = n2 + n3++ & this.mask;
        } while (n3 <= this.len);
        return null;
    }

    public ArrayList<Value> keys() {
        ArrayList<Value> arrayList = New.arrayList(this.size);
        for (Value value : this.keys) {
            if (value == null || value == ValueNull.DELETED) continue;
            arrayList.add(value);
        }
        return arrayList;
    }

    public ArrayList<V> values() {
        ArrayList arrayList = New.arrayList(this.size);
        int n2 = this.keys.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Value value = this.keys[i2];
            if (value == null || value == ValueNull.DELETED) continue;
            arrayList.add(this.values[i2]);
        }
        return arrayList;
    }
}

