/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.New;

public class Utils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final int GC_DELAY = 50;
    private static final int MAX_GC = 8;
    private static long lastGC;
    private static final HashMap<String, byte[]> RESOURCES;

    private Utils() {
    }

    private static int readInt(byte[] byArray, int n2) {
        return (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2] & 0xFF);
    }

    public static void writeLong(byte[] byArray, int n2, long l2) {
        Utils.writeInt(byArray, n2, (int)(l2 >> 32));
        Utils.writeInt(byArray, n2 + 4, (int)l2);
    }

    private static void writeInt(byte[] byArray, int n2, int n3) {
        byArray[n2++] = (byte)(n3 >> 24);
        byArray[n2++] = (byte)(n3 >> 16);
        byArray[n2++] = (byte)(n3 >> 8);
        byArray[n2++] = (byte)n3;
    }

    public static long readLong(byte[] byArray, int n2) {
        return ((long)Utils.readInt(byArray, n2) << 32) + ((long)Utils.readInt(byArray, n2 + 4) & 0xFFFFFFFFL);
    }

    public static int indexOf(byte[] byArray, byte[] byArray2, int n2) {
        if (byArray2.length == 0) {
            return n2;
        }
        if (n2 > byArray.length) {
            return -1;
        }
        int n3 = byArray.length - byArray2.length + 1;
        int n4 = byArray2.length;
        while (n2 < n3) {
            block5: {
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (byArray[n2 + i2] == byArray2[i2]) {
                        continue;
                    }
                    break block5;
                }
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static int getByteArrayHash(byte[] byArray) {
        int n2;
        int n3 = n2 = byArray.length;
        if (n2 < 50) {
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = 31 * n3 + byArray[i2];
            }
        } else {
            int n4;
            int n5 = n2 / 16;
            for (n4 = 0; n4 < 4; ++n4) {
                n3 = 31 * n3 + byArray[n4];
                n3 = 31 * n3 + byArray[--n2];
            }
            for (n4 = 4 + n5; n4 < n2; n4 += n5) {
                n3 = 31 * n3 + byArray[n4];
            }
        }
        return n3;
    }

    public static boolean compareSecure(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray2 == null) {
            return byArray == null && byArray2 == null;
        }
        int n2 = byArray.length;
        if (n2 != byArray2.length) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 |= byArray[i2] ^ byArray2[i2];
        }
        return n3 == 0;
    }

    public static int compareNotNullSigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n2 = Math.min(byArray.length, byArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by2 = byArray[i2];
            byte by3 = byArray2[i2];
            if (by2 == by3) continue;
            return by2 > by3 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static int compareNotNullUnsigned(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return 0;
        }
        int n2 = Math.min(byArray.length, byArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            int n4 = byArray2[i2] & 0xFF;
            if (n3 == n4) continue;
            return n3 > n4 ? 1 : -1;
        }
        return Integer.signum(byArray.length - byArray2.length);
    }

    public static byte[] copy(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        if (n2 > byArray2.length) {
            byArray2 = new byte[n2];
        }
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static byte[] cloneByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n2 = byArray.length;
        if (n2 == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static int hashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static int getMemoryUsed() {
        Utils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory() - runtime.freeMemory();
        return (int)(l2 >> 10);
    }

    public static int getMemoryFree() {
        Utils.collectGarbage();
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.freeMemory();
        return (int)(l2 >> 10);
    }

    public static long getMemoryMax() {
        long l2 = Runtime.getRuntime().maxMemory();
        return l2 / 1024L;
    }

    private static synchronized void collectGarbage() {
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = System.currentTimeMillis();
        if (lastGC + 50L < l3) {
            for (int i2 = 0; i2 < 8; ++i2) {
                runtime.gc();
                long l4 = runtime.totalMemory();
                if (l4 == l2) {
                    lastGC = System.currentTimeMillis();
                    break;
                }
                l2 = l4;
            }
        }
    }

    public static int[] newIntArray(int n2) {
        if (n2 == 0) {
            return EMPTY_INT_ARRAY;
        }
        return new int[n2];
    }

    public static long[] newLongArray(int n2) {
        if (n2 == 0) {
            return EMPTY_LONG_ARRAY;
        }
        return new long[n2];
    }

    public static <X> void sortTopN(X[] XArray, int n2, int n3, Comparator<? super X> comparator) {
        Utils.partitionTopN(XArray, n2, n3, comparator);
        Arrays.sort(XArray, n2, (int)Math.min((long)n2 + (long)n3, (long)XArray.length), comparator);
    }

    private static <X> void partitionTopN(X[] XArray, int n2, int n3, Comparator<? super X> comparator) {
        Utils.partialQuickSort(XArray, 0, XArray.length - 1, comparator, n2, n2 + n3 - 1);
    }

    private static <X> void partialQuickSort(X[] XArray, int n2, int n3, Comparator<? super X> comparator, int n4, int n5) {
        if (n2 > n5 || n3 < n4 || n2 > n4 && n3 < n5) {
            return;
        }
        if (n2 == n3) {
            return;
        }
        int n6 = n2;
        int n7 = n3;
        int n8 = n2 + MathUtils.randomInt(n3 - n2);
        X x2 = XArray[n8];
        int n9 = n2 + n3 >>> 1;
        X x3 = XArray[n9];
        XArray[n9] = x2;
        XArray[n8] = x3;
        while (n6 <= n7) {
            while (comparator.compare(XArray[n6], x2) < 0) {
                ++n6;
            }
            while (comparator.compare(XArray[n7], x2) > 0) {
                --n7;
            }
            if (n6 > n7) continue;
            x3 = XArray[n6];
            XArray[n6++] = XArray[n7];
            XArray[n7--] = x3;
        }
        if (n2 < n7) {
            Utils.partialQuickSort(XArray, n2, n7, comparator, n4, n5);
        }
        if (n6 < n3) {
            Utils.partialQuickSort(XArray, n6, n3, comparator, n4, n5);
        }
    }

    public static boolean haveCommonComparableSuperclass(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3;
        Class<?> clazz4;
        if (clazz == clazz2 || clazz.isAssignableFrom(clazz2) || clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        do {
            clazz4 = clazz;
        } while (Comparable.class.isAssignableFrom(clazz = clazz.getSuperclass()));
        do {
            clazz3 = clazz2;
        } while (Comparable.class.isAssignableFrom(clazz2 = clazz2.getSuperclass()));
        return clazz4 == clazz3;
    }

    public static byte[] getResource(String string) throws IOException {
        byte[] byArray = RESOURCES.get(string);
        if (byArray == null && (byArray = Utils.loadResource(string)) != null) {
            RESOURCES.put(string, byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadResource(String string) throws IOException {
        InputStream inputStream = Utils.class.getResourceAsStream("data.zip");
        if (inputStream == null) {
            inputStream = Utils.class.getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            return IOUtils.readBytesAndClose(inputStream, 0);
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                if (!string2.startsWith("/")) {
                    string2 = "/" + string2;
                }
                if (string2.equals(string)) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    IOUtils.copy(zipInputStream, byteArrayOutputStream);
                    zipInputStream.closeEntry();
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    return byArray;
                }
                zipInputStream.closeEntry();
            }
        }
        return null;
    }

    public static Object callStaticMethod(String string, Object ... objectArray) throws Exception {
        int n2 = string.lastIndexOf(46);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        return Utils.callMethod(null, Class.forName(string2), string3, objectArray);
    }

    public static Object callMethod(Object object, String string, Object ... objectArray) throws Exception {
        return Utils.callMethod(object, object.getClass(), string, objectArray);
    }

    private static Object callMethod(Object object, Class<?> clazz, String string, Object ... objectArray) throws Exception {
        Method method = null;
        int n2 = 0;
        boolean bl2 = object == null;
        for (Method method2 : clazz.getMethods()) {
            int n3;
            if (Modifier.isStatic(method2.getModifiers()) != bl2 || !method2.getName().equals(string) || (n3 = Utils.match(method2.getParameterTypes(), objectArray)) <= n2) continue;
            n2 = n3;
            method = method2;
        }
        if (method == null) {
            throw new NoSuchMethodException(string);
        }
        return method.invoke(object, objectArray);
    }

    public static Object newInstance(String string, Object ... objectArray) throws Exception {
        Constructor<?> constructor = null;
        int n2 = 0;
        for (Constructor<?> constructor2 : Class.forName(string).getConstructors()) {
            int n3 = Utils.match(constructor2.getParameterTypes(), objectArray);
            if (n3 <= n2) continue;
            n2 = n3;
            constructor = constructor2;
        }
        if (constructor == null) {
            throw new NoSuchMethodException(string);
        }
        return constructor.newInstance(objectArray);
    }

    private static int match(Class<?>[] classArray, Object[] objectArray) {
        int n2 = classArray.length;
        if (n2 == objectArray.length) {
            int n3 = 1;
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz;
                Class<?> clazz2 = Utils.getNonPrimitiveClass(classArray[i2]);
                Object object = objectArray[i2];
                Class<?> clazz3 = clazz = object == null ? null : object.getClass();
                if (clazz2 == clazz) {
                    ++n3;
                    continue;
                }
                if (clazz == null || clazz2.isAssignableFrom(clazz)) continue;
                return 0;
            }
            return n3;
        }
        return 0;
    }

    public static Object getStaticField(String string) throws Exception {
        int n2 = string.lastIndexOf(46);
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        return Class.forName(string2).getField(string3).get(null);
    }

    public static Object getField(Object object, String string) throws Exception {
        return object.getClass().getField(string).get(object);
    }

    public static boolean isClassPresent(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Class<?> getNonPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        return clazz;
    }

    public static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    public static int getProperty(String string, int n2) {
        String string2 = Utils.getProperty(string, null);
        if (string2 != null) {
            try {
                return Integer.decode(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static boolean getProperty(String string, boolean bl2) {
        String string2 = Utils.getProperty(string, null);
        if (string2 != null) {
            try {
                return Boolean.parseBoolean(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl2;
    }

    public static int scaleForAvailableMemory(int n2) {
        long l2 = Runtime.getRuntime().maxMemory();
        if (l2 != Long.MAX_VALUE) {
            return (int)((long)n2 * l2 / 0x40000000L);
        }
        try {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            Method method = Class.forName("com.sun.management.OperatingSystemMXBean").getMethod("getTotalPhysicalMemorySize", new Class[0]);
            long l3 = ((Number)method.invoke((Object)operatingSystemMXBean, new Object[0])).longValue();
            return (int)((long)n2 * l3 / 0x40000000L);
        }
        catch (Exception exception) {
            return n2;
        }
    }

    static {
        RESOURCES = New.hashMap();
    }

    public static interface ClassFactory {
        public boolean match(String var1);

        public Class<?> loadClass(String var1) throws ClassNotFoundException;
    }
}

