/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.message.DbException;
import org.h2.util.StringUtils;

public class ToChar {
    private static final long JULIAN_EPOCH;

    private ToChar() {
    }

    public static String toChar(BigDecimal bigDecimal, String string, String string2) {
        char c2;
        char c3;
        int n2;
        int n3;
        int n4;
        Integer n5;
        char c4;
        int n6;
        int n7;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        String string3;
        String string4 = string3 = string != null ? string.toUpperCase() : null;
        if (string3 == null || string3.equals("TM") || string3.equals("TM9")) {
            String string5 = bigDecimal.toPlainString();
            return string5.startsWith("0.") ? string5.substring(1) : string5;
        }
        if (string3.equals("TME")) {
            int n8 = bigDecimal.precision() - bigDecimal.scale() - 1;
            bigDecimal = bigDecimal.movePointLeft(n8);
            return bigDecimal.toPlainString() + "E" + (n8 < 0 ? (char)'-' : '+') + (Math.abs(n8) < 10 ? "0" : "") + Math.abs(n8);
        }
        if (string3.equals("RN")) {
            boolean bl5 = string.startsWith("r");
            String string6 = StringUtils.pad(ToChar.toRomanNumeral(bigDecimal.intValue()), 15, " ", false);
            return bl5 ? string6.toLowerCase() : string6;
        }
        if (string3.equals("FMRN")) {
            boolean bl6 = string.charAt(2) == 'r';
            String string7 = ToChar.toRomanNumeral(bigDecimal.intValue());
            return bl6 ? string7.toLowerCase() : string7;
        }
        if (string3.endsWith("X")) {
            return ToChar.toHex(bigDecimal, string);
        }
        String string8 = string;
        DecimalFormatSymbols decimalFormatSymbols = DecimalFormatSymbols.getInstance();
        char c5 = decimalFormatSymbols.getGroupingSeparator();
        char c6 = decimalFormatSymbols.getDecimalSeparator();
        boolean bl7 = string3.startsWith("S");
        if (bl7) {
            string = string.substring(1);
        }
        if (bl4 = string3.endsWith("S")) {
            string = string.substring(0, string.length() - 1);
        }
        if (bl3 = string3.endsWith("MI")) {
            string = string.substring(0, string.length() - 2);
        }
        if (bl2 = string3.endsWith("PR")) {
            string = string.substring(0, string.length() - 2);
        }
        if ((n7 = string3.indexOf("V")) >= 0) {
            int n9 = 0;
            for (n6 = n7 + 1; n6 < string.length(); ++n6) {
                c4 = string.charAt(n6);
                if (c4 != '0' && c4 != '9') continue;
                ++n9;
            }
            bigDecimal = bigDecimal.movePointRight(n9);
            string = string.substring(0, n7) + string.substring(n7 + 1);
        }
        if (string.endsWith("EEEE")) {
            n5 = bigDecimal.precision() - bigDecimal.scale() - 1;
            bigDecimal = bigDecimal.movePointLeft(n5);
            string = string.substring(0, string.length() - 4);
        } else {
            n5 = null;
        }
        n6 = 1;
        char c7 = c4 = !string3.startsWith("FM") ? (char)'\u0001' : '\u0000';
        if (!c4) {
            string = string.substring(2);
        }
        if ((n4 = ToChar.calculateScale(string = string.replaceAll("[Bb]", ""), n3 = ToChar.findDecimalSeparator(string))) < bigDecimal.scale()) {
            bigDecimal = bigDecimal.setScale(n4, 4);
        }
        for (int i2 = string.indexOf(48); i2 >= 0 && i2 < n3; ++i2) {
            if (string.charAt(i2) != '9') continue;
            string = string.substring(0, i2) + "0" + string.substring(i2 + 1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string9 = (bigDecimal.abs().compareTo(BigDecimal.ONE) < 0 ? ToChar.zeroesAfterDecimalSeparator(bigDecimal) : "") + bigDecimal.unscaledValue().abs().toString();
        int n10 = string9.length() - bigDecimal.scale() - 1;
        for (n2 = n3 - 1; n2 >= 0; --n2) {
            c3 = string.charAt(n2);
            ++n6;
            if (c3 == '9' || c3 == '0') {
                if (n10 >= 0) {
                    c2 = string9.charAt(n10);
                    stringBuilder.insert(0, c2);
                    --n10;
                    continue;
                }
                if (c3 != '0' || n5 != null) continue;
                stringBuilder.insert(0, '0');
                continue;
            }
            if (c3 == ',') {
                if (n10 < 0 && (n2 <= 0 || string.charAt(n2 - 1) != '0')) continue;
                stringBuilder.insert(0, c3);
                continue;
            }
            if (c3 == 'G' || c3 == 'g') {
                if (n10 < 0 && (n2 <= 0 || string.charAt(n2 - 1) != '0')) continue;
                stringBuilder.insert(0, c5);
                continue;
            }
            if (c3 == 'C' || c3 == 'c') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                stringBuilder.insert(0, currency.getCurrencyCode());
                n6 += 6;
                continue;
            }
            if (c3 == 'L' || c3 == 'l' || c3 == 'U' || c3 == 'u') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                stringBuilder.insert(0, currency.getSymbol());
                n6 += 9;
                continue;
            }
            if (c3 == '$') {
                Currency currency = Currency.getInstance(Locale.getDefault());
                String string10 = currency.getSymbol();
                stringBuilder.insert(0, string10);
                continue;
            }
            throw DbException.get(90010, string8);
        }
        if (n10 >= 0) {
            return StringUtils.pad("", string.length() + 1, "#", true);
        }
        if (n3 < string.length()) {
            ++n6;
            c3 = string.charAt(n3);
            if (c3 == 'd' || c3 == 'D') {
                stringBuilder.append(c6);
            } else {
                stringBuilder.append(c3);
            }
            n10 = string9.length() - bigDecimal.scale();
            for (n2 = n3 + 1; n2 < string.length(); ++n2) {
                c2 = string.charAt(n2);
                ++n6;
                if (c2 == '9' || c2 == '0') {
                    if (n10 < string9.length()) {
                        char c8 = string9.charAt(n10);
                        stringBuilder.append(c8);
                        ++n10;
                        continue;
                    }
                    if (c2 != '0' && !c4) continue;
                    stringBuilder.append('0');
                    continue;
                }
                throw DbException.get(90010, string8);
            }
        }
        ToChar.addSign(stringBuilder, bigDecimal.signum(), bl7, bl4, bl3, bl2, c4 != '\u0000');
        if (n5 != null) {
            stringBuilder.append('E');
            stringBuilder.append(n5 < 0 ? (char)'-' : '+');
            stringBuilder.append(Math.abs(n5) < 10 ? "0" : "");
            stringBuilder.append(Math.abs(n5));
        }
        if (c4) {
            if (n5 != null) {
                stringBuilder.insert(0, ' ');
            } else {
                while (stringBuilder.length() < n6) {
                    stringBuilder.insert(0, ' ');
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String zeroesAfterDecimalSeparator(BigDecimal bigDecimal) {
        int n2;
        String string = bigDecimal.toString();
        int n3 = string.indexOf(46);
        if (n3 < 0) {
            return "";
        }
        boolean bl2 = true;
        for (n2 = n3 + 1; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == '0') continue;
            bl2 = false;
            break;
        }
        char[] cArray = new char[bl2 ? string.length() - n3 - 1 : n2 - 1 - n3];
        Arrays.fill(cArray, '0');
        return String.valueOf(cArray);
    }

    private static void addSign(StringBuilder stringBuilder, int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (bl5) {
            if (n2 < 0) {
                stringBuilder.insert(0, '<');
                stringBuilder.append('>');
            } else if (bl6) {
                stringBuilder.insert(0, ' ');
                stringBuilder.append(' ');
            }
        } else {
            String string = n2 == 0 ? "" : (n2 < 0 ? "-" : (bl2 || bl3 ? "+" : (bl6 ? " " : "")));
            if (bl4 || bl3) {
                stringBuilder.append(string);
            } else {
                stringBuilder.insert(0, string);
            }
        }
    }

    private static int findDecimalSeparator(String string) {
        int n2 = string.indexOf(46);
        if (n2 == -1 && (n2 = string.indexOf(68)) == -1 && (n2 = string.indexOf(100)) == -1) {
            n2 = string.length();
        }
        return n2;
    }

    private static int calculateScale(String string, int n2) {
        int n3 = 0;
        for (int i2 = n2; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '0' && c2 != '9') continue;
            ++n3;
        }
        return n3;
    }

    private static String toRomanNumeral(int n2) {
        int[] nArray = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] stringArray = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n3 = nArray[i2];
            String string = stringArray[i2];
            while (n2 >= n3) {
                stringBuilder.append(string);
                n2 -= n3;
            }
        }
        return stringBuilder.toString();
    }

    private static String toHex(BigDecimal bigDecimal, String string) {
        int n2;
        boolean bl2 = !string.toUpperCase().startsWith("FM");
        boolean bl3 = !string.contains("x");
        boolean bl4 = string.startsWith("0");
        int n3 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            char c2 = string.charAt(n2);
            if (c2 != '0' && c2 != 'X' && c2 != 'x') continue;
            ++n3;
        }
        n2 = bigDecimal.setScale(0, 4).intValue();
        String string2 = Integer.toHexString(n2);
        if (n3 < string2.length()) {
            string2 = StringUtils.pad("", n3 + 1, "#", true);
        } else {
            if (bl3) {
                string2 = string2.toUpperCase();
            }
            if (bl4) {
                string2 = StringUtils.pad(string2, n3, "0", false);
            }
            if (bl2) {
                string2 = StringUtils.pad(string2, string.length() + 1, " ", false);
            }
        }
        return string2;
    }

    public static String toChar(Timestamp timestamp, String string, String string2) {
        if (string == null) {
            string = "DD-MON-YY HH.MI.SS.FF PM";
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.ENGLISH);
        gregorianCalendar.setTimeInMillis(timestamp.getTime());
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        int n2 = 0;
        block0: while (n2 < string.length()) {
            boolean bl3;
            Capitalization capitalization = ToChar.containsAt(string, n2, "A.D.", "B.C.");
            if (capitalization != null) {
                String string3 = gregorianCalendar.get(0) == 1 ? "A.D." : "B.C.";
                stringBuilder.append(capitalization.apply(string3));
                n2 += 4;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "AD", "BC");
            if (capitalization != null) {
                String string4 = gregorianCalendar.get(0) == 1 ? "AD" : "BC";
                stringBuilder.append(capitalization.apply(string4));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "A.M.", "P.M.");
            if (capitalization != null) {
                String string5 = gregorianCalendar.get(9) == 0 ? "A.M." : "P.M.";
                stringBuilder.append(capitalization.apply(string5));
                n2 += 4;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "AM", "PM");
            if (capitalization != null) {
                String string6 = gregorianCalendar.get(9) == 0 ? "AM" : "PM";
                stringBuilder.append(capitalization.apply(string6));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "DL");
            if (capitalization != null) {
                stringBuilder.append(new SimpleDateFormat("EEEE, MMMM d, yyyy").format(timestamp));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "DS");
            if (capitalization != null) {
                stringBuilder.append(new SimpleDateFormat("MM/dd/yyyy").format(timestamp));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "TS");
            if (capitalization != null) {
                stringBuilder.append(new SimpleDateFormat("h:mm:ss aa").format(timestamp));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "DDD");
            if (capitalization != null) {
                stringBuilder.append(gregorianCalendar.get(6));
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "DD");
            if (capitalization != null) {
                stringBuilder.append(String.format("%02d", gregorianCalendar.get(5)));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "DY");
            if (capitalization != null) {
                String string7 = new SimpleDateFormat("EEE").format(timestamp).toUpperCase();
                stringBuilder.append(capitalization.apply(string7));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "DAY");
            if (capitalization != null) {
                String string8 = new SimpleDateFormat("EEEE").format(timestamp);
                if (bl2) {
                    string8 = StringUtils.pad(string8, "Wednesday".length(), " ", true);
                }
                stringBuilder.append(capitalization.apply(string8));
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "D");
            if (capitalization != null) {
                stringBuilder.append(gregorianCalendar.get(7));
                ++n2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "J");
            if (capitalization != null) {
                long l2 = timestamp.getTime() - JULIAN_EPOCH;
                long l3 = (long)Math.floor(l2 / 86400000L);
                stringBuilder.append(l3);
                ++n2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "HH24");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("00").format(gregorianCalendar.get(11)));
                n2 += 4;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "HH12");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("00").format(gregorianCalendar.get(10)));
                n2 += 4;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "HH");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("00").format(gregorianCalendar.get(10)));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "MI");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("00").format(gregorianCalendar.get(12)));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "SSSSS");
            if (capitalization != null) {
                int n3 = gregorianCalendar.get(11) * 60 * 60;
                n3 += gregorianCalendar.get(12) * 60;
                stringBuilder.append(n3 += gregorianCalendar.get(13));
                n2 += 5;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "SS");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("00").format(gregorianCalendar.get(13)));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "FF1", "FF2", "FF3", "FF4", "FF5", "FF6", "FF7", "FF8", "FF9");
            if (capitalization != null) {
                int n4 = Integer.parseInt(string.substring(n2 + 2, n2 + 3));
                bl3 = (int)((double)gregorianCalendar.get(14) * Math.pow(10.0, n4 - 3));
                stringBuilder.append((int)(bl3 ? '\u0001' : '\u0000'));
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "FF");
            if (capitalization != null) {
                stringBuilder.append(gregorianCalendar.get(14) * 1000);
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "TZR");
            if (capitalization != null) {
                TimeZone timeZone = TimeZone.getDefault();
                stringBuilder.append(timeZone.getID());
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "TZD");
            if (capitalization != null) {
                TimeZone timeZone = TimeZone.getDefault();
                bl3 = timeZone.inDaylightTime(new java.util.Date());
                stringBuilder.append(timeZone.getDisplayName(bl3, 0));
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "IW", "WW");
            if (capitalization != null) {
                stringBuilder.append(gregorianCalendar.get(3));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "W");
            if (capitalization != null) {
                int n5 = (int)(1.0 + Math.floor(gregorianCalendar.get(5) / 7));
                stringBuilder.append(n5);
                ++n2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "Y,YYY");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("#,###").format(ToChar.getYear(gregorianCalendar)));
                n2 += 5;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "SYYYY");
            if (capitalization != null) {
                if (gregorianCalendar.get(0) == 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(new DecimalFormat("0000").format(ToChar.getYear(gregorianCalendar)));
                n2 += 5;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "YYYY", "IYYY", "RRRR");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("0000").format(ToChar.getYear(gregorianCalendar)));
                n2 += 4;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "YYY", "IYY");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("000").format(ToChar.getYear(gregorianCalendar) % 1000));
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "YY", "IY", "RR");
            if (capitalization != null) {
                stringBuilder.append(new DecimalFormat("00").format(ToChar.getYear(gregorianCalendar) % 100));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "I", "Y");
            if (capitalization != null) {
                stringBuilder.append(ToChar.getYear(gregorianCalendar) % 10);
                ++n2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "MONTH");
            if (capitalization != null) {
                String string9 = new SimpleDateFormat("MMMM").format(timestamp);
                if (bl2) {
                    string9 = StringUtils.pad(string9, "September".length(), " ", true);
                }
                stringBuilder.append(capitalization.apply(string9));
                n2 += 5;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "MON");
            if (capitalization != null) {
                String string10 = new SimpleDateFormat("MMM").format(timestamp);
                stringBuilder.append(capitalization.apply(string10));
                n2 += 3;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "MM");
            if (capitalization != null) {
                stringBuilder.append(String.format("%02d", gregorianCalendar.get(2) + 1));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "RM");
            if (capitalization != null) {
                int n6 = gregorianCalendar.get(2) + 1;
                stringBuilder.append(capitalization.apply(ToChar.toRomanNumeral(n6)));
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "Q");
            if (capitalization != null) {
                int n7 = (int)(1.0 + Math.floor(gregorianCalendar.get(2) / 3));
                stringBuilder.append(n7);
                ++n2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "X");
            if (capitalization != null) {
                char c2 = DecimalFormatSymbols.getInstance().getDecimalSeparator();
                stringBuilder.append(c2);
                ++n2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "FM");
            if (capitalization != null) {
                bl2 = !bl2;
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "FX");
            if (capitalization != null) {
                n2 += 2;
                continue;
            }
            capitalization = ToChar.containsAt(string, n2, "\"");
            if (capitalization != null) {
                ++n2;
                while (n2 < string.length()) {
                    char c3 = string.charAt(n2);
                    if (c3 == '\"') {
                        ++n2;
                        continue block0;
                    }
                    stringBuilder.append(c3);
                    ++n2;
                }
                continue;
            }
            if (string.charAt(n2) == '-' || string.charAt(n2) == '/' || string.charAt(n2) == ',' || string.charAt(n2) == '.' || string.charAt(n2) == ';' || string.charAt(n2) == ':' || string.charAt(n2) == ' ') {
                stringBuilder.append(string.charAt(n2));
                ++n2;
                continue;
            }
            throw DbException.get(90010, string);
        }
        return stringBuilder.toString();
    }

    private static int getYear(Calendar calendar) {
        int n2 = calendar.get(1);
        if (calendar.get(0) == 0) {
            --n2;
        }
        return n2;
    }

    private static Capitalization containsAt(String string, int n2, String ... stringArray) {
        for (String string2 : stringArray) {
            if (n2 + string2.length() > string.length()) continue;
            boolean bl2 = true;
            Boolean bl3 = null;
            Boolean bl4 = null;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2;
                char c3 = string.charAt(n2 + i2);
                if (c3 != (c2 = string2.charAt(i2)) && Character.toUpperCase(c3) != Character.toUpperCase(c2)) {
                    bl2 = false;
                    break;
                }
                if (!Character.isLetter(c3)) continue;
                if (bl3 == null) {
                    bl3 = Character.isUpperCase(c3);
                    continue;
                }
                if (bl4 != null) continue;
                bl4 = Character.isUpperCase(c3);
            }
            if (!bl2) continue;
            return Capitalization.toCapitalization(bl3, bl4);
        }
        return null;
    }

    static {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.ENGLISH);
        gregorianCalendar.setGregorianChange(new Date(Long.MAX_VALUE));
        gregorianCalendar.clear();
        gregorianCalendar.set(4713, 0, 1, 0, 0, 0);
        gregorianCalendar.set(0, 0);
        JULIAN_EPOCH = gregorianCalendar.getTimeInMillis();
    }

    private static enum Capitalization {
        UPPERCASE,
        LOWERCASE,
        CAPITALIZE;


        public static Capitalization toCapitalization(Boolean bl2, Boolean bl3) {
            if (bl2 == null) {
                return CAPITALIZE;
            }
            if (bl3 == null) {
                return bl2 != false ? UPPERCASE : LOWERCASE;
            }
            if (bl2.booleanValue()) {
                return bl3 != false ? UPPERCASE : CAPITALIZE;
            }
            return LOWERCASE;
        }

        public String apply(String string) {
            if (string == null || string.isEmpty()) {
                return string;
            }
            switch (this) {
                case UPPERCASE: {
                    return string.toUpperCase();
                }
                case LOWERCASE: {
                    return string.toLowerCase();
                }
                case CAPITALIZE: {
                    return Character.toUpperCase(string.charAt(0)) + (string.length() > 1 ? string.toLowerCase().substring(1) : "");
                }
            }
            throw new IllegalArgumentException("Unknown capitalization strategy: " + (Object)((Object)this));
        }
    }
}

