/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.SoftReference;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import org.h2.engine.Constants;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.util.New;
import org.h2.util.StatementBuilder;

public class StringUtils {
    private static SoftReference<String[]> softCache;
    private static long softCacheCreated;
    private static final char[] HEX;
    private static final int[] HEX_DECODE;
    private static final int TO_UPPER_CACHE_LENGTH = 2048;
    private static final int TO_UPPER_CACHE_MAX_ENTRY_LENGTH = 64;
    private static final String[][] TO_UPPER_CACHE;

    private StringUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCache() {
        String[] stringArray;
        if (softCache != null && (stringArray = softCache.get()) != null) {
            return stringArray;
        }
        long l2 = System.currentTimeMillis();
        if (softCacheCreated != 0L && l2 - softCacheCreated < 5000L) {
            return null;
        }
        try {
            stringArray = new String[SysProperties.OBJECT_CACHE_SIZE];
            softCache = new SoftReference<String[]>(stringArray);
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            softCacheCreated = System.currentTimeMillis();
        }
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    public static String toUpperEnglish(String string) {
        if (string.length() > 64) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        int n2 = string.hashCode() & 0x7FF;
        String[] stringArray = TO_UPPER_CACHE[n2];
        if (stringArray != null && stringArray[0].equals(string)) {
            return stringArray[1];
        }
        String string2 = string.toUpperCase(Locale.ENGLISH);
        stringArray = new String[]{string, string2};
        StringUtils.TO_UPPER_CACHE[n2] = stringArray;
        return string2;
    }

    public static String toLowerEnglish(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.substring(0, string2.length()).equalsIgnoreCase(string2);
    }

    public static String quoteStringSQL(String string) {
        if (string == null) {
            return "NULL";
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 2);
        stringBuilder.append('\'');
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\'') {
                stringBuilder.append(c2);
            } else if (c2 < ' ' || c2 > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(string)) + ")";
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    public static String javaEncode(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block8: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block8;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block8;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block8;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block8;
                }
                default: {
                    int n3 = c2 & 0xFFFF;
                    if (n3 >= 32 && n3 < 128) {
                        stringBuilder.append(c2);
                        continue block8;
                    }
                    stringBuilder.append("\\u");
                    String string2 = Integer.toHexString(n3);
                    for (int i3 = string2.length(); i3 < 4; ++i3) {
                        stringBuilder.append('0');
                    }
                    stringBuilder.append(string2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String addAsterisk(String string, int n2) {
        if (string != null) {
            n2 = Math.min(n2, string.length());
            string = string.substring(0, n2) + "[*]" + string.substring(n2);
        }
        return string;
    }

    private static DbException getFormatException(String string, int n2) {
        return DbException.get(90095, StringUtils.addAsterisk(string, n2));
    }

    public static String javaDecode(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block17: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                if (i2 + 1 >= string.length()) {
                    throw StringUtils.getFormatException(string, i2);
                }
                c2 = string.charAt(++i2);
                switch (c2) {
                    case 't': {
                        stringBuilder.append('\t');
                        continue block17;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block17;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block17;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block17;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block17;
                    }
                    case '#': {
                        stringBuilder.append('#');
                        continue block17;
                    }
                    case '=': {
                        stringBuilder.append('=');
                        continue block17;
                    }
                    case ':': {
                        stringBuilder.append(':');
                        continue block17;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block17;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block17;
                    }
                    case 'u': {
                        try {
                            c2 = (char)Integer.parseInt(string.substring(i2 + 1, i2 + 5), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw StringUtils.getFormatException(string, i2);
                        }
                        i2 += 4;
                        stringBuilder.append(c2);
                        continue block17;
                    }
                    default: {
                        if (c2 >= '0' && c2 <= '9') {
                            try {
                                c2 = (char)Integer.parseInt(string.substring(i2, i2 + 3), 8);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw StringUtils.getFormatException(string, i2);
                            }
                            i2 += 2;
                            stringBuilder.append(c2);
                            continue block17;
                        }
                        throw StringUtils.getFormatException(string, i2);
                    }
                }
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String quoteJavaString(String string) {
        if (string == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(string) + "\"";
    }

    public static String quoteJavaStringArray(String[] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new String[]{");
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(StringUtils.quoteJavaString(string));
        }
        return statementBuilder.append('}').toString();
    }

    public static String quoteJavaIntArray(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StatementBuilder statementBuilder = new StatementBuilder("new int[]{");
        for (int n2 : nArray) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(n2);
        }
        return statementBuilder.append('}').toString();
    }

    public static String enclose(String string) {
        if (string.startsWith("(")) {
            return string;
        }
        return "(" + string + ")";
    }

    public static String unEnclose(String string) {
        if (string.startsWith("(") && string.endsWith(")")) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            throw DbException.convert(exception);
        }
    }

    public static String urlDecode(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '+') {
                byArray[n3++] = 32;
                continue;
            }
            if (c2 == '%') {
                byArray[n3++] = (byte)Integer.parseInt(string.substring(i2 + 1, i2 + 3), 16);
                i2 += 2;
                continue;
            }
            if (SysProperties.CHECK && (c2 > '\u007f' || c2 < ' ')) {
                throw new IllegalArgumentException("Unexpected char " + c2 + " decoding " + string);
            }
            byArray[n3++] = (byte)c2;
        }
        String string2 = new String(byArray, 0, n3, Constants.UTF8);
        return string2;
    }

    public static String[] arraySplit(String string, char c2, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return new String[0];
        }
        ArrayList<String> arrayList = New.arrayList();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == c2) {
                String string2 = stringBuilder.toString();
                arrayList.add(bl2 ? string2.trim() : string2);
                stringBuilder.setLength(0);
                continue;
            }
            if (c3 == '\\' && i2 < n2 - 1) {
                stringBuilder.append(string.charAt(++i2));
                continue;
            }
            stringBuilder.append(c3);
        }
        String string3 = stringBuilder.toString();
        arrayList.add(bl2 ? string3.trim() : string3);
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String arrayCombine(String[] stringArray, char c2) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (String string : stringArray) {
            statementBuilder.appendExceptFirst(String.valueOf(c2));
            if (string == null) {
                string = "";
            }
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c3 = string.charAt(i2);
                if (c3 == '\\' || c3 == c2) {
                    statementBuilder.append('\\');
                }
                statementBuilder.append(c3);
            }
        }
        return statementBuilder.toString();
    }

    public static String xmlAttr(String string, String string2) {
        return " " + string + "=\"" + StringUtils.xmlText(string2) + "\"";
    }

    public static String xmlNode(String string, String string2, String string3) {
        return StringUtils.xmlNode(string, string2, string3, true);
    }

    public static String xmlNode(String string, String string2, String string3, boolean bl2) {
        String string4;
        String string5 = string4 = string2 == null ? string : string + string2;
        if (string3 == null) {
            return "<" + string4 + "/>\n";
        }
        if (bl2 && string3.indexOf(10) >= 0) {
            string3 = "\n" + StringUtils.indent(string3);
        }
        return "<" + string4 + ">" + string3 + "</" + string + ">\n";
    }

    public static String indent(String string) {
        return StringUtils.indent(string, 4, true);
    }

    public static String indent(String string, int n2, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + n2);
        int n3 = 0;
        while (n3 < string.length()) {
            int n4;
            for (n4 = 0; n4 < n2; ++n4) {
                stringBuilder.append(' ');
            }
            n4 = string.indexOf(10, n3);
            n4 = n4 < 0 ? string.length() : n4 + 1;
            stringBuilder.append(string.substring(n3, n4));
            n3 = n4;
        }
        if (bl2 && !string.endsWith("\n")) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String xmlComment(String string) {
        int n2 = 0;
        while ((n2 = string.indexOf("--", n2)) >= 0) {
            string = string.substring(0, n2 + 1) + " " + string.substring(n2 + 1);
        }
        if (string.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.indent(string) + "-->\n";
        }
        return "<!-- " + string + " -->\n";
    }

    public static String xmlCData(String string) {
        if (string.contains("]]>")) {
            return StringUtils.xmlText(string);
        }
        boolean bl2 = string.endsWith("\n");
        string = "<![CDATA[" + string + "]]>";
        return bl2 ? string + "\n" : string;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String string) {
        return StringUtils.xmlText(string, false);
    }

    public static String xmlText(String string, boolean bl2) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block9;
                }
                case '\'': {
                    stringBuilder.append("&apos;");
                    continue block9;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block9;
                }
                case '\n': 
                case '\r': {
                    if (bl2) {
                        stringBuilder.append("&#x").append(Integer.toHexString(c2)).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c2);
                    continue block9;
                }
                case '\t': {
                    stringBuilder.append(c2);
                    continue block9;
                }
                default: {
                    if (c2 < ' ' || c2 > '\u007f') {
                        stringBuilder.append("&#x").append(Integer.toHexString(c2)).append(';');
                        continue block9;
                    }
                    stringBuilder.append(c2);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String replaceAll(String string, String string2, String string3) {
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() - string2.length() + string3.length());
        int n3 = 0;
        do {
            stringBuilder.append(string.substring(n3, n2)).append(string3);
        } while ((n2 = string.indexOf(string2, n3 = n2 + string2.length())) >= 0);
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static String quoteIdentifier(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 + 2);
        stringBuilder.append('\"');
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuilder.append(c2);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.append('\"').toString();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String quoteRemarkSQL(String string) {
        string = StringUtils.replaceAll(string, "*/", "++/");
        return StringUtils.replaceAll(string, "/*", "/++");
    }

    public static String pad(String string, int n2, String string2, boolean bl2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 < string.length()) {
            return string.substring(0, n2);
        }
        if (n2 == string.length()) {
            return string;
        }
        char c2 = string2 == null || string2.length() == 0 ? (char)' ' : (char)string2.charAt(0);
        StringBuilder stringBuilder = new StringBuilder(n2);
        n2 -= string.length();
        if (bl2) {
            stringBuilder.append(string);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(c2);
        }
        if (!bl2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static char[] cloneCharArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n2 = cArray.length;
        if (n2 == 0) {
            return cArray;
        }
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        return cArray2;
    }

    public static String trim(String string, boolean bl2, boolean bl3, String string2) {
        int n2;
        int n3;
        char c2;
        char c3 = c2 = string2 == null || string2.length() < 1 ? (char)' ' : (char)string2.charAt(0);
        if (bl2) {
            n3 = string.length();
            for (n2 = 0; n2 < n3 && string.charAt(n2) == c2; ++n2) {
            }
            String string3 = string = n2 == 0 ? string : string.substring(n2);
        }
        if (bl3) {
            for (n2 = n3 = string.length() - 1; n2 >= 0 && string.charAt(n2) == c2; --n2) {
            }
            string = n2 == n3 ? string : string.substring(0, n2 + 1);
        }
        return string;
    }

    public static String cache(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n2 = string.hashCode();
        String[] stringArray = StringUtils.getCache();
        if (stringArray != null) {
            int n3 = n2 & SysProperties.OBJECT_CACHE_SIZE - 1;
            String string2 = stringArray[n3];
            if (string2 != null && string.equals(string2)) {
                return string2;
            }
            stringArray[n3] = string;
        }
        return string;
    }

    public static String fromCacheOrNew(String string) {
        if (!SysProperties.OBJECT_CACHE) {
            return string;
        }
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return "";
        }
        int n2 = string.hashCode();
        String[] stringArray = StringUtils.getCache();
        int n3 = n2 & SysProperties.OBJECT_CACHE_SIZE - 1;
        if (stringArray == null) {
            return string;
        }
        String string2 = stringArray[n3];
        if (string2 != null && string.equals(string2)) {
            return string2;
        }
        stringArray[n3] = string = new String(string);
        return string;
    }

    public static void clearCache() {
        softCache = new SoftReference<Object>(null);
    }

    public static byte[] convertHexToBytes(String string) {
        int n2 = string.length();
        if (n2 % 2 != 0) {
            throw DbException.get(90003, string);
        }
        byte[] byArray = new byte[n2 /= 2];
        int n3 = 0;
        int[] nArray = HEX_DECODE;
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = nArray[string.charAt(i2 + i2)] << 4 | nArray[string.charAt(i2 + i2 + 1)];
                n3 |= n4;
                byArray[i2] = (byte)n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw DbException.get(90004, string);
        }
        if ((n3 & 0xFFFFFF00) != 0) {
            throw DbException.get(90004, string);
        }
        return byArray;
    }

    public static String convertBytesToHex(byte[] byArray) {
        return StringUtils.convertBytesToHex(byArray, byArray.length);
    }

    public static String convertBytesToHex(byte[] byArray, int n2) {
        char[] cArray = new char[n2 + n2];
        char[] cArray2 = HEX;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            cArray[i2 + i2] = cArray2[n3 >> 4];
            cArray[i2 + i2 + 1] = cArray2[n3 & 0xF];
        }
        return new String(cArray);
    }

    public static boolean isNumber(String string) {
        if (string.length() == 0) {
            return false;
        }
        for (char c2 : string.toCharArray()) {
            if (Character.isDigit(c2)) continue;
            return false;
        }
        return true;
    }

    public static void appendZeroPadded(StringBuilder stringBuilder, int n2, long l2) {
        if (n2 == 2) {
            if (l2 < 10L) {
                stringBuilder.append('0');
            }
            stringBuilder.append(l2);
        } else {
            String string = Long.toString(l2);
            n2 -= string.length();
            while (n2 > 0) {
                stringBuilder.append('0');
                --n2;
            }
            stringBuilder.append(string);
        }
    }

    public static String escapeMetaDataPattern(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        return StringUtils.replaceAll(string, "\\", "\\\\");
    }

    static {
        int n2;
        softCache = new SoftReference<Object>(null);
        HEX = "0123456789abcdef".toCharArray();
        HEX_DECODE = new int[103];
        TO_UPPER_CACHE = new String[2048][];
        for (n2 = 0; n2 < HEX_DECODE.length; ++n2) {
            StringUtils.HEX_DECODE[n2] = -1;
        }
        for (n2 = 0; n2 <= 9; ++n2) {
            StringUtils.HEX_DECODE[n2 + 48] = n2;
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            int n3 = n2 + 10;
            StringUtils.HEX_DECODE[n2 + 65] = n3;
            StringUtils.HEX_DECODE[n2 + 97] = n3;
        }
    }
}

