/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Profiler
implements Runnable {
    private static Instrumentation instrumentation;
    private static final String LINE_SEPARATOR;
    private static final int MAX_ELEMENTS = 1000;
    public int interval = 2;
    public int depth = 48;
    public boolean paused;
    public boolean sumClasses;
    public boolean sumMethods;
    private int pid;
    private final String[] ignoreLines = "java,sun,com.sun.,com.google.common.,com.mongodb.,org.bson.,".split(",");
    private final String[] ignorePackages = "java,sun,com.sun.,com.google.common.,com.mongodb.,org.bson".split(",");
    private final String[] ignoreThreads = "java.lang.Object.wait,java.lang.Thread.dumpThreads,java.lang.Thread.getThreads,java.lang.Thread.sleep,java.lang.UNIXProcess.waitForProcessExit,java.net.PlainDatagramSocketImpl.receive0,java.net.PlainSocketImpl.accept,java.net.PlainSocketImpl.socketAccept,java.net.SocketInputStream.socketRead,java.net.SocketOutputStream.socketWrite,org.eclipse.jetty.io.nio.SelectorManager$SelectSet.doSelect,sun.awt.windows.WToolkit.eventLoop,sun.misc.Unsafe.park,sun.nio.ch.EPollArrayWrapper.epollWait,sun.nio.ch.KQueueArrayWrapper.kevent0,sun.nio.ch.ServerSocketChannelImpl.accept,dalvik.system.VMStack.getThreadStackTrace,dalvik.system.NativeStart.run".split(",");
    private volatile boolean stop;
    private final HashMap<String, Integer> counts = new HashMap();
    private final HashMap<String, Integer> summary = new HashMap();
    private int minCount = 1;
    private int total;
    private Thread thread;
    private long start;
    private long time;
    private int threadDumps;

    public static void premain(String string, Instrumentation instrumentation) {
        Profiler.instrumentation = instrumentation;
    }

    public static Instrumentation getInstrumentation() {
        return instrumentation;
    }

    public static void main(String ... stringArray) {
        new Profiler().run(stringArray);
    }

    private void run(String ... stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Show profiling data");
            System.out.println("Usage: java " + this.getClass().getName() + " <pid> | <stackTraceFileNames>");
            System.out.println("Processes:");
            String string = Profiler.exec("jps", "-l");
            System.out.println(string);
            return;
        }
        this.start = System.currentTimeMillis();
        if (stringArray[0].matches("\\d+")) {
            this.pid = Integer.parseInt(stringArray[0]);
            long l2 = 0L;
            while (true) {
                this.tick();
                long l3 = System.currentTimeMillis();
                if (l3 - l2 <= 5000L) continue;
                this.time = System.currentTimeMillis() - this.start;
                System.out.println(this.getTopTraces(3));
                l2 = l3;
            }
        }
        try {
            for (String string : stringArray) {
                String string2;
                if (string.startsWith("-")) {
                    if ("-classes".equals(string)) {
                        this.sumClasses = true;
                        continue;
                    }
                    if ("-methods".equals(string)) {
                        this.sumMethods = true;
                        continue;
                    }
                    if ("-packages".equals(stringArray)) {
                        this.sumClasses = false;
                        this.sumMethods = false;
                        continue;
                    }
                    throw new IllegalArgumentException(string);
                }
                String string3 = string;
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string3), "CP1252");
                LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
                while ((string2 = lineNumberReader.readLine()) != null) {
                    if (!string2.startsWith("Full thread dump")) continue;
                    ++this.threadDumps;
                }
                ((Reader)inputStreamReader).close();
                inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(string3), "CP1252");
                lineNumberReader = new LineNumberReader(inputStreamReader);
                this.processList(Profiler.readStackTrace(lineNumberReader));
                ((Reader)inputStreamReader).close();
            }
            System.out.println(this.getTopTraces(5));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static List<Object[]> getRunnableStackTraces() {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : map.entrySet()) {
            StackTraceElement[] stackTraceElementArray;
            Thread thread = entry.getKey();
            if (thread.getState() != Thread.State.RUNNABLE || (stackTraceElementArray = entry.getValue()) == null || stackTraceElementArray.length == 0) continue;
            arrayList.add(stackTraceElementArray);
        }
        return arrayList;
    }

    private static List<Object[]> readRunnableStackTraces(int n2) {
        try {
            String string = Profiler.exec("jstack", "" + n2);
            LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
            return Profiler.readStackTrace(lineNumberReader);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static List<Object[]> readStackTrace(LineNumberReader lineNumberReader) throws IOException {
        String string;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while ((string = lineNumberReader.readLine()) != null) {
            if (!string.startsWith("\"")) continue;
            string = lineNumberReader.readLine();
            if (string == null) break;
            if (!(string = string.trim()).startsWith("java.lang.Thread.State: RUNNABLE")) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while ((string = lineNumberReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("- ")) continue;
                if (!string.startsWith("at ")) break;
                string = string.substring(3).trim();
                arrayList2.add(string);
            }
            if (arrayList2.size() <= 0) continue;
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    private static String exec(String ... stringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        try {
            Process process = Runtime.getRuntime().exec(stringArray);
            Profiler.copyInThread(process.getInputStream(), byteArrayOutputStream2);
            Profiler.copyInThread(process.getErrorStream(), byteArrayOutputStream);
            process.waitFor();
            String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
            if (string.length() > 0) {
                throw new RuntimeException(string);
            }
            String string2 = new String(byteArrayOutputStream2.toByteArray(), "UTF-8");
            return string2;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static void copyInThread(final InputStream inputStream, final OutputStream outputStream) {
        new Thread("Profiler stream copy"){

            @Override
            public void run() {
                byte[] byArray = new byte[4096];
                try {
                    int n2;
                    while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
                        outputStream.write(byArray, 0, n2);
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }.start();
    }

    public Profiler startCollecting() {
        this.thread = new Thread((Runnable)this, "Profiler");
        this.thread.setDaemon(true);
        this.thread.start();
        return this;
    }

    public Profiler stopCollecting() {
        this.stop = true;
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        return this;
    }

    @Override
    public void run() {
        this.start = System.currentTimeMillis();
        while (!this.stop) {
            try {
                this.tick();
            }
            catch (Throwable throwable) {
                // empty catch block
                break;
            }
        }
        this.time = System.currentTimeMillis() - this.start;
    }

    private void tick() {
        if (this.interval > 0) {
            if (this.paused) {
                return;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List<Object[]> list = this.pid != 0 ? Profiler.readRunnableStackTraces(this.pid) : Profiler.getRunnableStackTraces();
        ++this.threadDumps;
        this.processList(list);
    }

    private void processList(List<Object[]> list) {
        for (Object[] objectArray : list) {
            if (Profiler.startsWithAny(objectArray[0].toString(), this.ignoreThreads)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string = null;
            boolean bl2 = false;
            int n2 = 0;
            for (int i2 = 0; i2 < objectArray.length && n2 < this.depth; ++i2) {
                String string2 = objectArray[i2].toString();
                if (string2.equals(string) || Profiler.startsWithAny(string2, this.ignoreLines)) continue;
                string = string2;
                stringBuilder.append("at ").append(string2).append(LINE_SEPARATOR);
                if (!bl2 && !Profiler.startsWithAny(string2, this.ignorePackages)) {
                    int n3;
                    int n4;
                    bl2 = true;
                    for (n4 = 0; n4 < string2.length() && (n3 = string2.charAt(n4)) != 40 && !Character.isUpperCase((char)n3); ++n4) {
                    }
                    if (n4 > 0 && string2.charAt(n4 - 1) == '.') {
                        --n4;
                    }
                    if (this.sumClasses) {
                        n3 = string2.indexOf(46, n4 + 1);
                        int n5 = n4 = n3 >= 0 ? n3 : n4;
                    }
                    if (this.sumMethods) {
                        n3 = string2.indexOf(40, n4 + 1);
                        n4 = n3 >= 0 ? n3 : n4;
                    }
                    String string3 = string2.substring(0, n4);
                    Profiler.increment(this.summary, string3, 0);
                }
                ++n2;
            }
            if (stringBuilder.length() <= 0) continue;
            this.minCount = Profiler.increment(this.counts, stringBuilder.toString().trim(), this.minCount);
            ++this.total;
        }
    }

    private static boolean startsWithAny(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (string2.length() <= 0 || !string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private static int increment(HashMap<String, Integer> hashMap, String string, int n2) {
        Integer n3 = hashMap.get(string);
        if (n3 == null) {
            hashMap.put(string, 1);
        } else {
            hashMap.put(string, n3 + 1);
        }
        while (hashMap.size() > 1000) {
            Iterator<Map.Entry<String, Integer>> iterator = hashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry = iterator.next();
                if (entry.getValue() > n2) continue;
                iterator.remove();
            }
            if (hashMap.size() <= 1000) continue;
            ++n2;
        }
        return n2;
    }

    public String getTop(int n2) {
        this.stopCollecting();
        return this.getTopTraces(n2);
    }

    private String getTopTraces(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Profiler: top ").append(n2).append(" stack trace(s) of ");
        if (this.time > 0L) {
            stringBuilder.append(" of ").append(this.time).append(" ms");
        }
        if (this.threadDumps > 0) {
            stringBuilder.append(" of ").append(this.threadDumps).append(" thread dumps");
        }
        stringBuilder.append(":").append(LINE_SEPARATOR);
        if (this.counts.size() == 0) {
            stringBuilder.append("(none)").append(LINE_SEPARATOR);
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(this.counts);
        Profiler.appendTop(stringBuilder, hashMap, n2, this.total, false);
        stringBuilder.append("summary:").append(LINE_SEPARATOR);
        hashMap = new HashMap<String, Integer>(this.summary);
        Profiler.appendTop(stringBuilder, hashMap, n2, this.total, true);
        stringBuilder.append('.');
        return stringBuilder.toString();
    }

    private static void appendTop(StringBuilder stringBuilder, HashMap<String, Integer> hashMap, int n2, int n3, boolean bl2) {
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6 = 0;
            Map.Entry<String, Integer> entry = null;
            for (Map.Entry<String, Integer> entry2 : hashMap.entrySet()) {
                if (entry2.getValue() <= n6) continue;
                entry = entry2;
                n6 = entry2.getValue();
            }
            if (entry == null) break;
            hashMap.remove(entry.getKey());
            if (++n4 >= n2) {
                if (entry.getValue() < n5) break;
                n5 = entry.getValue();
            }
            int n7 = entry.getValue();
            int n8 = 100 * n7 / Math.max(n3, 1);
            if (bl2) {
                if (n8 <= 1) continue;
                stringBuilder.append(n8).append("%: ").append(entry.getKey()).append(LINE_SEPARATOR);
                continue;
            }
            stringBuilder.append(n7).append('/').append(n3).append(" (").append(n8).append("%):").append(LINE_SEPARATOR).append(entry.getKey()).append(LINE_SEPARATOR);
        }
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    }
}

