/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import org.h2.message.DbException;

public class Permutations<T> {
    private final T[] in;
    private final T[] out;
    private final int n;
    private final int m;
    private final int[] index;
    private boolean hasNext = true;

    private Permutations(T[] TArray, T[] TArray2, int n2) {
        this.n = TArray.length;
        this.m = n2;
        if (this.n < n2 || n2 < 0) {
            DbException.throwInternalError("n < m or m < 0");
        }
        this.in = TArray;
        this.out = TArray2;
        this.index = new int[this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            this.index[i2] = i2;
        }
        this.reverseAfter(n2 - 1);
    }

    public static <T> Permutations<T> create(T[] TArray, T[] TArray2) {
        return new Permutations<T>(TArray, TArray2, TArray.length);
    }

    public static <T> Permutations<T> create(T[] TArray, T[] TArray2, int n2) {
        return new Permutations<T>(TArray, TArray2, n2);
    }

    private void moveIndex() {
        int n2;
        int n3 = this.rightmostDip();
        if (n3 < 0) {
            this.hasNext = false;
            return;
        }
        int n4 = n3 + 1;
        for (n2 = n3 + 2; n2 < this.n; ++n2) {
            if (this.index[n2] >= this.index[n4] || this.index[n2] <= this.index[n3]) continue;
            n4 = n2;
        }
        n2 = this.index[n3];
        this.index[n3] = this.index[n4];
        this.index[n4] = n2;
        if (this.m - 1 > n3) {
            this.reverseAfter(n3);
            this.reverseAfter(this.m - 1);
        }
    }

    private int rightmostDip() {
        for (int i2 = this.n - 2; i2 >= 0; --i2) {
            if (this.index[i2] >= this.index[i2 + 1]) continue;
            return i2;
        }
        return -1;
    }

    private void reverseAfter(int n2) {
        int n3 = n2 + 1;
        for (int i2 = this.n - 1; n3 < i2; ++n3, --i2) {
            int n4 = this.index[n3];
            this.index[n3] = this.index[i2];
            this.index[i2] = n4;
        }
    }

    public boolean next() {
        if (!this.hasNext) {
            return false;
        }
        for (int i2 = 0; i2 < this.m; ++i2) {
            this.out[i2] = this.in[this.index[i2]];
        }
        this.moveIndex();
        return true;
    }
}

