/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.IOException;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.h2.engine.SysProperties;
import org.h2.message.DbException;
import org.h2.security.CipherFactory;

public class NetUtils {
    private static final int CACHE_MILLIS = 1000;
    private static InetAddress cachedBindAddress;
    private static String cachedLocalAddress;
    private static long cachedLocalAddressTime;

    private NetUtils() {
    }

    public static Socket createLoopbackSocket(int n2, boolean bl2) throws IOException {
        InetAddress inetAddress = NetUtils.getBindAddress();
        if (inetAddress == null) {
            inetAddress = InetAddress.getLocalHost();
        }
        try {
            return NetUtils.createSocket(NetUtils.getHostAddress(inetAddress), n2, bl2);
        }
        catch (IOException iOException) {
            try {
                return NetUtils.createSocket("localhost", n2, bl2);
            }
            catch (IOException iOException2) {
                throw iOException;
            }
        }
    }

    private static String getHostAddress(InetAddress inetAddress) {
        String string = inetAddress.getHostAddress();
        if (inetAddress instanceof Inet6Address && string.indexOf(58) >= 0 && !string.startsWith("[")) {
            string = "[" + string + "]";
        }
        return string;
    }

    public static Socket createSocket(String string, int n2, boolean bl2) throws IOException {
        int n3 = n2;
        int n4 = string.startsWith("[") ? string.indexOf(93) : 0;
        int n5 = string.indexOf(58, n4);
        if (n5 >= 0) {
            n3 = Integer.decode(string.substring(n5 + 1));
            string = string.substring(0, n5);
        }
        InetAddress inetAddress = InetAddress.getByName(string);
        return NetUtils.createSocket(inetAddress, n3, bl2);
    }

    public static Socket createSocket(InetAddress inetAddress, int n2, boolean bl2) throws IOException {
        long l2 = System.currentTimeMillis();
        int n3 = 0;
        while (true) {
            try {
                if (bl2) {
                    return CipherFactory.createSocket(inetAddress, n2);
                }
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(inetAddress, n2), SysProperties.SOCKET_CONNECT_TIMEOUT);
                return socket;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() - l2 >= (long)SysProperties.SOCKET_CONNECT_TIMEOUT) {
                    throw iOException;
                }
                if (n3 >= SysProperties.SOCKET_CONNECT_RETRY) {
                    throw iOException;
                }
                try {
                    long l3 = Math.min(256, n3 * n3);
                    Thread.sleep(l3);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n3;
                continue;
            }
            break;
        }
    }

    public static ServerSocket createServerSocket(int n2, boolean bl2) {
        try {
            return NetUtils.createServerSocketTry(n2, bl2);
        }
        catch (Exception exception) {
            return NetUtils.createServerSocketTry(n2, bl2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getBindAddress() throws UnknownHostException {
        String string = SysProperties.BIND_ADDRESS;
        if (string == null || string.length() == 0) {
            return null;
        }
        Class<NetUtils> clazz = NetUtils.class;
        synchronized (NetUtils.class) {
            if (cachedBindAddress == null) {
                cachedBindAddress = InetAddress.getByName(string);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cachedBindAddress;
        }
    }

    private static ServerSocket createServerSocketTry(int n2, boolean bl2) {
        try {
            InetAddress inetAddress = NetUtils.getBindAddress();
            if (bl2) {
                return CipherFactory.createServerSocket(n2, inetAddress);
            }
            if (inetAddress == null) {
                return new ServerSocket(n2);
            }
            return new ServerSocket(n2, 0, inetAddress);
        }
        catch (BindException bindException) {
            throw DbException.get(90061, bindException, "" + n2, bindException.toString());
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "port: " + n2 + " ssl: " + bl2);
        }
    }

    public static boolean isLocalAddress(Socket socket) throws UnknownHostException {
        InetAddress inetAddress = socket.getInetAddress();
        if (inetAddress.isLoopbackAddress()) {
            return true;
        }
        InetAddress inetAddress2 = InetAddress.getLocalHost();
        String string = inetAddress2.getHostAddress();
        for (InetAddress inetAddress3 : InetAddress.getAllByName(string)) {
            if (!inetAddress.equals(inetAddress3)) continue;
            return true;
        }
        return false;
    }

    public static ServerSocket closeSilently(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized String getLocalAddress() {
        String string;
        long l2 = System.currentTimeMillis();
        if (cachedLocalAddress != null && cachedLocalAddressTime + 1000L > l2) {
            return cachedLocalAddress;
        }
        InetAddress inetAddress = null;
        boolean bl2 = false;
        try {
            inetAddress = NetUtils.getBindAddress();
            if (inetAddress == null) {
                bl2 = true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (bl2) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                throw DbException.convert(unknownHostException);
            }
        }
        String string2 = string = inetAddress == null ? "localhost" : NetUtils.getHostAddress(inetAddress);
        if (string.equals("127.0.0.1")) {
            string = "localhost";
        }
        cachedLocalAddress = string;
        cachedLocalAddressTime = l2;
        return string;
    }

    public static String getHostName(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostName();
        }
        catch (Exception exception) {
            return "unknown";
        }
    }
}

