/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Random;

public class MathUtils {
    static SecureRandom cachedSecureRandom;
    static volatile boolean seeded;
    private static final Random RANDOM;

    private MathUtils() {
    }

    public static int roundUpInt(int n2, int n3) {
        return n2 + n3 - 1 & -n3;
    }

    public static long roundUpLong(long l2, long l3) {
        return l2 + l3 - 1L & -l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized SecureRandom getSecureRandom() {
        block10: {
            if (cachedSecureRandom != null) {
                return cachedSecureRandom;
            }
            try {
                cachedSecureRandom = SecureRandom.getInstance("SHA1PRNG");
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
                            byte[] byArray = secureRandom.generateSeed(20);
                            SecureRandom secureRandom2 = cachedSecureRandom;
                            synchronized (secureRandom2) {
                                cachedSecureRandom.setSeed(byArray);
                                seeded = true;
                            }
                        }
                        catch (Exception exception) {
                            MathUtils.warn("SecureRandom", exception);
                        }
                    }
                };
                try {
                    Thread thread = new Thread(runnable, "Generate Seed");
                    thread.setDaemon(true);
                    thread.start();
                    Thread.yield();
                    try {
                        thread.join(400L);
                    }
                    catch (InterruptedException interruptedException) {
                        MathUtils.warn("InterruptedException", interruptedException);
                    }
                    if (seeded) break block10;
                    byte[] byArray = MathUtils.generateAlternativeSeed();
                    SecureRandom secureRandom = cachedSecureRandom;
                    synchronized (secureRandom) {
                        cachedSecureRandom.setSeed(byArray);
                    }
                }
                catch (SecurityException securityException) {
                    runnable.run();
                    MathUtils.generateAlternativeSeed();
                }
            }
            catch (Exception exception) {
                MathUtils.warn("SecureRandom", exception);
                cachedSecureRandom = new SecureRandom();
            }
        }
        return cachedSecureRandom;
    }

    public static byte[] generateAlternativeSeed() {
        try {
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeLong(System.currentTimeMillis());
            dataOutputStream.writeLong(System.nanoTime());
            dataOutputStream.writeInt(new Object().hashCode());
            Runtime runtime = Runtime.getRuntime();
            dataOutputStream.writeLong(runtime.freeMemory());
            dataOutputStream.writeLong(runtime.maxMemory());
            dataOutputStream.writeLong(runtime.totalMemory());
            try {
                object = System.getProperties().toString();
                dataOutputStream.writeInt(((String)object).length());
                dataOutputStream.write(((String)object).getBytes("UTF-8"));
            }
            catch (Exception exception) {
                MathUtils.warn("generateAlternativeSeed", exception);
            }
            try {
                object = Class.forName("java.net.InetAddress");
                Object object2 = ((Class)object).getMethod("getLocalHost", new Class[0]).invoke(null, new Object[0]);
                String string = ((Class)object).getMethod("getHostName", new Class[0]).invoke(object2, new Object[0]).toString();
                dataOutputStream.writeUTF(string);
                Object[] objectArray = (Object[])((Class)object).getMethod("getAllByName", String.class).invoke(null, string);
                Method method = ((Class)object).getMethod("getAddress", new Class[0]);
                for (Object object3 : objectArray) {
                    dataOutputStream.write((byte[])method.invoke(object3, new Object[0]));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i2 = 0; i2 < 16; ++i2) {
                int n2 = 0;
                long l2 = System.currentTimeMillis();
                while (l2 == System.currentTimeMillis()) {
                    ++n2;
                }
                dataOutputStream.writeInt(n2);
            }
            dataOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            MathUtils.warn("generateAlternativeSeed", iOException);
            return new byte[1];
        }
    }

    static void warn(String string, Throwable throwable) {
        System.out.println("Warning: " + string);
        if (throwable != null) {
            throwable.printStackTrace();
        }
    }

    public static int nextPowerOf2(int n2) {
        long l2;
        for (l2 = 1L; l2 < (long)n2 && l2 < 0x3FFFFFFFL; l2 += l2) {
        }
        return (int)l2;
    }

    public static int convertLongToInt(long l2) {
        if (l2 <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l2 >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    public static int compareInt(int n2, int n3) {
        return n2 == n3 ? 0 : (n2 < n3 ? -1 : 1);
    }

    public static int compareLong(long l2, long l3) {
        return l2 == l3 ? 0 : (l2 < l3 ? -1 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long secureRandomLong() {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = MathUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextLong();
        }
    }

    public static void randomBytes(byte[] byArray) {
        RANDOM.nextBytes(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] secureRandomBytes(int n2) {
        SecureRandom secureRandom;
        if (n2 <= 0) {
            n2 = 1;
        }
        byte[] byArray = new byte[n2];
        SecureRandom secureRandom2 = secureRandom = MathUtils.getSecureRandom();
        synchronized (secureRandom2) {
            secureRandom.nextBytes(byArray);
        }
        return byArray;
    }

    public static int randomInt(int n2) {
        return RANDOM.nextInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int secureRandomInt(int n2) {
        SecureRandom secureRandom;
        SecureRandom secureRandom2 = secureRandom = MathUtils.getSecureRandom();
        synchronized (secureRandom2) {
            return secureRandom.nextInt(n2);
        }
    }

    static {
        RANDOM = new Random();
    }
}

